/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.TablePartitionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;

class PartitionByPanel
extends BaseEditorPanel<Table> {
    final TablePartitionPanel m_parent;

    PartitionByPanel(TablePartitionPanel parent) {
        this.m_parent = parent;
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_BY");
    }

    @Override
    public void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwType = this.getOrCreateWrapper(PartitionProperty.PARTITION_TYPE);
        layout.add(cwType.getLabel(), 1, 1, false, false);
        layout.add(cwType.getComponent(), 1, 1, false, false);
        layout.nextRow();
        final ComponentWrapper cwCols = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        layout.add(cwCols.getLabel(), 1, 1, false, false);
        layout.add(cwCols.getComponent(), 1, 1, true, true);
        layout.nextRow();
        final ComponentWrapper cwSubType = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        cwSubType.getLabel().setText(UIBundle.get("SUBPARTITION_TYPE_LABEL"));
        layout.add(cwSubType.getLabel(), 1, 1, false, false);
        layout.add(cwSubType.getComponent(), 1, 1, false, false);
        layout.nextRow();
        final ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        layout.add(cwSubCols.getLabel(), 1, 1, false, false);
        layout.add(cwSubCols.getComponent(), 1, 1, true, true);
        layout.nextRow();
        layout.layout();
        cwType.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                cwSubType.refreshObject(cwSubType.getComponentContext().getUpdatedObject());
                cwSubCols.setPropertyValue(new String[0]);
                cwSubType.setPropertyValue(null);
                cwCols.setPropertyValue(new String[0]);
                PartitionByPanel.this.enableControls();
            }
        });
        cwCols.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PartitionByPanel.this.enableControls();
            }
        });
        cwSubType.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                cwSubCols.setPropertyValue(new String[0]);
                PartitionByPanel.this.enableControls();
            }
        });
        cwSubCols.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PartitionByPanel.this.enableControls();
            }
        });
    }

    @Override
    public void initialisePanel() {
        this.enableControls();
    }

    private void enableControls() {
        boolean hasSubType;
        boolean hasCols;
        ComponentWrapper cwCols = this.getOrCreateWrapper(PartitionProperty.PARTITION_COLS);
        ComponentWrapper cwSubType = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_TYPE);
        ComponentWrapper cwSubCols = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_COLS);
        OracleTablePartitions partitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        boolean hasType = this.hasPartitionTypeSet(partitions);
        boolean bl = hasCols = hasType && this.hasPartitionColumns(partitions);
        boolean bl2 = hasType && this.hasPartitionTypeSet(partitions == null ? null : partitions.getSubpartitionModel()) ? true : (hasSubType = false);
        boolean hasSubCols = hasSubType && this.hasPartitionColumns(partitions == null ? null : partitions.getSubpartitionModel());
        Object combo = cwSubType.getActiveComponent();
        boolean hasPossibleSubTypes = combo instanceof JComboBox ? ((JComboBox)combo).getItemCount() > 1 : true;
        cwCols.setEnabled(hasType);
        cwSubType.setEnabled(hasType && hasPossibleSubTypes);
        cwSubCols.setEnabled(hasSubType && hasPossibleSubTypes);
        this.m_parent.enablePartitionDefintionTab(hasCols);
        this.m_parent.enableSubpartitionTemplateTab(hasSubCols);
    }

    private boolean hasPartitionTypeSet(OracleTablePartitions partitions) {
        boolean hasTypeSet = false;
        if (partitions != null && partitions.getProperty("partitionType") != null) {
            hasTypeSet = true;
        }
        return hasTypeSet;
    }

    private boolean hasPartitionColumns(OracleTablePartitions partitions) {
        boolean hasCols = false;
        if (partitions != null) {
            DBObjectID[] cols = (DBObjectID[])partitions.getProperty("partitionColumns");
            hasCols = cols != null && cols.length > 0;
        }
        return hasCols;
    }
}

