/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleTablePartitions;

final class PartitionDescriptionPanel
extends JPanel {
    private final JLabel m_lblPartition = new JLabel();
    private final JLabel m_lblSubPartition = new JLabel();

    PartitionDescriptionPanel() {
        DBUILayoutHelper lh = new DBUILayoutHelper(this, true);
        lh.add(this.m_lblPartition, 1, 1, false, true);
        lh.nextRow();
        lh.add(this.m_lblSubPartition, 1, 1, false, true);
        lh.nextRow();
        lh.pushUp();
        lh.layout();
    }

    void init(OracleTablePartitions otp) {
        this.m_lblPartition.setText(UIBundle.format("PARTITIONS_DESC_MAIN", otp.getPartitionType(), PartitionDescriptionPanel.getColumnList(otp.getPartitionColumns())));
        OracleTablePartitions sp = otp.getSubpartitionModel();
        if (sp != null) {
            this.m_lblSubPartition.setText(UIBundle.format("PARTITIONS_DESC_SUB", sp.getPartitionType(), PartitionDescriptionPanel.getColumnList(sp.getPartitionColumns())));
        } else {
            this.m_lblSubPartition.setText(UIBundle.get("PARTITIONS_DESC_NO_SUB"));
        }
    }

    private static final String getColumnList(DBObjectID[] colIDs) {
        StringBuilder builder = new StringBuilder();
        String comma = ", ";
        for (DBObjectID colID : colIDs) {
            builder.append(DBUtil.getDBObjectName((DBObjectID)colID));
            builder.append(", ");
        }
        String colList = builder.toString();
        int length = colList.length() - ", ".length();
        if (length > 0) {
            return colList.substring(0, length);
        }
        return colList;
    }
}

