/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.javatools.db.Column;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;

class PartitionDetailsPanel
extends ChildObjectEditorPanel<TablePartition, Table> {
    PartitionDetailsPanel(String basePath) {
        super("PartitionDetailsPanel", basePath);
    }

    @Override
    protected void initialiseChildComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        this.initialiseChildComponentsImpl(layout);
        layout.pushUp();
        layout.layout();
    }

    protected final void initialiseChildComponentsImpl(DBUILayoutHelper layout) {
        ComponentWrapper cwName = this.getOrCreateWrapper("name");
        layout.add(cwName.getLabel(), 1, 1, false, false);
        layout.add(cwName.getComponent(), 2, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwValues = this.getOrCreateWrapper("values");
        layout.addChildren(cwValues, 1, 1);
        layout.nextRow();
        ComponentWrapper cwComp = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}));
        layout.add(cwComp.getLabel(), 1, 1, false, false);
        layout.add(cwComp.getComponent(), 2, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwLOBDescriptors = this.getOrCreateWrapper("LOBDescriptors");
        layout.nextColumn();
        layout.add(cwLOBDescriptors.getComponent(), 2, 1, false, false);
        layout.getConstraints((Component)cwLOBDescriptors.getComponent()).anchor = 13;
        layout.nextRow();
        ComponentWrapper cwStorage = this.getOrCreateWrapper("segmentAttributes");
        layout.nextColumn();
        layout.add(cwStorage.getComponent(), 2, 1, false, false);
        layout.getConstraints((Component)cwStorage.getComponent()).anchor = 13;
        layout.nextRow();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ExtendedPartitionType type = ExtendedPartitionType.getType(this.getChildObject());
        ComponentWrapper valuesWrapper = this.getComponentFactory().findComponentWrapper("values");
        if (valuesWrapper != null) {
            valuesWrapper.setVisible(!type.isHash());
        }
        this.enableLobWrapper(true);
    }

    protected final void enableLobWrapper(boolean enable) {
        ComponentWrapper lobWrapper = this.getComponentFactory().findComponentWrapper("LOBDescriptors");
        if (lobWrapper != null) {
            if (!enable) {
                lobWrapper.setEnabled(false);
            } else {
                Column[] cols;
                boolean hasLobCols = false;
                Table table = OraclePartitionsHandler.getOwningTable(this.getUpdatedObject());
                for (Column col : cols = table.getColumns()) {
                    if (!LOBDescriptor.isLOBColumn((Column)col) && !LOBDescriptor.isVARRAYColumn((Column)col)) continue;
                    hasLobCols = true;
                    break;
                }
                lobWrapper.setEnabled(hasLobCols);
            }
        }
    }
}

