/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.panels.partition.PartitionTreeDetailsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.util.ModelUtil;

class PartitionTreeEditorPanel
extends ChildSelectableComponentEditorPanel<TablePartition, Table> {
    private JTree m_tree;
    private static final String[] PROPERTIES = new String[]{PartitionProperty.PARTITIONS, PartitionProperty.SUBPARTITIONS_FOR_PARTITION};

    PartitionTreeEditorPanel() {
        super("PartitionTreeEditorPanel");
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_DEF");
    }

    @Override
    protected void populateComponent() {
        TablePartition[] partitions = (TablePartition[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.PARTITIONS);
        if (partitions != null) {
            for (TablePartition partition : partitions) {
                this.addPartitionNode(partition);
            }
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        TreeNodeMaker.expandAll(this.m_tree);
    }

    @Override
    protected ListButtons createListButtons() {
        ListButtons lb = new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
        final AbstractAction newPartitionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionTreeEditorPanel.this.newMainPartitionNode();
            }
        };
        JMenuItem siblingItem = new JMenuItem(newPartitionAction);
        siblingItem.setText(UIBundle.get("PARTITION_ADD_PARTITION"));
        final AbstractAction newSubpartitionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionTreeEditorPanel.this.newSubpartitionNode();
            }
        };
        JMenuItem childItem = new JMenuItem(newSubpartitionAction);
        childItem.setText(UIBundle.get("PARTITION_ADD_SUBPARTITION"));
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(siblingItem);
        items.add(childItem);
        JToggleButton addButton = ButtonMenu.createButtonMenu((String)"", (Icon)OracleIcons.getIcon((String)"add.png"), items);
        addButton.setName("AddButtonMenu");
        lb.setAddButton(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SelectableComponent sc = PartitionTreeEditorPanel.this.getSelectableComponent();
                int sel = sc.getSelectedIndex();
                if (sel == -1) {
                    newPartitionAction.setEnabled(true);
                    newSubpartitionAction.setEnabled(false);
                } else {
                    DBObject parent = (DBObject)sc.getParent(sc.get(sel));
                    boolean canCreatePartitions = parent instanceof Table;
                    boolean canCreateSubPartitions = false;
                    TablePartition tp = parent instanceof Table ? (TablePartition)sc.get(sel) : (TablePartition)parent;
                    OracleTablePartitions otp = tp.getPartitionLevelSubpartitions();
                    if (otp != null && otp.getPartitions() != null && otp.getPartitions().length > 0) {
                        canCreateSubPartitions = true;
                    } else {
                        OracleTablePartitions main = (OracleTablePartitions)tp.getParent();
                        OracleTablePartitions subs = main.getSubpartitionModel();
                        if (subs != null && !ModelUtil.hasNonNullElement((Object[])subs.getPartitions())) {
                            canCreateSubPartitions = true;
                        }
                    }
                    newPartitionAction.setEnabled(canCreatePartitions);
                    newSubpartitionAction.setEnabled(canCreateSubPartitions);
                }
            }
        });
        return lb;
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        ChildSelectableComponentEditorPanel.DefaultButtonsHelper controller = new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public final boolean canRemove(Object val) {
                if (val instanceof TablePartition) {
                    TablePartition tp = (TablePartition)val;
                    return tp.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE;
                }
                return false;
            }
        };
        return controller;
    }

    @Override
    protected final String getChildProperty() {
        int level = this.getLevel();
        return level == -1 ? null : PROPERTIES[level];
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(this.getUpdatedObject()));
        this.m_tree = new JTree(model);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(DBValidationManager.wrapTreeCellRenderer(this.createItemRenderer(), this.getDataContext()));
        this.m_tree.setShowsRootHandles(true);
        return SelectableComponent.createSelectableComponent(this.m_tree);
    }

    @Override
    protected ChildObjectEditorPanel<TablePartition, Table> createChildPanel() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePartition[] subs = (TablePartition[])PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
                if (subs != null) {
                    TablePartition tp = (TablePartition)PartitionTreeEditorPanel.this.getCurrentChild();
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)PartitionTreeEditorPanel.this.getTreeModel().getRoot();
                    DefaultMutableTreeNode parent = TreeNodeMaker.findNode(tp, root);
                    JCheckBox check = (JCheckBox)e.getSource();
                    if (check.isSelected()) {
                        Object[] children;
                        SelectableComponent sc = PartitionTreeEditorPanel.this.getSelectableComponent();
                        for (Object child : children = sc.getChildren(tp)) {
                            DefaultMutableTreeNode removeMe = TreeNodeMaker.findNode(child, parent);
                            PartitionTreeEditorPanel.this.getTreeModel().removeNodeFromParent(removeMe);
                        }
                        OracleTablePartitions tpSubs = tp.getPartitionLevelSubpartitions();
                        if (tpSubs != null) {
                            tpSubs.setHashQuantity(null);
                            tpSubs.setHashQuantityTablespaceIds(null);
                        }
                        PartitionTreeEditorPanel.this.addSubpartitionNodes(parent, null);
                        PartitionTreeEditorPanel.this.getTreeModel().nodeStructureChanged(parent);
                        PartitionTreeEditorPanel.this.selectChild((ChildDBObject)tp);
                        PartitionTreeEditorPanel.this.commitChildPropertyImpl(false);
                    } else {
                        for (TablePartition sub : subs) {
                            TablePartition newSub = (TablePartition)sub.copyTo(null);
                            newSub.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                            newSub.setParent(null);
                            DefaultMutableTreeNode node = TreeNodeMaker.findNode(sub, parent);
                            node.setUserObject(newSub);
                        }
                        PartitionTreeEditorPanel.this.commitChildPropertyImpl(false);
                        Integer quantity = (Integer)PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
                        if (quantity != null) {
                            OracleTablePartitions tpSubs = tp.getPartitionLevelSubpartitions();
                            if (tpSubs == null) {
                                tpSubs = new OracleTablePartitions(OracleTablePartitions.PartitionType.HASH, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                                tp.setPartitionLevelSubpartitions(tpSubs);
                            }
                            DBObjectID[] ids = (DBObjectID[])PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES);
                            tpSubs.setHashQuantity(quantity);
                            tpSubs.setHashQuantityTablespaceIds(ids);
                        }
                    }
                    PartitionTreeDetailsPanel panel = (PartitionTreeDetailsPanel)PartitionTreeEditorPanel.this.getChildPanel();
                    panel.initialisePanel();
                }
            }
        };
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultMutableTreeNode current = TreeNodeMaker.findNode(PartitionTreeEditorPanel.this.getCurrentChild(), (DefaultMutableTreeNode)PartitionTreeEditorPanel.this.getTreeModel().getRoot());
                PartitionTreeEditorPanel.this.getTreeModel().nodeChanged(current);
            }
        };
        return new PartitionTreeDetailsPanel(al, pcl);
    }

    @Override
    protected Class<TablePartition> getChildClass() {
        return TablePartition.class;
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("PARTITIONS_LIST_TITLE");
    }

    protected TablePartition[] getChildren() {
        return this.getChildrenImpl(true);
    }

    @Override
    protected void commitChildProperty() {
        this.commitChildPropertyImpl(true);
    }

    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.m_tree.getModel();
    }

    private void commitChildPropertyImpl(boolean parentOfSelection) {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        DBObject selectedObject = (DBObject)sc.get(sel);
        Object parent = sel < 0 ? this.getUpdatedObject() : (parentOfSelection ? (DBObject)sc.getParent(selectedObject) : selectedObject);
        OracleTablePartitions partitioning = null;
        if (parent instanceof TablePartition) {
            TablePartition tp = (TablePartition)parent;
            partitioning = tp.getPartitionLevelSubpartitions();
            if (partitioning == null) {
                Table table = OraclePartitionsHandler.getOwningTable((DBObject)tp);
                OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
                partitioning = new OracleTablePartitions(otp.getSubpartitionModel().getPartitionType(), OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                tp.setPartitionLevelSubpartitions(partitioning);
            }
            partitioning.setPartitions(this.getChildrenImpl(parentOfSelection));
        } else if (parent instanceof Table) {
            partitioning = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
            TablePartition[] partitions = this.getChildrenImpl(parentOfSelection);
            partitioning.setPartitions(partitions);
            for (TablePartition tp : partitions) {
                OracleTablePartitions subPartitioning = tp.getPartitionLevelSubpartitions();
                if (subPartitioning == null) continue;
                TablePartition[] subPartitions = this.getPartitions((DBObject)tp);
                subPartitioning.setPartitions(subPartitions);
                if (subPartitions.length != 0) continue;
                tp.setPartitionLevelSubpartitions(null);
            }
        } else {
            throw new IllegalStateException("Unrecognized type in partition tree control");
        }
    }

    private TablePartition[] getChildrenImpl(boolean parentOfSelection) {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        DBObject selectedObject = (DBObject)sc.get(sel);
        Object parent = sel < 0 ? this.getUpdatedObject() : (parentOfSelection ? (DBObject)sc.getParent(selectedObject) : selectedObject);
        return this.getPartitions((DBObject)parent);
    }

    private TablePartition[] getPartitions(DBObject parent) {
        SelectableComponent sc = this.getSelectableComponent();
        Object[] children = sc.getChildren(parent);
        int len = children == null ? 0 : children.length;
        TablePartition[] partitions = new TablePartition[]{};
        if (len > 0 && children[0] instanceof TablePartition && ((TablePartition)children[0]).getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            partitions = new TablePartition[len];
            System.arraycopy(children, 0, partitions, 0, len);
        }
        return partitions;
    }

    private DefaultMutableTreeNode newMainPartitionNode() {
        DefaultMutableTreeNode node = null;
        if (this.exitChildPanel()) {
            Table parent = (Table)this.getUpdatedObject();
            OracleTablePartitions otp = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
            TablePartition tp = (TablePartition)this.newChild();
            tp.setParent((DBObject)otp);
            tp.setPartitionType(otp.getPartitionType());
            tp.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
            node = this.addPartitionNode(tp);
            this.selectChild(tp);
            this.commitChildProperty();
            JTextComponent txt = this.getNameField();
            if (txt != null) {
                txt.requestFocusInWindow();
            }
        }
        return node;
    }

    private void newSubpartitionNode() {
        if (this.exitChildPanel()) {
            TablePartition tp = (TablePartition)this.newChild();
            SelectableComponent tree = this.getSelectableComponent();
            OracleTablePartitions subs = (OracleTablePartitions)this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONING_FOR_TABLE);
            tp.setPartitionType(subs.getPartitionType());
            tp.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
            tp.setParent(null);
            int level = this.getLevel();
            TablePartition[] siblings = this.getChildrenImpl(level == 1);
            ArrayList<String> names = new ArrayList<String>();
            for (TablePartition sibling : siblings) {
                names.add(sibling.getName());
            }
            SelectableComponent sc = this.getSelectableComponent();
            int sel = sc.getSelectedIndex();
            TablePartition selectedPartition = (TablePartition)sc.get(sel);
            TablePartition parent = level == 0 ? selectedPartition : (TablePartition)sc.getParent(selectedPartition);
            StringBuilder builder = new StringBuilder(parent.getName());
            builder.append("_");
            builder.append("SUBPARTITION1");
            tp.setName(DBUtil.getUniqueName(names, (String)builder.toString()));
            if (level == 0) {
                tree.add(sel + 1, tp, SelectableComponent.Placement.Child);
            } else if (level == 1) {
                tree.add(sel + 1, tp, SelectableComponent.Placement.Sibling);
            }
            this.selectChild(tp);
            this.commitChildProperty();
            JTextComponent txt = this.getNameField();
            if (txt != null) {
                txt.requestFocusInWindow();
            }
        }
    }

    private int getLevel() {
        TreePath tp;
        int level = 0;
        if (this.m_tree != null && (tp = this.m_tree.getSelectionPath()) != null) {
            level = tp.getPathCount() - 2;
        }
        return level;
    }

    private DefaultMutableTreeNode addPartitionNode(TablePartition partition) {
        DefaultTreeModel model = this.getTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(partition);
        root.insert(parent, root.getChildCount());
        TablePartition[] subpartitions = (TablePartition[])this.getPropertyHelper().getPropertyValue((Object)partition, PartitionProperty.SUBPARTITIONS);
        this.addSubpartitionNodes(parent, subpartitions);
        int row = model.getIndexOfChild(root, parent);
        this.m_tree.expandRow(row);
        model.nodesWereInserted(root, new int[]{row});
        return parent;
    }

    private void addSubpartitionNodes(DefaultMutableTreeNode parent, TablePartition[] subpartitions) {
        OracleTablePartitions subs;
        TablePartition tp = (TablePartition)parent.getUserObject();
        if (!(subpartitions != null && subpartitions.length != 0 || (subs = tp.getPartitionLevelSubpartitions()) != null && subs.getPartitionType() == OracleTablePartitions.PartitionType.HASH && subs.getHashQuantity() != null)) {
            subpartitions = (TablePartition[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
        }
        if (subpartitions != null) {
            for (TablePartition subpartition : subpartitions) {
                parent.insert(new DefaultMutableTreeNode(subpartition), parent.getChildCount());
            }
        }
    }
}

