/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class SubpartitionsListEditorPanel
extends ChildListEditorPanel<TablePartition, Table> {
    SubpartitionsListEditorPanel() {
        super("PartitionListEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("SUBPARTITIONS_LIST_TITLE");
    }

    @Override
    protected ChildObjectEditorPanel<TablePartition, Table> createChildPanel() {
        return new PartitionDetailsPanel(PartitionProperty.SUBPARTITIONS_FOR_TABLE);
    }

    @Override
    protected Class<TablePartition> getChildClass() {
        return TablePartition.class;
    }

    @Override
    protected String getChildProperty() {
        return PartitionProperty.SUBPARTITIONS_FOR_TABLE;
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    @Override
    protected String getNewChildBaseName() {
        return "SUBPARTITION1";
    }

    @Override
    protected TablePartition newChild() {
        TablePartition tp = (TablePartition)super.newChild();
        this.setObjectType(tp);
        return tp;
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public void removeFromList() {
                super.removeFromList();
                SubpartitionsListEditorPanel.this.setObjectType(null);
            }
        };
    }

    private void setObjectType(TablePartition tp) {
        Table parent = (Table)this.getUpdatedObject();
        OracleTablePartitions otp = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
        OracleTablePartitions subs = otp.getSubpartitionModel();
        OracleTablePartitions.ObjectType ot = tp != null || this.getSelectableComponent().size() > 0 ? OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE : OracleTablePartitions.ObjectType.SUBPARTITION;
        subs.setObjectType(ot);
        if (tp != null) {
            tp.setPartitionType(subs.getPartitionType());
            tp.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            tp.setParent((DBObject)subs);
        }
    }
}

