/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;

public abstract class PlSqlPanel<T extends PlSqlSourceObject>
extends BaseEditorPanel<T> {
    PlSqlPanel(String panelName) {
        super(panelName);
    }

    public void refreshForChange(DBObjectChange change) {
        this.processChange(change);
        DBObjectProvider pro = this.getEditorConfig().getProvider();
        PlSqlSourceObject so = (PlSqlSourceObject)this.getUpdatedObject();
        PlSqlUtil.rebuildSource((DBObjectProvider)pro, (PlSqlSourceObject)so);
        this.ensureBuilt();
        if (SwingUtilities.isEventDispatchThread()) {
            this.initialisePanel();
        } else {
            if (!Thread.currentThread().getName().startsWith("Abbot")) {
                DBLog.getLogger((Object)((Object)this)).warning("refreshForChange not called on the EDT");
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlPanel.this.initialisePanel();
                    }
                });
            }
            catch (Exception e) {
                DBLog.getLogger((Object)((Object)this)).warning(e.getMessage());
            }
        }
    }

    @Override
    protected void refreshComponents() {
        this.ensureBuilt();
        super.refreshComponents();
    }

    private void ensureBuilt() {
        DBObjectProvider pro = this.getEditorConfig().getProvider();
        PlSqlSourceObject so = (PlSqlSourceObject)this.getUpdatedObject();
        SchemaObjectBuilder sb = new SchemaObjectBuilder(false);
        sb.buildDerivedProperties(pro);
        sb.setProperties(so.getType(), "comments");
        sb.ensureObjectBuilt(new SystemObject[]{so});
    }

    protected void processChange(DBObjectChange change) {
    }

    @Override
    protected String getCustomPanelKey() {
        return PlSqlPanel.class.getName();
    }

    @Override
    protected void initialisePanel() {
        PlSqlSourceObject pso = (PlSqlSourceObject)this.getUpdatedObject();
        if (pso != null) {
            SchemaObjectBuilder sob = new SchemaObjectBuilder(true);
            sob.buildDerivedProperties(this.getProvider());
            try {
                if (sob.ensureObjectBuilt(new SystemObject[]{pso})) {
                    sob.ensureDerivedPropertiesBuiltEx((DBObject)pso);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "failed to build derived props", dbe);
            }
        }
    }
}

