/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.List;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.plsql.PlSqlPanel;
import oracle.ideimpl.db.panels.plsql.TriggerBaseObjectIdPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;

public class TriggerPanel
extends PlSqlPanel<Trigger> {
    private boolean m_listening = false;

    public TriggerPanel() {
        super("TriggerPanel");
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwEnabled = this.getOrCreateWrapper("enabled");
        ComponentWrapper cwBaseType = this.getOrCreateWrapper("baseType");
        ComponentWrapper cwBaseObjectID = this.getOrCreateWrapper("baseObjectID");
        ComponentWrapper cwTimimg = this.getOrCreateWrapper("timing");
        ComponentWrapper cwEvents = this.getOrCreateWrapper("events");
        ComponentWrapper cwStatementLevel = this.getOrCreateWrapper("statementLevel");
        ComponentWrapper cwReferencingNewAs = this.getOrCreateWrapper("referencingNewAs");
        ComponentWrapper cwReferencingOldAs = this.getOrCreateWrapper("referencingOldAs");
        ComponentWrapper cwWhenClause = this.getOrCreateWrapper("whenClause");
        ComponentWrapper cwColumnIDs = this.getOrCreateWrapper("columnIDs");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        if (this.isInFlatEditor()) {
            layout.add(cwEnabled.getComponent());
            layout.nextRow();
        }
        layout.add(cwBaseType.getLabel());
        layout.add(cwBaseType.getComponent(), 3, 1);
        layout.nextRow();
        layout.addChildren(cwBaseObjectID, 1, 3);
        layout.nextRow();
        layout.add(cwTimimg.getLabel());
        layout.add(cwTimimg.getComponent(), 3, 1);
        layout.nextRow();
        layout.add(cwEvents.getLabel());
        layout.add(cwEvents.getComponent(), 3, 1, true, true);
        layout.nextRow();
        layout.add(cwColumnIDs.getLabel());
        layout.add(cwColumnIDs.getComponent(), 3, 1, true, true);
        layout.nextRow();
        layout.add(cwReferencingOldAs.getLabel());
        layout.add(cwReferencingOldAs.getComponent());
        layout.add(cwStatementLevel.getComponent(), 2, 1);
        layout.nextRow();
        layout.add(cwReferencingNewAs.getLabel());
        layout.add(cwReferencingNewAs.getComponent());
        layout.add(cwWhenClause.getLabel());
        layout.add(cwWhenClause.getComponent());
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        SwingDBObjectListener retval = null;
        if (!this.isInFlatEditor()) {
            this.m_listening = true;
            retval = new SwingDBObjectListener(){

                @Override
                protected void updateUI(DBObjectChange change) {
                    if (TriggerPanel.this.m_listening) {
                        TriggerPanel.this.m_listening = false;
                        TriggerPanel.this.processChange(change);
                        TriggerPanel.this.initialisePanel();
                        TriggerPanel.this.m_listening = true;
                    }
                }
            };
        }
        return retval;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ComponentWrapper cwBaseType = this.getOrCreateWrapper("baseType");
        ComponentWrapper cwBaseObjectID = this.getOrCreateWrapper("baseObjectID");
        Trigger.BaseType baseType = ((Trigger)this.getUpdatedObject()).getBaseType();
        cwBaseType.setEnabled(!this.isEditing());
        ((TriggerBaseObjectIdPanel)cwBaseObjectID.getActiveComponent()).setBaseType(((Trigger)this.getUpdatedObject()).getBaseType());
        PropertyManager pm = this.getProvider().getPropertyManager();
        PropertyHelper ph = this.getPropertyHelper();
        if (pm != null) {
            for (ComponentWrapper comp : this.getComponentFactory().getComponentWrappers()) {
                if (comp == cwBaseType) continue;
                comp.processComponent(this.isEditable(), true);
                comp.setPropertyValue(ph.getPropertyValue(this.getUpdatedObject(), comp.getPropertyName()));
            }
        }
        if (baseType == Trigger.BaseType.TABLE) {
            ComponentWrapper cwColumnIDs = this.getOrCreateWrapper("columnIDs");
            List<String> list = Arrays.asList(((Trigger)this.getUpdatedObject()).getEvents());
            boolean update = list.contains("UPDATE");
            cwColumnIDs.setEnabled(update);
            if (!update) {
                cwColumnIDs.setPropertyValue(null);
            }
            ComponentWrapper cwWhenClause = this.getOrCreateWrapper("whenClause");
            cwWhenClause.setEnabled(!((Trigger)this.getUpdatedObject()).isStatementLevel());
        }
    }

    @Override
    protected void processChange(DBObjectChange change) {
        PropertyChangeEvent baseTypeChangeEvent = change.getPropertyChange("baseType");
        if (baseTypeChangeEvent != null) {
            ((Trigger)this.getUpdatedObject()).setColumnIDs(new DBObjectID[0]);
            ((Trigger)this.getUpdatedObject()).setEvents(new String[0]);
            if (baseTypeChangeEvent.getNewValue() == Trigger.BaseType.VIEW) {
                ((Trigger)this.getUpdatedObject()).setTiming(Trigger.Timing.INSTEAD_OF);
            } else if (baseTypeChangeEvent.getOldValue() == Trigger.BaseType.VIEW) {
                ((Trigger)this.getUpdatedObject()).setTiming(Trigger.Timing.BEFORE);
            }
            if (baseTypeChangeEvent.getNewValue() == Trigger.BaseType.SCHEMA) {
                Schema schema = ((Trigger)this.getUpdatedObject()).getSchema();
                DBObjectID id = schema.getID();
                if (id == null) {
                    try {
                        schema = this.getProvider().getSchema(schema.getName());
                        id = schema.getID();
                    }
                    catch (DBException e) {
                        DBLog.getLogger((Object)((Object)this)).warning(e.getMessage());
                    }
                }
                ((Trigger)this.getUpdatedObject()).setBaseObjectID(id);
            }
        }
    }
}

