/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import javax.swing.JPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;

public abstract class BaseSQLQueryPickerPanel
extends SelectDBObjectsPanel {
    private String[] m_types;
    private SQLQueryBuilder m_builder;
    private boolean m_declarativeLayoutDone;
    private SchemaObject m_sObj;
    private boolean m_canAlwaysNext = true;
    private Namespace m_dataContext;

    protected BaseSQLQueryPickerPanel() {
    }

    protected BaseSQLQueryPickerPanel(boolean canAlwaysNext) {
        this.m_canAlwaysNext = canAlwaysNext;
    }

    protected final Namespace getDataContext() {
        return this.m_dataContext;
    }

    protected final SQLQueryBuilder getBuilder() {
        return this.m_builder;
    }

    protected final SchemaObject getSchemaObject() {
        DBEditorConfig config = (DBEditorConfig)this.m_dataContext.get(DBEditorConfig.class);
        SystemObject newObject = config.getUpdatedObject();
        if (newObject == null) {
            newObject = config.getChildObject();
        }
        return DBUtil.getSchemaObject((DBObject)newObject);
    }

    @Override
    protected final String[] getAvailableTypes() {
        if (this.m_types == null) {
            this.m_types = new String[]{"ALIAS", "MATERIALIZED VIEW", "SYNONYM", "TABLE", "VIEW"};
        }
        return this.m_types;
    }

    @Override
    public final void init(boolean providerChanged, TraversableContext dataContext) {
        DBEditorConfig config = (DBEditorConfig)dataContext.get(DBEditorConfig.class);
        DBObjectProvider prov = config.getProvider();
        this.m_dataContext = dataContext;
        super.init(providerChanged, dataContext);
        SQLQuery query = BaseSQLQueryBuilderPanel.findAndBuildQuery(config);
        this.m_builder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)this.getProvider(), (Schema)config.getSchema());
        String messageOnly = this.getLayoutOnlyMessage(query, this.m_builder);
        if (messageOnly != null) {
            this.clearToPicker();
            this.getShuttle().setEnabled(false);
            BaseSQLQueryBuilderPanel.layoutMessageOnly((JPanel)((Object)this), messageOnly);
            this.m_declarativeLayoutDone = false;
        } else {
            if (!this.m_declarativeLayoutDone) {
                this.removeAll();
                this.layoutComponents();
                this.m_declarativeLayoutDone = true;
            }
            this.getShuttle().setEnabled(true);
            this.initToPicker(this.m_builder, this.getProvider(), config.getSchema());
        }
    }

    protected String getLayoutOnlyMessage(SQLQuery query, SQLQueryBuilder builder) {
        String retval = null;
        if (this.m_builder == null || !query.isDeclarative()) {
            retval = UIBundle.get("QUERY_DECL_FAIL");
        } else if (query.getSetOperator() != null) {
            retval = UIBundle.get("QUICK_PICK_AND_SET_CANT_SET");
        }
        return retval;
    }

    protected abstract void clearToPicker();

    protected abstract void initToPicker(SQLQueryBuilder var1, DBObjectProvider var2, Schema var3);

    @Override
    public final void commit(TraversableContext dataContext) throws TraversalException {
        if (this.m_builder != null) {
            this.commitToPicker(dataContext);
        }
    }

    protected abstract void commitToPicker(TraversableContext var1) throws TraversalException;

    @Override
    protected boolean canFinish() {
        return true;
    }

    @Override
    protected boolean canAlwaysNext() {
        return this.m_canAlwaysNext;
    }
}

