/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLQueryOwner;

public class FromFromPicker
extends DBObjectSourcePicker {
    private SQLQueryOwner m_sqlQueryOwner;

    public FromFromPicker() {
        super(null, true, false);
        this.m_dbRenderer = new Renderer();
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_nodeMaker.setDeepFKs(true);
        this.m_nodeMaker.setChildTypes(new String[]{"FKConstraint"});
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    @Override
    protected String getComponentNamePrefix() {
        return "FromFromPicker";
    }

    @Override
    public void removeSelectedItems() {
        DefaultMutableTreeNode node;
        TreePath[] sel = this.m_tree.getSelectionPaths();
        if (sel != null && sel.length == 1 && (node = (DefaultMutableTreeNode)sel[0].getLastPathComponent()).getUserObject() instanceof Relation) {
            this.m_tree.expandPath(sel[0]);
        }
        super.removeSelectedItems();
    }

    public void setSQLQueryOwner(SQLQueryOwner view) {
        this.m_sqlQueryOwner = view;
    }

    @Override
    protected SystemObject[] filterAndSort(SystemObject[] objs) {
        if (this.m_sqlQueryOwner != null && objs != null) {
            int index = -1;
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof SQLQueryOwner) || !objs[i].getName().equals(this.m_sqlQueryOwner.getName())) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                SchemaObject[] newObjs = new SchemaObject[objs.length - 1];
                System.arraycopy(objs, 0, newObjs, 0, index);
                System.arraycopy(objs, index + 1, newObjs, index, newObjs.length - index);
                objs = newObjs;
            }
        }
        return super.filterAndSort(objs);
    }

    @Override
    public Transferable createTransferable(TreePath treePath) {
        DBObjectTransferable t = (DBObjectTransferable)super.createTransferable(treePath);
        if (t.getDBObject() instanceof FKConstraint) {
            t = null;
        }
        return t;
    }

    private class Renderer
    extends DBObjectRenderer {
        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent retval = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (obj instanceof Relation) {
                    DBObjectRenderer.setToolTipText(retval, UIBundle.get("PICKER_EXPAND_RELATION"));
                } else if (obj instanceof FKConstraint) {
                    DBObjectRenderer.setToolTipText(retval, UIBundle.get("PICKER_EXPAND_FK"));
                } else {
                    DBObjectRenderer.setToolTipText(retval, null);
                }
            }
            return retval;
        }
    }
}

