/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.javatools.db.Column;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class GroupByFromPicker
extends AbstractTreePicker {
    private DBObjectRenderer m_dbRenderer = new DBObjectRenderer();
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(false);
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_treeModel;
    private JTree m_tree;
    private Transferable[] m_all;
    private Map m_nodes = new HashMap();
    static DataFlavor TRANSFERABLE_FLAVOR = new DataFlavor(GroupByTransferable.class, "Column");

    public GroupByFromPicker() {
        this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
        this.m_treeModel = new DefaultTreeModel(this.m_top);
        this.m_tree = new JTree(this.m_treeModel);
        this.setTree(this.m_tree);
        this.m_tree.setRootVisible(false);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.getSelectionModel().setSelectionMode(4);
    }

    public void setBuilder(SQLQueryBuilder builder) {
        this.m_top.removeAllChildren();
        RelationUsage[] relus = builder.getRelationUsages();
        for (int i = 0; i < relus.length; ++i) {
            this.m_top.add(this.m_nodeMaker.createTreeNode((SQLFragment)relus[i].getParent(), true));
        }
        this.m_treeModel.reload();
    }

    @Override
    public Transferable[] getAllSelectableItems() {
        if (this.m_all == null) {
            ArrayList<GroupByTransferable> ts = new ArrayList<GroupByTransferable>();
            Enumeration<TreeNode> kids = this.m_top.children();
            while (kids.hasMoreElements()) {
                DefaultMutableTreeNode kid = (DefaultMutableTreeNode)kids.nextElement();
                FromObject from = (FromObject)kid.getUserObject();
                Enumeration<TreeNode> colKids = kid.children();
                while (colKids.hasMoreElements()) {
                    DefaultMutableTreeNode colKid = (DefaultMutableTreeNode)colKids.nextElement();
                    Column col = (Column)colKid.getUserObject();
                    ts.add(new GroupByTransferable(col, from));
                }
            }
            this.m_all = ts.toArray(new Transferable[ts.size()]);
        }
        return this.m_all;
    }

    @Override
    public boolean addSelectedItems(Transferable[] trans) {
        return true;
    }

    @Override
    public void removeSelectedItems() {
    }

    @Override
    public void removeAllSelectableItems() {
    }

    @Override
    public Transferable createTransferable(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof Column) {
            FromObject from = (FromObject)((DefaultMutableTreeNode)node.getParent()).getUserObject();
            GroupByTransferable t = new GroupByTransferable((Column)obj, from);
            this.m_nodes.put(t, node);
            return t;
        }
        return null;
    }

    class GroupByTransferable
    implements Transferable {
        private Column m_col;
        private FromObject m_from;

        GroupByTransferable(Column col, FromObject from) {
            this.m_col = col;
            this.m_from = from;
        }

        public Column getColumn() {
            return this.m_col;
        }

        public FromObject getFromObject() {
            return this.m_from;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.m_col;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TRANSFERABLE_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == TRANSFERABLE_FLAVOR;
        }
    }
}

