/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.JTextComponentUndoSupport;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.ora.SQLQueryOwnerPanelLibrary;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class SQLQueryComponentPanel
extends JPanel {
    private final JLabel m_queryLabel = new JLabel();
    private final BasicEditorPane m_query = EditorFactory.createIdeEditorPane();
    private SearchField m_search = new SearchField(SearchField.Style.FIND);
    private final JLabel m_feedbackLabel = new JLabel();
    private ReadOnlyScrollPane m_feedback;
    private JTextComponentUndoSupport m_undo;
    private final JButton m_edit = new JButton();
    private final JButton m_test = new JButton();
    private final JButton m_liveTest = new JButton();
    private SQLQueryTester m_liveTester;
    private final JButton m_revert = new JButton();
    private final Collection<SQLQueryListener> m_listeners;
    private ComponentContext m_context;
    private String m_originalText;
    private final DocumentListener m_queryTextListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            SQLQueryComponentPanel.this.notifyListeners();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SQLQueryComponentPanel.this.notifyListeners();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };

    public SQLQueryComponentPanel() {
        this.m_listeners = new ArrayList<SQLQueryListener>();
        this.addButtonListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_queryLabel.setEnabled(enabled);
        this.m_query.setEnabled(enabled);
        this.m_feedbackLabel.setEnabled(enabled);
        this.m_feedback.setEnabled(enabled);
        this.m_edit.setEnabled(enabled);
        this.m_test.setEnabled(enabled);
        this.m_liveTest.setEnabled(enabled);
        this.m_revert.setEnabled(enabled && this.canRevertBeEnabled());
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_queryLabel.setVisible(visible);
        this.m_query.setVisible(visible);
        this.m_test.setVisible(visible);
        this.m_liveTest.setVisible(visible);
        this.m_revert.setVisible(visible);
        if (!visible) {
            this.m_feedbackLabel.setVisible(visible);
            this.m_feedback.setVisible(visible);
        }
    }

    public void initialisePanel(ComponentContext context) {
        this.m_context = context;
        DBUILayoutHelper layout = new DBUILayoutHelper(this, context.isInFlatEditor());
        layout.setMarginTop(0);
        DBUIResourceHelper reshelp = new DBUIResourceHelper("QueryPanel");
        reshelp.setName(this, context.getPropertyName());
        JScrollPane scroll = new JScrollPane((Component)this.m_query);
        reshelp.resLabel(this.m_queryLabel, scroll, UIBundle.get("QUERY_LABEL"), "QueryText");
        layout.add(this.m_queryLabel, 2, 1, false, false);
        layout.nextRow();
        layout.add((Component)this.m_search, 1, 1, true, false);
        layout.pushLeft();
        if (context.isInFlatEditor()) {
            reshelp.resButton(this.m_edit, UIBundle.get("QUERY_EDIT"), "QueryEdit");
            layout.add(this.m_edit);
        } else {
            reshelp.resButton(this.m_revert, UIBundle.get("QUERY_REVERT"), "Revert");
            layout.add(this.m_revert);
        }
        reshelp.resButton(this.m_liveTest, UIBundle.get("QUERY_TEST"), "LiveTest");
        ToolTipManager.sharedInstance().registerComponent(this.m_liveTest);
        layout.add(this.m_liveTest);
        layout.nextRow();
        int COLSIZE = 5;
        this.configureEditor();
        JScrollPane toAdd = scroll;
        if (context.isInFlatEditor()) {
            ResizeComponent rc = new ResizeComponent((JComponent)scroll);
            rc.setPreferredSize(new Dimension(400, 100));
            toAdd = rc;
        }
        layout.add(toAdd, 5, 1, true, true);
        layout.nextRow();
        reshelp.resButton(this.m_test, UIBundle.get("QUERY_CHECK"), "Test");
        layout.add(this.m_test);
        layout.nextRow();
        this.m_feedback = new ReadOnlyScrollPane();
        reshelp.resLabel(this.m_feedbackLabel, this.m_feedback.getTextArea(), UIBundle.get("QUERY_FEEDBACK"), "Results");
        this.m_feedback.setBorder(null);
        this.m_feedback.setMinimumSize(new Dimension(0, 50));
        layout.add(this.m_feedbackLabel, 5, 1);
        layout.nextRow();
        layout.add(this.m_feedback, 5, 1, true, false);
        layout.getConstraints((Component)this.m_feedback).anchor = 18;
        layout.layout();
        this.initQuery();
    }

    private void configureEditor() {
        this.m_undo = new JTextComponentUndoSupport((JTextComponent)this.m_query);
        DBObjectProvider pro = this.m_context.getProvider();
        Schema schema = this.m_context.getEditorConfig().getSchema();
        final FindHighlightPlugin find = new FindHighlightPlugin();
        find.install(this.m_query);
        this.m_query.setLanguageSupport("foo.sql");
        DBInsightContext insightContext = new DBInsightContext();
        insightContext.setProvider(pro);
        insightContext.setSchema(schema);
        insightContext.setContextObject((DBObject)this.m_context.getEditorConfig().getUpdatedObject());
        insightContext.setIncludeReservedWords(true);
        DBCompletionSupportFactory.getCompletionSupport(insightContext, this.getIdeContextForInsight(), (JTextComponent)this.m_query);
        this.ensureInActionMap("select-all");
        this.ensureInActionMap("insert-break");
        this.m_search.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                find.clearFindHighlighting();
            }
        });
        this.m_search.addSearchListener(new SearchListener(){

            public void searchCategoryChanged(SearchEvent se) {
                find.clearFindHighlighting();
            }

            public void searchPerformed(SearchEvent se) {
                String searchText = se.getSearchText();
                if (ModelUtil.hasLength((String)searchText)) {
                    int i = find.findText(searchText, SQLQueryComponentPanel.this.m_query.getCaretPosition() + 1, se.getDirection() == SearchEvent.Direction.FORWARD, false, true, true);
                    if (i >= 0) {
                        SQLQueryComponentPanel.this.setSelection(i, searchText.length());
                        SQLQueryComponentPanel.this.m_query.requestFocusInWindow();
                    }
                } else {
                    find.clearFindHighlighting();
                }
            }
        });
    }

    private Context getIdeContextForInsight() {
        Context ideContext = Context.newIdeContext();
        DBObjectNode origNode = this.m_context.getEditorConfig().getOriginalObjectNode();
        Node editNode = null;
        editNode = origNode instanceof Node ? (Node)origNode : new Node();
        ideContext.setNode(editNode);
        return ideContext;
    }

    private void ensureInActionMap(String action) {
        Action foundAction;
        ActionMap map = this.m_query.getActionMap();
        if (map.get(action) == null && (foundAction = ((BasicEditorKit)this.m_query.getEditorKit()).findAction(action)) != null) {
            map.put(action, foundAction);
        }
    }

    public String getQueryString() {
        return this.getTextComponent().getText();
    }

    public void setQueryString(String queryText) {
        this.m_query.setEditable(true);
        if (queryText == null) {
            SQLQuery query = new SQLQuery();
            query.setDeclarative(true);
            String sql = query.getSQLText();
            this.m_originalText = sql == null ? "" : sql.trim();
            queryText = sql;
        } else if (!ModelUtil.hasLength((String)this.m_originalText)) {
            this.m_originalText = queryText;
        }
        this.setQueryTextImpl(queryText);
    }

    private void setQueryTextImpl(String queryText) {
        String existing = this.m_query.getText();
        if (ModelUtil.areDifferent((Object)existing, (Object)queryText)) {
            this.m_query.setText(queryText);
            this.m_undo.clearUndo();
            this.m_query.setCaretPosition(0, true);
        }
    }

    private void setSelection(int start, int length) {
        try {
            this.m_query.setCaretPosition(start, true);
            this.m_query.setSelectionStart(start);
            this.m_query.setSelectionEnd(length + start);
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(Level.FINE, "Selection error", e);
        }
    }

    void setSelection(SQLFragment frag) {
        Integer start;
        if (frag != null && (start = frag.getStartOffset()) != null) {
            this.setSelection(start, frag.getSQLText().length());
        }
    }

    public boolean addQueryListener(SQLQueryListener listener) {
        if (listener != null) {
            return this.m_listeners.add(listener);
        }
        return false;
    }

    public boolean removeQueryListener(SQLQueryListener listener) {
        if (listener != null) {
            return this.m_listeners.remove(listener);
        }
        return false;
    }

    private boolean canRevertBeEnabled() {
        return ModelUtil.hasLength((String)this.m_originalText) && !this.m_originalText.equals("SELECT \n    \nFROM \n    \n") && !this.m_originalText.equals(this.getTextComponent().getText());
    }

    private void addButtonListeners() {
        this.m_edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLQueryOwner owner = (SQLQueryOwner)SQLQueryComponentPanel.this.m_context.getUpdatedObject();
                SQLQueryEditDialog dlg = new SQLQueryEditDialog(owner.getType() == "MATERIALIZED VIEW");
                SQLQuery query = owner.getSQLQuery();
                String oldQueryText = query.getQueryString();
                SQLQuery copy = (SQLQuery)query.copyTo(null, (IDPolicy)new IDPolicy.SameIDPolicy());
                dlg.editQuery(copy, SQLQueryComponentPanel.this.m_context.getProvider(), DBUtil.getSchema((DBObject)owner));
                String newQueryText = copy.getQueryString();
                if (!oldQueryText.equals(newQueryText)) {
                    copy.copyTo((Object)query);
                    SQLQueryComponentPanel.this.setQueryTextImpl(newQueryText);
                    SQLQueryComponentPanel.this.notifyListeners();
                } else {
                    SQLQueryComponentPanel.this.copyToSilently(copy, query);
                }
            }
        });
        this.m_revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLQueryComponentPanel.this.initQuery();
                SQLQueryComponentPanel.this.getTextComponent().requestFocusInWindow();
                SQLQueryComponentPanel.this.notifyListeners();
            }
        });
        this.m_liveTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLQueryTester.Result result;
                if (SQLQueryComponentPanel.this.m_liveTester == null) {
                    DBObjectProvider pro = SQLQueryComponentPanel.this.m_context.getProvider();
                    boolean db = pro instanceof Database;
                    SQLQueryComponentPanel.this.m_liveTester = new SQLQueryTester(db ? (Database)pro : null, true);
                    SQLQueryComponentPanel.this.m_liveTester.setShowConnectionPicker(!db);
                }
                String ttt = (result = SQLQueryComponentPanel.this.m_liveTester.showDialog(SQLQueryComponentPanel.this.m_liveTest, SQLQueryComponentPanel.this.getTextComponent().getText())) == null ? null : result.getMessage();
                SQLQueryComponentPanel.this.m_liveTest.setToolTipText(ttt);
            }
        });
        this.m_test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLQueryComponentPanel.this.testQuery();
            }
        });
    }

    private void notifyListeners() {
        this.m_revert.setEnabled(this.canRevertBeEnabled());
        for (SQLQueryListener listener : this.m_listeners) {
            listener.queryUpdated();
        }
    }

    public final JTextComponent getTextComponent() {
        return this.m_query;
    }

    public final JLabel getLabel() {
        return this.m_queryLabel;
    }

    public final Component[] getEditingComponents() {
        return new Component[]{this.getTextComponent(), this.m_revert};
    }

    private void initQuery() {
        this.m_query.getDocument().removeDocumentListener(this.m_queryTextListener);
        if (ModelUtil.hasLength((String)this.m_originalText)) {
            this.setQueryTextImpl(this.m_originalText);
        } else {
            this.setQueryTextImpl("SELECT \n    \nFROM \n    \n");
        }
        this.m_query.getDocument().addDocumentListener(this.m_queryTextListener);
        this.m_revert.setEnabled(false);
        this.m_feedback.setText(null, false);
        this.m_feedbackLabel.setVisible(false);
        this.m_feedback.setVisible(false);
        this.validate();
    }

    protected boolean isCheckSyntaxDeclarative() {
        boolean retval = true;
        PanelLibrary lib = (PanelLibrary)this.m_context.getDataContext().find(PanelLibrary.class);
        if (lib instanceof SQLQueryOwnerPanelLibrary) {
            retval = ((SQLQueryOwnerPanelLibrary)lib).showDeclarativePanels();
        }
        return retval;
    }

    private void testQuery() {
        this.m_feedbackLabel.setVisible(true);
        this.m_feedback.setVisible(true);
        final String sql = this.getTextComponent().getText().trim();
        DBObjectProvider pro = this.m_context.getProvider();
        final DBObject dbObject = this.m_context.getUpdatedObject();
        SchemaObject so = DBUtil.getSchemaObject((DBObject)dbObject);
        Schema schema = DBUtil.getSchema((DBObject)so);
        final SQLQuery testSQLQuery = new SQLQuery(sql);
        if (so instanceof SQLQueryOwner) {
            testSQLQuery.setParent((DBObject)((SQLQueryOwner)so));
        }
        final SQLQueryBuilder builder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)testSQLQuery, (DBObjectProvider)pro, (Schema)schema);
        final Holder builtHolder = new Holder((Object)false);
        final Holder feedbackHolder = new Holder();
        final ProgressBar pbar = new ProgressBar((Component)this.m_test, this.m_test.getText(), null, true);
        pbar.setCancelable(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String feedback;
                try {
                    if (SQLQueryComponentPanel.this.isCheckSyntaxDeclarative()) {
                        builder.buildQuery(testSQLQuery);
                        builtHolder.set((Object)true);
                        OrderByObject[] ob = testSQLQuery.getOrderByObjects();
                        feedback = dbObject instanceof MaterializedView && ob != null && ob.length > 0 ? UIBundle.get("QUERY_ORDER_BY_ON_MV") : UIBundle.get("QUERY_SUCCESS");
                    } else {
                        OracleSQLQueryBuilderHelper.checkSyntax((String)sql);
                        feedback = UIBundle.get("QUERY_SUCCESS");
                    }
                }
                catch (SQLParseException spe) {
                    feedback = spe.getMessage();
                }
                catch (SQLQueryClauseException sqe) {
                    feedback = sqe.getMessage();
                }
                catch (SQLQueryCancelledException sqce) {
                    feedback = null;
                }
                catch (SQLQueryException sqe) {
                    StringBuilder message = new StringBuilder();
                    message.append(UIBundle.get("QUERY_TOO_CLEVER"));
                    message.append("\n\n").append(sqe.getMessage());
                    feedback = message.toString();
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error parsing sql query", e);
                    feedback = null;
                }
                feedbackHolder.set((Object)feedback);
                pbar.setDoneStatus();
            }
        };
        pbar.setRunnable(runnable);
        pbar.start(null, null, 1500);
        String feedback = (String)feedbackHolder.get();
        if (pbar.hasUserCancelled() && feedback == null) {
            builder.cancelCurrentBuild(testSQLQuery);
            feedback = new SQLQueryCancelledException(null).getMessage();
        }
        if (feedback != null) {
            this.m_feedback.setText(feedback, true);
            if (Boolean.TRUE.equals(builtHolder.get())) {
                DBObject obj = this.m_context.getUpdatedObject();
                this.copyToSilently(testSQLQuery, obj instanceof SQLQueryOwner ? ((SQLQueryOwner)obj).getSQLQuery() : (SQLQuery)obj);
            }
            this.validate();
        }
    }

    private void copyToSilently(final SQLQuery other, final SQLQuery query) {
        if (other.isDeclarative() && !query.isDeclarative()) {
            DBLog.getLogger((Object)this).fine("Preserving declarative copy for query");
            DBUtil.invokeCompoundChange((DBObject)query, (Runnable)new Runnable(){

                @Override
                public void run() {
                    other.copyTo((Object)query);
                }
            }, (boolean)false);
        }
    }

    public static interface SQLQueryListener {
        public void queryUpdated();
    }
}

