/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.BaseEditorTabTable;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public class ColumnConstraintsTablePanel
extends BaseEditorTabTable<Column, Table> {
    public ColumnConstraintsTablePanel() {
        this("ColumnConstraintsTablePanel", "columns");
        this.setDefaultRenderer((TableCellRenderer)((Object)new ConstraintsPanel.ConstraintTypeCellRenderer()), ConstraintsPanel.ConstraintType.class);
    }

    ColumnConstraintsTablePanel(String panelName, String childProperty) {
        super(panelName, childProperty);
    }

    protected String getChildProperty() {
        return "constraints";
    }

    @Override
    public final void setChildContext(Column contextColumn) {
        Relation rel;
        Object value;
        this.clearRows();
        int rowIndx = 0;
        if (contextColumn != null && (value = (rel = (Relation)this.getParentObject()).getProperty(this.getChildProperty())) instanceof Object[]) {
            for (Object obj : (Object[])value) {
                if (!(obj instanceof DBObject)) continue;
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)((DBObject)obj), (DBObjectProvider)this.getProvider());
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)((Object)this)).fine(dbe.getMessage());
                }
                Collection refs = DBUtil.getReferenceIDs((DBObject)((DBObject)obj), (boolean)true, (DBUtil.IDQuery)DBUtil.IDQuery.INTERNAL, (String[])new String[]{"COLUMN"});
                if (refs == null) continue;
                ArrayList<DBObjectID> allColumns = new ArrayList<DBObjectID>();
                boolean found = false;
                for (DBObjectID ref : refs) {
                    allColumns.add(ref);
                    if (!ref.equals(contextColumn.getID(), true)) continue;
                    found = true;
                }
                if (!found) continue;
                this.addObjectRow(rowIndx++, (DBObject)obj, contextColumn, allColumns);
            }
        }
    }

    @Override
    protected void configureToolBar(TableToolbar toolbar) {
        toolbar.setLabel(UIBundle.get("COL_CON_TAB_TITLE"));
    }

    @Override
    protected String[] getColumnNames() {
        return new String[]{UIBundle.get("COL_CON_TAB_COLUMNNAME"), UIBundle.get("COL_CON_TAB_TYPE"), UIBundle.get("COL_CON_TAB_OTHER_COLS")};
    }

    @Override
    protected Class[] getColumnTypes() {
        return new Class[]{String.class, ConstraintsPanel.ConstraintType.class, String.class};
    }

    protected void addObjectRow(int rowIndx, DBObject obj, Column contextColumn, List<DBObjectID> allColumns) {
        String restOfCols = this.getRestOfColumnsText(allColumns, contextColumn);
        String name = obj.getName();
        ConstraintsPanel.ConstraintType constraintType = ConstraintsPanel.ConstraintType.valueOf(((Constraint)obj).getConstraintType());
        this.addRow(rowIndx, new Object[]{name, constraintType, restOfCols.toString()});
    }

    protected final String getRestOfColumnsText(List<DBObjectID> allColumns, Column contextColumn) {
        StringBuilder restOfCols = new StringBuilder();
        for (DBObjectID colId : allColumns) {
            DBObject col;
            if (colId.equals(contextColumn.getID())) continue;
            if (restOfCols.length() != 0) {
                restOfCols.append(",");
            }
            String colName = null;
            if (colId instanceof TemporaryObjectID) {
                try {
                    col = colId.resolveID();
                    if (col != null) {
                        colName = col.getName();
                    }
                }
                catch (DBException dbe) {}
            } else if (colId instanceof BaseObjectID) {
                colName = ((BaseObjectID)colId).getName();
            }
            if (colName == null && (col = (Column)((Table)this.getParentObject()).findOwnedObject(colId)) != null) {
                colName = col.getName();
            }
            restOfCols.append(colName);
        }
        return restOfCols.toString();
    }

    public class ColumnConstraintsCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String propName;
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && column == 1 && ModelUtil.hasLength((String)(propName = "constraintType"))) {
                this.setText(PropertyDisplayRegistry.getPropValueDisplay(propName, value));
            }
            return cell;
        }
    }
}

