/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.TableWithTabbedChildSplitPane;
import oracle.ideimpl.db.panels.table.ColumnsTabsPanel;
import oracle.ideimpl.db.panels.table.CopyColumnPanel;
import oracle.ideimpl.db.panels.table.SimpleCreateTablePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.icons.OracleIcons;

public class ColumnsTableEditorPanel
extends SimpleCreateTablePanel {
    private static final int NO_TAB = -1;
    private static final int DEFAULT_TAB = 0;

    public ColumnsTableEditorPanel() {
        super("ColumnsTableEditorPanel");
        this.getWrapperTable().putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.addToolBarButton(this.createCopyButton());
    }

    @Override
    protected boolean useSplitter() {
        return true;
    }

    @Override
    protected JComponent createSplitPane(Component topComponent, Component bottomComponent) {
        TableWithTabbedChildSplitPane splitter = new TableWithTabbedChildSplitPane(topComponent, (ColumnsTabsPanel)((Object)bottomComponent));
        return splitter;
    }

    @Override
    protected ChildObjectEditorPanel<Column, Table> createChildPanel() {
        return new ColumnsTabsPanel(this.isInFlatEditor() ? 0 : -1);
    }

    protected JButton createCopyButton() {
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnsTableEditorPanel.this.showCopyDialog();
            }
        };
        copyAction.putValue("SmallIcon", OracleIcons.getIcon((String)"copy.png"));
        copyAction.putValue("ShortDescription", UIBundle.get("COLUMN_INFO_TOOLTIP_COPY_COLS"));
        JButton retval = new JButton();
        retval.setAction(copyAction);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCopyDialog() {
        if (this.exitChildPanel()) {
            int buttonMask = 7;
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIBundle.format("COPY_COLUMN_TITLE", ((Table)this.getUpdatedObject()).getName()), (int)7);
            CopyColumnPanel panel = new CopyColumnPanel(this.getProvider(), (Relation)this.getUpdatedObject(), this.isEditing());
            dialog.setContent((Component)panel);
            try {
                if (dialog.runDialog()) {
                    for (Column col : panel.getSelectedColumns()) {
                        col.setName(DBUtil.getUniqueName(this.getChildNames(), (String)this.getNewChildBaseName()));
                        this.addChildRow(col);
                    }
                }
            }
            finally {
                dialog.dispose();
            }
        }
    }
}

