/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.panels.ChildTableTabPanel;
import oracle.ideimpl.db.panels.table.ColumnConstraintsTablePanel;
import oracle.ideimpl.db.panels.table.ColumnIndexesPanel;
import oracle.ideimpl.db.panels.table.ColumnPropertiesTabPanel;
import oracle.ideimpl.db.panels.table.DataTypeEditorPanel;
import oracle.ideimpl.db.panels.table.IdentityColumnMutExControlPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;

public class ColumnsTabsPanel
extends ChildTableTabPanel<Column, Table> {
    public ColumnsTabsPanel(int defaultTabIndex) {
        super("ColumnsTabPanel", "columns", defaultTabIndex);
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"dataTypeUsage", Property.createPath((String[])new String[]{"dataTypeUsage", "dataTypeID"}), "default"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                if (propertyName.startsWith("dataTypeUsage")) {
                    Column col = (Column)obj;
                    ColumnsTabsPanel.this.setEnabledTab(ColumnPropertiesTabPanel.class, LOBDescriptor.isLOBColumn((Column)col) || LOBDescriptor.isVARRAYColumn((Column)col));
                }
            }
        };
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"constraints", "indexes"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                ColumnsTabsPanel.this.onTabEntry();
            }
        };
    }

    @Override
    protected void enableTabs() {
        Column col = (Column)this.getChildObject();
        this.setEnabledTab(ColumnPropertiesTabPanel.class, col != null && (LOBDescriptor.isLOBColumn((Column)col) || LOBDescriptor.isVARRAYColumn((Column)col)));
    }

    @Override
    protected Collection<Navigable> getTabs() {
        Navigable[] navs;
        PanelLibrary lib;
        PropertyManager mgr = this.getProvider().getPropertyManager();
        Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        ArrayList<Navigable> tabNavs = new ArrayList<Navigable>();
        Navigable dtTab = this.createNavigable(UIBundle.get("COLUMN_INFO_LABEL_DATATYPE"), DataTypeEditorPanel.class, "dataTypeUsage", Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties"}), Property.createPath((String[])new String[]{"OracleColumnProperties", "XMLTypeColumnProperties"}));
        tabNavs.add(dtTab);
        if (tableType != Table.TableType.EXTERNAL) {
            if (mgr.canCreateProperty((SystemObject)this.getUpdatedObject(), "constraints")) {
                Navigable constraintsTab = this.createNavigable(UIBundle.get("CONSTRAINTS_INFO_TITLE"), ColumnConstraintsTablePanel.class, new String[0]);
                tabNavs.add(constraintsTab);
            }
            if (mgr.canCreateProperty((SystemObject)this.getUpdatedObject(), "indexes")) {
                Navigable indexesTab = this.createNavigable(UIBundle.get("INDEX_PANEL_TITLE"), ColumnIndexesPanel.class, new String[0]);
                tabNavs.add(indexesTab);
            }
            if (mgr.canCreateProperty((SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), "OracleColumnProperties"}))) {
                Navigable colPropsTab = this.createNavigable(UIBundle.get("LOB_PARAM_PANEL_TITLE"), ColumnPropertiesTabPanel.class, Property.createPath((String[])new String[]{"OracleColumnProperties", "LOBProperties"}), Property.createPath((String[])new String[]{"OracleColumnProperties", "VAProperties"}));
                tabNavs.add(colPropsTab);
            }
            if (IdentityColumnMutExControlPanel.isShowPanel((Table)this.getUpdatedObject(), this.getProvider())) {
                Navigable identityTab = this.createNavigable(UIBundle.get("IDENTITY_COLUMN_PANEL_TITLE"), IdentityColumnMutExControlPanel.class, "identityProperties");
                tabNavs.add(identityTab);
            }
        }
        if ((lib = (PanelLibrary)this.getDataContext().find(PanelLibrary.class)) != null && (navs = lib.getDefaultPanels(true)) != null) {
            for (Navigable nav : navs) {
                tabNavs.add(nav);
            }
        }
        return tabNavs;
    }
}

