/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.BooleanPropertyComponentWrapper;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.components.NumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedNumberComponentWrapper;
import oracle.ideimpl.db.controls.NumberTextFieldUnlimited;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public class DataTypeEditorPanel
extends ChildObjectEditorPanel<Column, Table> {
    private static String DATATYPES_SEPARATOR = "--------";
    private LayoutChoice m_currentLayout;
    private boolean m_listening;
    private final boolean m_singleColEditOnly;
    private TypeComboListMember m_lastSelected;
    private final JRadioButton m_rdbSimpleType = new JRadioButton();
    private final JRadioButton m_rdbComplexType = new JRadioButton();
    private final JRadioButton m_rdbVirtual = new JRadioButton();
    private final JPanel m_typePanel = new JPanel();
    private final JLabel m_lblType = new JLabel();
    private final JComboBox m_cmbType = new DataTypesComboBox();
    private final JLabel m_lblSchemas = new JLabel();
    private final DBObjectChooser m_cmbSchemas = new DBObjectChooser("SCHEMA");
    private final JLabel m_lblComplexType = new JLabel();
    private final DBObjectChooser m_cmbComplexType = new DBObjectChooser(this.m_cmbSchemas, "TYPE");
    private final DefaultComboBoxModel m_mdlTypes = new NonNullableComboBoxModel();
    private final TypeComboListMember m_derivedDataType = new TypeComboListMember(true);
    private final DataTypeAttributesCWFactory m_attribsCWFactory;

    public DataTypeEditorPanel() {
        this(false);
    }

    DataTypeEditorPanel(boolean singleColEditOnly) {
        super("DataTypeEditorPanel", "columns");
        this.m_singleColEditOnly = singleColEditOnly;
        ActionListener rdbActionList = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LayoutChoice choice;
                if (DataTypeEditorPanel.this.m_listening && (choice = DataTypeEditorPanel.this.getChoiceFromRadios()) != DataTypeEditorPanel.this.m_currentLayout) {
                    DataTypeEditorPanel.this.resetColumnModel(choice);
                    DataTypeEditorPanel.this.syncUIFromModel(choice);
                    Component comp = DataTypeEditorPanel.this.getDefaultFocusComponent(choice);
                    if (comp != null) {
                        comp.requestFocusInWindow();
                    }
                }
            }
        };
        this.m_rdbComplexType.addActionListener(rdbActionList);
        this.m_rdbSimpleType.addActionListener(rdbActionList);
        this.m_rdbVirtual.addActionListener(rdbActionList);
        this.m_cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTypeEditorPanel.this.m_listening) {
                    DataType dataType = DataTypeEditorPanel.this.getSelectedSimpleType();
                    DataTypeEditorPanel.this.setDataTypeInModel(dataType);
                    DataTypeEditorPanel.this.syncUIFromModel(DataTypeEditorPanel.this.m_currentLayout);
                }
            }
        });
        this.m_cmbComplexType.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (DataTypeEditorPanel.this.m_listening) {
                    Type dataType = DataTypeEditorPanel.this.getSelectedComplexType();
                    DataTypeEditorPanel.this.setDataTypeInModel((DataType)dataType);
                    if (dataType == null) {
                        DataTypeEditorPanel.this.layoutAttributesOnly();
                    } else {
                        DataTypeEditorPanel.this.syncUIFromModel(LayoutChoice.COMPLEX);
                    }
                }
            }
        });
        this.m_attribsCWFactory = new DataTypeAttributesCWFactory();
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            protected void updateUI(DBObjectChange change) {
                Map objsChanged;
                DBObjectChange dtuChange;
                if (DataTypeEditorPanel.this.m_listening && (dtuChange = (DBObjectChange)(objsChanged = change.getOwnedObjectsUpdated()).get(((Column)change.getDBObject()).getDataTypeUsage())) != null) {
                    DataTypeEditorPanel.this.handleDataTypeUsageUpdates(dtuChange);
                }
            }
        };
    }

    private void handleDataTypeUsageUpdates(DBObjectChange dtuChange) {
        PropertyChangeEvent dtPce;
        PropertyChangeEvent precisionPce;
        String size = Property.createPath((String[])new String[]{"attributeValues", "size"});
        String precision = Property.createPath((String[])new String[]{"attributeValues", "precision"});
        PropertyChangeEvent sizePce = dtuChange.getPropertyChange(size);
        if (sizePce != null) {
            this.m_attribsCWFactory.setAttributeWrapperValue("size", sizePce.getNewValue());
        }
        if ((precisionPce = dtuChange.getPropertyChange(precision)) != null) {
            this.m_attribsCWFactory.setAttributeWrapperValue("precision", precisionPce.getNewValue());
        }
        if ((dtPce = dtuChange.getPropertyChange("dataTypeID")) != null) {
            TypeComboListMember comboTyp = new TypeComboListMember(this.getDataTypeFromModel(), "TOP");
            this.m_listening = false;
            this.m_mdlTypes.setSelectedItem(comboTyp);
            this.syncUIFromModel(null);
            this.m_listening = true;
        }
    }

    @Override
    public void initialiseComponents() {
        DBUIResourceHelper helper = this.getComponentFactory().getResourceHelper();
        helper.resLabel(this.m_lblType, this.m_cmbType, UIBundle.get("COLUMN_INFO_NAME_TYPE"), "SimpleTypeList");
        helper.resLabel(this.m_lblComplexType, this.m_cmbComplexType, UIBundle.get("COLUMN_INFO_NAME_TYPE"), "ComplexTypeList");
        helper.resLabel(this.m_lblSchemas, this.m_cmbSchemas, UIBundle.get("COLUMN_INFO_LABEL_SCHEMA"), "ComplexTypeSchema");
        helper.resButton(this.m_rdbSimpleType, UIBundle.get("COLUMN_INFO_LABEL_SIMPLE"), "SimpleType");
        helper.resButton(this.m_rdbComplexType, UIBundle.get("COLUMN_INFO_LABEL_COMPLEX"), "ComplexType");
        helper.resButton(this.m_rdbVirtual, UIBundle.get("COLUMN_INFO_LABEL_VIRTUAL_COLUMN"), "Virtual");
        this.m_cmbType.setModel(this.m_mdlTypes);
        this.fixAccessibleName(this.m_rdbSimpleType);
        this.fixAccessibleName(this.m_rdbComplexType);
        this.fixAccessibleName(this.m_rdbVirtual);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbSimpleType);
        bg.add(this.m_rdbComplexType);
        bg.add(this.m_rdbVirtual);
        this.m_rdbSimpleType.setSelected(true);
        DBObjectProvider prov = this.getProvider();
        DataTypeEditorPanel.populateDataTypeModel(prov, this.m_mdlTypes);
        this.m_cmbSchemas.setProvider(prov);
        this.m_cmbComplexType.setProvider(prov);
        this.m_cmbComplexType.enableProviderListener(true);
        ComponentWrapper cwVirtual = this.getOrCreateWrapper("virtualExpressionSource");
    }

    private void fixAccessibleName(JRadioButton radio) {
        AccessibleContext ac = radio.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(UIBundle.get("COLUMN_INFO_LABEL_DATATYPE") + " " + radio.getText());
        }
    }

    @Override
    public void initialiseChildComponents() {
        if (this.getChildObject() != null) {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            if (this.m_singleColEditOnly || this.isInFlatEditor()) {
                this.layoutComponents(layout);
            } else {
                JPanel dtPanel = new JPanel();
                DBUILayoutHelper dtLayout = new DBUILayoutHelper(dtPanel, this.isInFlatEditor());
                dtLayout.setMargins(0);
                this.layoutComponents(dtLayout);
                dtLayout.layout();
                JScrollPane scrollPane = new JScrollPane(dtPanel, 20, 31);
                scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                layout.add(scrollPane, 1, 3, true, true);
            }
            layout.pushUp();
            layout.layout();
        } else {
            this.removeAll();
        }
    }

    private void layoutComponents(DBUILayoutHelper layout) {
        DBUILayoutHelper typeButtons = layout.newChildHelper("typeRadioButtons", 2, 1, false, false);
        typeButtons.add(this.m_rdbSimpleType);
        typeButtons.add(this.m_rdbComplexType);
        typeButtons.add(this.m_rdbVirtual);
        typeButtons.pushLeft();
        typeButtons.layout();
        layout.nextRow();
        layout.add(this.m_typePanel, 1, 1, true, true);
        layout.layout();
    }

    @Override
    public void initialisePanel() {
        this.m_lastSelected = null;
        super.initialisePanel();
        this.syncUIFromModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUIFromModel(LayoutChoice forceLayout) {
        Column col = (Column)this.getChildObject();
        this.m_listening = false;
        if (col != null) {
            try {
                LayoutChoice layoutfromModel;
                DBObjectProvider prov = this.getProvider();
                ComponentWrapper cwVirtual = this.getOrCreateWrapper("virtualExpressionSource");
                PropertyManager pm = prov.getPropertyManager();
                Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
                boolean external = tableType == Table.TableType.EXTERNAL;
                boolean canChangeDef = false;
                canChangeDef = this.getOriginalObject() == null ? pm.canCreateProperty((SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{"columns", "default"})) : pm.canAlterProperty((SystemObject)this.getOriginalObject(), (SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{"columns", "default"}));
                this.m_rdbVirtual.setEnabled(canChangeDef && !external);
                cwVirtual.setEnabled(canChangeDef && !external);
                this.m_rdbVirtual.setVisible(cwVirtual.isSupported());
                cwVirtual.refreshObject((DBObject)col);
                boolean isVirtual = cwVirtual.isSupported() && col.getVirtualExpressionSource() != null;
                DataType dataType = this.getDataTypeFromModel();
                this.m_mdlTypes.removeElement(this.m_derivedDataType);
                if (dataType instanceof Type) {
                    layoutfromModel = LayoutChoice.COMPLEX;
                    this.initComplexTypeCombos();
                    this.m_cmbSchemas.setDBObject((DBObject)((Type)dataType).getSchema());
                    this.m_cmbComplexType.setDBObject((DBObject)dataType);
                } else {
                    TypeComboListMember selectedType = this.getSelectedTypeComboListMember(dataType);
                    if (isVirtual) {
                        layoutfromModel = LayoutChoice.VIRTUAL;
                        if (col.getID() instanceof TemporaryObjectID) {
                            TemporaryObjectID id = (TemporaryObjectID)col.getID();
                            try {
                                DBObject orig = id.resolveOriginalID();
                                if (orig == null || !(prov instanceof Database)) {
                                    this.m_mdlTypes.insertElementAt(this.m_derivedDataType, 0);
                                }
                            }
                            catch (DBException dbe) {
                                DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
                            }
                        }
                        if (dataType == null) {
                            selectedType = this.m_derivedDataType;
                        }
                    } else {
                        layoutfromModel = LayoutChoice.SIMPLE;
                    }
                    this.m_cmbType.getModel().setSelectedItem(selectedType);
                    this.m_lastSelected = selectedType;
                }
                boolean supportsTypes = prov.supportsObjectType("TYPE");
                boolean supportsComplexTypes = supportsTypes && !external;
                this.m_rdbSimpleType.setVisible(supportsComplexTypes);
                this.m_rdbComplexType.setVisible(supportsComplexTypes);
                this.m_lblSchemas.setEnabled(supportsComplexTypes);
                this.m_cmbSchemas.setEnabled(supportsComplexTypes);
                this.m_lblComplexType.setEnabled(supportsComplexTypes);
                this.m_cmbComplexType.setEnabled(supportsComplexTypes);
                this.layoutTypePanel(forceLayout == null ? layoutfromModel : forceLayout);
            }
            finally {
                this.m_listening = true;
            }
        }
    }

    private TypeComboListMember getSelectedTypeComboListMember(DataType dataType) {
        TypeComboListMember selectedType = (TypeComboListMember)this.m_mdlTypes.getSelectedItem();
        if (!(selectedType != null && DBUtil.areNamesAndTypesEqual((DBObject)selectedType.getDataType(), (DBObject)dataType) || this.m_mdlTypes.getIndexOf(selectedType = new TypeComboListMember(dataType, "TOP")) != -1)) {
            selectedType.setPosition("BOTTOM");
        }
        return selectedType;
    }

    private void layoutTypePanel(LayoutChoice layoutChoice) {
        if (this.m_currentLayout == layoutChoice && this.m_typePanel.getComponentCount() > 0) {
            this.layoutAttributesOnly();
        } else {
            this.m_typePanel.removeAll();
            this.m_attribsCWFactory.clearWrappers();
            DBUILayoutHelper dtLayout = new DBUILayoutHelper(this.m_typePanel, this.isInFlatEditor());
            dtLayout.setMargins(0);
            this.m_currentLayout = layoutChoice;
            if (layoutChoice == LayoutChoice.COMPLEX) {
                this.m_rdbComplexType.getModel().setSelected(true);
                dtLayout.add(this.m_lblSchemas);
                dtLayout.add(this.m_cmbSchemas);
                dtLayout.nextRow();
                dtLayout.add(this.m_lblComplexType);
                dtLayout.add(this.m_cmbComplexType);
                dtLayout.nextRow();
                this.layoutComplexAttributes(dtLayout);
            } else {
                if (layoutChoice == LayoutChoice.VIRTUAL) {
                    this.m_rdbVirtual.getModel().setSelected(true);
                    ComponentWrapper cwVirtual = this.getOrCreateWrapper("virtualExpressionSource");
                    JLabel virtExpLabel = cwVirtual.getLabel();
                    dtLayout.add(virtExpLabel);
                    dtLayout.getConstraints((Component)virtExpLabel).anchor = 18;
                    Component virtExpField = cwVirtual.getComponent();
                    virtExpField.setPreferredSize(new Dimension(200, 40));
                    dtLayout.add(virtExpField, 3, 1, true, false);
                    dtLayout.nextRow();
                } else {
                    this.m_rdbSimpleType.getModel().setSelected(true);
                }
                dtLayout.add(this.m_lblType);
                dtLayout.add(this.m_cmbType);
                dtLayout.nextRow();
                this.layoutSimpleAttributes(dtLayout);
            }
            dtLayout.layout();
            this.layoutChanged();
        }
    }

    private void layoutChanged() {
        DBUIMnemonicBuilder builder = new DBUIMnemonicBuilder((JPanel)((Object)this));
        if (this.isInFlatEditor()) {
            builder.removeAll();
        } else {
            builder.build();
        }
        this.validate();
        this.repaint();
    }

    private void layoutAttributesOnly() {
        this.m_attribsCWFactory.clearWrappers();
        DBUILayoutHelper dtLayout = new DBUILayoutHelper(this.m_typePanel, this.isInFlatEditor());
        if (this.m_currentLayout == LayoutChoice.VIRTUAL) {
            dtLayout.setReuseExistingLayout(4);
            this.layoutSimpleAttributes(dtLayout);
        } else if (this.m_currentLayout == LayoutChoice.COMPLEX) {
            dtLayout.setReuseExistingLayout(3);
            this.layoutComplexAttributes(dtLayout);
        } else {
            dtLayout.setReuseExistingLayout(2);
            this.layoutSimpleAttributes(dtLayout);
        }
        dtLayout.layout();
        this.layoutChanged();
    }

    private boolean layoutSimpleAttributes(DBUILayoutHelper dtLayout) {
        DataTypeAttribute[] attributes;
        DataType dataType = this.getDataTypeFromModel();
        if (dataType != null && (attributes = dataType.getDataTypeAttributes()) != null && attributes.length > 0) {
            int numComponents = 0;
            for (DataTypeAttribute attrib : attributes) {
                if (this.m_singleColEditOnly || numComponents > 0 && numComponents % 2 == 0) {
                    dtLayout.nextRow();
                }
                if (!attrib.isDeclarable()) continue;
                ComponentWrapper cw = this.m_attribsCWFactory.createWrapper(attrib);
                dtLayout.add(cw);
                GridBagConstraints constraints = dtLayout.getConstraints(cw.getComponent());
                constraints.fill = 2;
                ++numComponents;
            }
        }
        dtLayout.pushUp();
        return true;
    }

    private boolean layoutComplexAttributes(DBUILayoutHelper dtLayout) {
        ComponentWrapper cwExtraProps;
        DataType dataType = this.getDataTypeFromModel();
        if (dataType instanceof Type && (cwExtraProps = this.m_attribsCWFactory.createComplexWrapper((Type)dataType)) != null) {
            dtLayout.addChildren(cwExtraProps, new Integer[0]);
        }
        dtLayout.pushUp();
        return true;
    }

    private Type getSelectedComplexType() {
        return (Type)this.m_cmbComplexType.getDBObject();
    }

    private DataType getSelectedSimpleType() {
        Object selected = this.m_mdlTypes.getSelectedItem();
        if (selected instanceof TypeComboListMember) {
            return ((TypeComboListMember)selected).getDataType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDataTypeInModel(DataType dataType) {
        this.m_listening = false;
        try {
            Column col = (Column)this.getChildObject();
            if (col != null) {
                DataTypeUsage dtu = col.getDataTypeUsage();
                if (dtu == null && dataType != null) {
                    dtu = new DataTypeUsage();
                    col.setDataTypeUsage(dtu);
                }
                if (dtu != null) {
                    DataTypeEditorPanel.setDataType(dtu, dataType);
                }
            }
        }
        finally {
            this.m_listening = true;
        }
    }

    private Component getDefaultFocusComponent(LayoutChoice choice) {
        Component retval;
        if (choice == LayoutChoice.VIRTUAL) {
            ComponentWrapper cw = this.getOrCreateWrapper("virtualExpressionSource");
            retval = cw.getActiveComponent();
        } else {
            retval = choice == LayoutChoice.COMPLEX ? (this.getSelectedComplexType() == null ? this.m_cmbSchemas.getDefaultFocusComponent() : this.m_cmbComplexType.getDefaultFocusComponent()) : this.m_cmbType;
        }
        return retval;
    }

    private LayoutChoice getChoiceFromRadios() {
        LayoutChoice retval = this.m_rdbComplexType.isSelected() ? LayoutChoice.COMPLEX : (this.m_rdbVirtual.isSelected() ? LayoutChoice.VIRTUAL : LayoutChoice.SIMPLE);
        return retval;
    }

    private DataType getDataTypeFromModel() {
        DataTypeUsage dtu;
        DataType retval = null;
        Column col = (Column)this.getChildObject();
        if (col != null && (dtu = col.getDataTypeUsage()) != null) {
            try {
                retval = DataTypeHelper.getDataType((DataTypeUsage)dtu);
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)((Object)this)).fine(dbe.getMessage());
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetColumnModel(LayoutChoice choice) {
        Column col = (Column)this.getChildObject();
        if (col != null) {
            this.m_listening = false;
            try {
                DataType dataType = null;
                if (choice == LayoutChoice.VIRTUAL) {
                    col.setVirtualExpressionSource("");
                } else {
                    col.setVirtualExpressionSource(null);
                    if (choice == LayoutChoice.COMPLEX) {
                        this.initComplexTypeCombos();
                        dataType = this.getSelectedComplexType();
                    } else {
                        Iterator iter;
                        dataType = this.getSelectedSimpleType();
                        if (dataType == null && (iter = this.getProvider().getDescriptor().listPreferredDataTypes().iterator()).hasNext()) {
                            dataType = (DataType)iter.next();
                        }
                    }
                }
                this.setDataTypeInModel(dataType);
            }
            finally {
                this.m_listening = true;
            }
        }
    }

    private void initComplexTypeCombos() {
        if (this.getSelectedComplexType() == null) {
            SchemaObject so = null;
            try {
                so = (SchemaObject)this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria((String)"TYPE", (String)"SYS", (String)"XMLTYPE"));
            }
            catch (DBException e) {
                this.getLogger().info(e.getMessage());
            }
            if (so == null) {
                Schema schema = DBUtil.getSchema(this.getUpdatedObject());
                if (schema != null) {
                    this.m_cmbSchemas.setDBObject((DBObject)schema);
                }
                this.m_cmbComplexType.setDBObject(null);
            } else {
                this.m_cmbSchemas.setDBObject((DBObject)((Type)so).getSchema());
                this.m_cmbComplexType.setDBObject((DBObject)((Type)so));
            }
        }
    }

    public static void setDataType(DataTypeUsage dtu, DataType dataType) {
        DBObjectID dtID;
        DBObjectID dBObjectID = dtID = dataType == null ? null : dataType.getID();
        if (ModelUtil.areDifferent((Object)dtu.getDataTypeID(), (Object)dtID)) {
            dtu.getParent().setProperty("OracleColumnProperties", null);
            if (dataType != null) {
                dtu.setDataTypeID(dtID);
                dataType.createDefaultUsage().copyTo((Object)dtu);
            } else {
                dtu.setDataTypeID(null);
                dtu.setAttributeValues(null);
            }
        }
    }

    public static void populateDataTypeModel(DBObjectProvider prov, DefaultComboBoxModel model) {
        if (model.getSize() < 1) {
            DataType[] types = prov.listSupportedDataTypes();
            TreeSet<DataType> sortedTypes = new TreeSet<DataType>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof PredefinedDataType && o2 instanceof Type) {
                        return -1;
                    }
                    if (o1 instanceof Type && o2 instanceof PredefinedDataType) {
                        return 1;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (int i = 0; i < types.length; ++i) {
                sortedTypes.add(types[i]);
            }
            Collection topTypes = prov.getDescriptor().listPreferredDataTypes();
            if (topTypes != null && topTypes.size() > 0) {
                for (DataType topType : topTypes) {
                    TypeComboListMember currTyp = new TypeComboListMember(topType, "TOP");
                    model.addElement(currTyp);
                }
                model.addElement(DATATYPES_SEPARATOR);
            }
            Iterator iterTypes = sortedTypes.iterator();
            while (iterTypes.hasNext()) {
                TypeComboListMember currTyp = new TypeComboListMember((DataType)iterTypes.next(), "BOTTOM");
                model.addElement(currTyp);
            }
        }
    }

    public static class DataTypesComboBox
    extends JComboBox {
        public DataTypesComboBox() {
            this.setRenderer(new DataTypeListRenderer());
        }

        @Override
        public void setSelectedIndex(int index) {
            int currIndex = this.getSelectedIndex();
            if (this.isSeparatorSelected(index)) {
                index = currIndex < index ? ++index : --index;
            }
            super.setSelectedIndex(index);
        }

        private boolean isSeparatorSelected(int index) {
            Object selected = this.getModel().getElementAt(index);
            return selected instanceof String && selected.equals(DATATYPES_SEPARATOR);
        }

        private class DataTypeListRenderer
        extends BasicComboBoxRenderer {
            private DataTypeListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c;
                if (DataTypesComboBox.this.isSeparatorSelected(index)) {
                    c = super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
                    c.setEnabled(false);
                } else {
                    c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    c.setEnabled(true);
                }
                return c;
            }
        }
    }

    public class CheckBoxOrNumberAttributeComponentWrapper
    extends UnlimitedNumberComponentWrapper {
        private String m_attributeValue;

        public CheckBoxOrNumberAttributeComponentWrapper(String attributeValue) {
            this.m_attributeValue = attributeValue;
        }

        @Override
        protected void initialiseComponent() {
            ((NumberTextFieldUnlimited)this.getActiveComponent()).setCheckBoxLabel(this.m_attributeValue);
        }

        @Override
        public Object getPropertyValue() {
            Object retval = super.getPropertyValue();
            if (retval == Integer.valueOf(0)) {
                retval = this.m_attributeValue;
            }
            return retval;
        }

        @Override
        public void setPropertyValue(Object val) {
            if (val != null && val.equals(this.m_attributeValue)) {
                val = 0;
            }
            super.setPropertyValue(val);
        }
    }

    public class DataTypeAttributeBooleanComponentWrapper
    extends BooleanPropertyComponentWrapper {
        private String m_attributeValue;

        public DataTypeAttributeBooleanComponentWrapper(String attributeValue) {
            this.m_attributeValue = attributeValue;
        }

        @Override
        public Object getPropertyValue() {
            String retval = null;
            if (((JCheckBox)this.getActiveComponent()).isSelected()) {
                retval = this.m_attributeValue;
            }
            return retval;
        }

        @Override
        public void setPropertyValue(Object val) {
            ((JCheckBox)this.getActiveComponent()).setSelected(val != null);
        }
    }

    private class DataTypeAttributesCWFactory {
        private final Map<String, ComponentWrapper> m_wrappers = new HashMap<String, ComponentWrapper>();
        private final List<String> m_paths = new ArrayList<String>();

        private DataTypeAttributesCWFactory() {
        }

        ComponentWrapper createComplexWrapper(Type type) {
            String propName = null;
            if (XMLTypeColumnProperties.isXMLType((DataType)type)) {
                propName = Property.createPath((String[])new String[]{"OracleColumnProperties", "XMLTypeColumnProperties"});
            } else if (DataTypeHelper.isTableType((DataType)type)) {
                propName = Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties"});
            }
            ComponentWrapper retval = null;
            if (propName != null) {
                retval = DataTypeEditorPanel.this.getOrCreateWrapper(propName);
                retval.initialise(this.createComponentContext(propName));
                retval.setActive(true);
                this.m_paths.add(propName);
            }
            return retval;
        }

        private ComponentWrapper createWrapper(DataTypeAttribute attribute) {
            ComponentContext attribCtxt = this.createComponentContext(attribute);
            String attribName = attribute.getName();
            ComponentWrapper retval = null;
            int attribType = attribute.getValueType();
            switch (attribType) {
                case 1: {
                    retval = new NumberPropertyComponentWrapper();
                    break;
                }
                case 0: {
                    String[] attributeValues = attribute.getValues();
                    if (attributeValues == null) {
                        retval = new TextPropertyComponentWrapper.SingleLineTextWrapper();
                        break;
                    }
                    if (attributeValues.length == 1 && !attribute.isExtensible() && attribute.getDefaultValue() == null) {
                        retval = new DataTypeAttributeBooleanComponentWrapper(attributeValues[0]);
                        break;
                    }
                    retval = new EnumPropertyComponentWrapper();
                    break;
                }
                case 2: {
                    String[] attributeValues = attribute.getValues();
                    if (attributeValues == null || attributeValues.length == 0) {
                        retval = new NumberPropertyComponentWrapper();
                        break;
                    }
                    if (attributeValues.length == 1) {
                        retval = new CheckBoxOrNumberAttributeComponentWrapper(attributeValues[0]);
                        break;
                    }
                    throw new UnsupportedOperationException("Integer with combo not currently implemented for datatype attributes.");
                }
            }
            if (retval == null) {
                throw new IllegalStateException("Failed to create component for attribute value \"" + attribName + "\"" + " with value type " + attribType + ".");
            }
            retval.initialise(attribCtxt);
            retval.setActive(true);
            retval.setPropertyDisplayName(attribute.getLabel());
            DataTypeEditorPanel.this.getComponentFactory().registerComponentWrapper(retval);
            this.m_paths.add(retval.getPropertyName());
            this.m_wrappers.put(attribName, retval);
            return retval;
        }

        private String createAttributePath(String attribute) {
            return Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", attribute});
        }

        private ComponentContext createComponentContext(DataTypeAttribute attribute) {
            String propPath = this.createAttributePath(attribute.getName());
            return this.createComponentContext(propPath);
        }

        private ComponentContext createComponentContext(String propPath) {
            Column child = (Column)DataTypeEditorPanel.this.getChildObject();
            DBObjectID childID = child.getID();
            Column original = null;
            if (childID instanceof TemporaryObjectID) {
                original = (Column)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)childID));
            }
            ComponentContext cc = DataTypeEditorPanel.this.getComponentFactory().createComponentContext(propPath, (DBObject)original, (DBObject)child);
            cc.setBasePath("columns");
            return cc;
        }

        private void setAttributeWrapperValue(String attribName, Object attribValue) {
            ComponentWrapper wrapper = this.m_wrappers.get(attribName);
            if (wrapper != null) {
                wrapper.setPropertyValue(attribValue);
            }
        }

        private void clearWrappers() {
            for (String propPath : this.m_paths) {
                DataTypeEditorPanel.this.getComponentFactory().removeComponentWrapper(propPath);
            }
            this.m_paths.clear();
            this.m_wrappers.clear();
        }
    }

    public static class TypeComboListMember {
        private final DataType m_dataType;
        private String m_position;
        private boolean m_derived;
        public static final String BOTTOM_OF_LIST = "BOTTOM";
        public static final String TOP_OF_LIST = "TOP";

        public TypeComboListMember(DataType dataType, String position) {
            this.m_dataType = dataType;
            this.m_position = position;
            this.m_derived = false;
        }

        public TypeComboListMember(boolean derived) {
            this(null, TOP_OF_LIST);
            this.m_derived = derived;
        }

        public boolean equals(Object obj) {
            boolean retval = false;
            if (obj instanceof TypeComboListMember) {
                retval = DBUtil.areNamesAndTypesEqual((DBObject)this.m_dataType, (DBObject)((TypeComboListMember)obj).m_dataType) && ModelUtil.areEqual((Object)this.m_position, (Object)((TypeComboListMember)obj).m_position);
            }
            return retval;
        }

        public String toString() {
            String retval = this.m_derived ? UIBundle.get("COLUMN_INFO_VIRTUAL_DERIVED_DATATYPE") : (this.m_dataType != null ? this.m_dataType.getName() : UIBundle.get("TABLE_DTU_INVALID"));
            return retval;
        }

        public DataType getDataType() {
            return this.m_dataType;
        }

        public String getPosition() {
            return this.m_position;
        }

        public void setPosition(String position) {
            this.m_position = position;
        }
    }

    private static enum LayoutChoice {
        SIMPLE,
        COMPLEX,
        VIRTUAL;

    }
}

