/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.AbstractTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public final class FKMappingsTable
extends GenericTable {
    private final DBObjectRenderer m_renderer = new DBObjectRenderer(false);
    private final ReorderableTableWithTitleBar m_parent;
    private final DBUIResourceHelper m_resHelp = new DBUIResourceHelper("FKMappingsTable");
    private JButton m_addButton;
    private JButton m_removeButton;
    private DBObjectProvider m_pro;
    private boolean m_standalone;
    private FKConstraint m_fk;
    private UniqueConstraint m_refCon;
    private final Collection<Column> m_newCols = new ArrayList<Column>();

    public FKMappingsTable() {
        this.setModel(new MappingsTableModel());
        this.setDefaultRenderer(DBObjectID.class, this.m_renderer);
        this.setDefaultEditor(DBObjectID.class, new LocalColumnCellEditor());
        this.setDefaultEditor(String.class, new ReferenceColumnCellEditor());
        this.setColumnSelectorAvailable(false);
        this.setColumnHeaderSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setPreferredVisibleRowCount(3);
        JScrollPane pane = new JScrollPane((Component)((Object)this));
        this.m_resHelp.setName(pane, "table");
        this.m_parent = new ReorderableTableWithTitleBar((JTable)((Object)this));
        this.m_resHelp.setName((Component)this.m_parent, "parent");
        TableToolbar toolbar = this.createToolbar();
        this.m_parent.setTableToolbar(toolbar);
        this.m_resHelp.setName((Component)toolbar, "toolbar");
    }

    public ReorderableTableWithTitleBar getTableAndToolbar() {
        return this.m_parent;
    }

    public String[] getReferencedColumnNames() {
        String[] retval = null;
        if (this.isRealRefCon()) {
            retval = this.getMappingsModel().m_refCols.toArray(new String[0]);
        }
        return retval;
    }

    public DBObjectID[] getLocalColumnIDs() {
        List retval = this.getMappingsModel().m_localCols;
        this.removeUnusedLocalColumns(retval);
        return retval.toArray(new DBObjectID[retval.size()]);
    }

    private void removeUnusedLocalColumns(Collection<DBObjectID> keep) {
        if (!this.m_newCols.isEmpty() && this.m_fk != null) {
            Relation rel = this.m_fk.getRelation();
            Iterator<Column> iter = this.m_newCols.iterator();
            while (iter.hasNext()) {
                Column newCol = iter.next();
                if (keep.contains(newCol.getID())) continue;
                rel.removeColumn(newCol);
                iter.remove();
            }
        }
    }

    private MappingsTableModel getMappingsModel() {
        return (MappingsTableModel)super.getModel();
    }

    private TableToolbar createToolbar() {
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKMappingsTable.this.getMappingsModel().addNameBasedRow();
            }
        };
        addAction.putValue("SmallIcon", OracleIcons.getIcon((String)"add.png"));
        this.m_addButton = new JButton(addAction);
        this.m_resHelp.setName(this.m_addButton, "addAssoc");
        AbstractAction removeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKMappingsTable.this.getMappingsModel().removeSelectedRows();
            }
        };
        removeAction.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
        this.m_removeButton = new JButton(removeAction);
        this.m_resHelp.setName(this.m_removeButton, "removeAssoc");
        TableToolbar tb = new TableToolbar((JTable)((Object)this), null);
        tb.setLabel(StringUtils.stripMnemonic((String)UIBundle.get("FK_LABEL_ASSOCIATIONS")));
        tb.addActionControl((Component)this.m_addButton);
        tb.addActionControl((Component)this.m_removeButton);
        return tb;
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setStandalone(boolean standalone) {
        this.m_standalone = standalone;
    }

    private boolean isRealRefCon() {
        return this.m_refCon == null;
    }

    public void setFK(FKConstraint fk) {
        this.removeEditor();
        if (this.m_fk != fk) {
            this.m_newCols.clear();
        }
        this.m_fk = fk;
        UniqueConstraint previousRefCon = this.m_refCon;
        this.m_refCon = null;
        if (fk == null) {
            this.clearAndDisable();
        } else {
            DBObjectID refID = fk.getReferenceID();
            if (refID == null) {
                this.clearAndDisable();
            } else {
                boolean noRefCon;
                try {
                    DBObject obj = refID.resolveID();
                    if (obj instanceof UniqueConstraint) {
                        if (previousRefCon != null && previousRefCon != obj) {
                            this.removeUnusedLocalColumns(Arrays.asList(fk.getColumnIDs()));
                        }
                        this.m_refCon = (UniqueConstraint)obj;
                    }
                }
                catch (DBException dbe) {
                    this.log(dbe);
                }
                boolean bl = noRefCon = this.m_refCon == null || this.m_refCon.getParent() == null;
                if (!(!noRefCon || refID instanceof ReferenceID && ModelUtil.hasLength((String)((ReferenceID)refID).getName()))) {
                    this.clearAndDisable();
                } else {
                    this.setRowSelectionAllowed(noRefCon);
                    this.getMappingsModel().init();
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.m_addButton != null) {
            boolean addEnabled = false;
            boolean removeEnabled = false;
            DBObjectID refID = this.m_fk == null ? null : this.m_fk.getReferenceID();
            boolean isReferenceID = this.m_refCon == null && refID instanceof ReferenceID && ModelUtil.hasLength((String)((ReferenceID)refID).getName());
            TableToolbar tb = this.m_parent.getTableToolbar();
            tb.removeActionControl((Component)this.m_addButton);
            tb.removeActionControl((Component)this.m_removeButton);
            if (isReferenceID) {
                tb.addActionControl((Component)this.m_addButton);
                tb.addActionControl((Component)this.m_removeButton);
                if (this.isEnabled() && isReferenceID) {
                    addEnabled = this.getRowCount() < this.m_fk.getRelation().getColumns().length;
                    removeEnabled = this.getSelectedRowCount() > 0;
                }
                this.m_addButton.setEnabled(addEnabled);
                this.m_removeButton.setEnabled(removeEnabled);
            }
        }
    }

    private void clearAndDisable() {
        this.clearSelection();
        this.getMappingsModel().clear(true);
        this.checkButtons();
    }

    private DataType getDataType(Column column) {
        DataType retval = null;
        try {
            retval = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
        }
        catch (DBException dbe) {
            this.log(dbe);
        }
        return retval;
    }

    private Column getReferencedColumn(int refColIdx) {
        Column retval = null;
        if (this.m_refCon != null) {
            DBObjectID refColID = this.m_refCon.getColumnIDs()[refColIdx];
            retval = (Column)this.m_refCon.getRelation().findOwnedObject(refColID);
        }
        return retval;
    }

    private DBObjectID createColumn(String name, Relation rel, Column refCol) {
        Column col = (Column)this.m_pro.getObjectFactory().newObject(Column.class);
        col.setName(name);
        TemporaryObjectID.setID((DBObject)col, (boolean)false);
        rel.addColumn(col);
        DataTypeUsage dtu = refCol.getDataTypeUsage();
        if (dtu == null) {
            col.setDataTypeUsage(this.m_pro.getDescriptor().createDefaultTypeUsage());
        } else {
            col.setDataTypeUsage((DataTypeUsage)dtu.copyTo(null));
        }
        col.setNotNull(refCol.isNotNull());
        this.m_newCols.add(col);
        return col.getID();
    }

    private Collection<DBObjectID> getCompatibleColumns(int refColIdx) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        DataType refColDT = null;
        Column refCol = this.getReferencedColumn(refColIdx);
        if (refCol != null) {
            refColDT = this.getDataType(refCol);
        }
        DatabaseDescriptor desc = this.m_pro.getDescriptor();
        for (Column col : this.m_fk.getRelation().getColumns()) {
            if (refColDT != null && !desc.isValidFKDataType(this.getDataType(col), refColDT)) continue;
            retval.add(col.getID());
        }
        return retval;
    }

    private void log(DBException dbe) {
        this.getLogger().log(Level.WARNING, dbe.getMessage(), dbe);
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)((Object)this));
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.checkButtons();
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.checkButtons();
    }

    private class MappingsTableModel
    extends AbstractTableModel {
        private final List<DBObjectID> m_localCols = new ArrayList<DBObjectID>();
        private final List<String> m_refCols = new ArrayList<String>();

        private MappingsTableModel() {
        }

        public void clear(boolean notifyListeners) {
            this.m_localCols.clear();
            this.m_refCols.clear();
            if (notifyListeners) {
                this.fireTableDataChanged();
            }
        }

        public void init() {
            String[] refCols;
            this.clear(false);
            DBObjectID[] localCols = FKMappingsTable.this.m_fk.getColumnIDs();
            if (FKMappingsTable.this.m_refCon != null) {
                DBObjectID[] refColIDs = FKMappingsTable.this.m_refCon.getColumnIDs();
                Relation refRel = FKMappingsTable.this.m_refCon.getRelation();
                refCols = new String[refColIDs.length];
                for (int i = 0; i < refColIDs.length; ++i) {
                    Column refCol = (Column)refRel.findOwnedObject(refColIDs[i]);
                    if (refCol == null) continue;
                    refCols[i] = refCol.getName();
                }
            } else {
                ReferenceID ref = (ReferenceID)FKMappingsTable.this.m_fk.getReferenceID();
                refCols = ref.getChildObjectNames();
            }
            boolean fkColsChanged = false;
            for (int i = 0; i < refCols.length; ++i) {
                DBObjectID localColID;
                DBObjectID dBObjectID = localColID = localCols.length > i ? localCols[i] : null;
                if (localColID == null && localCols.length == 0) {
                    Collection possibles = FKMappingsTable.this.getCompatibleColumns(i);
                    possibles.removeAll(this.m_localCols);
                    for (DBObjectID possible : possibles) {
                        if (!ModelUtil.areEqual((Object)refCols[i], (Object)DBUtil.getDBObjectName((DBObjectID)possible))) continue;
                        localColID = possible;
                        break;
                    }
                    if (localColID == null) {
                        if (FKMappingsTable.this.m_standalone) {
                            Relation rel = FKMappingsTable.this.m_fk.getRelation();
                            Column refCol = FKMappingsTable.this.getReferencedColumn(i);
                            ArrayList<String> names = new ArrayList<String>();
                            for (Column col : rel.getColumns()) {
                                names.add(col.getName());
                            }
                            String name = DBUtil.getUniqueName(names, (String)refCol.getName());
                            localColID = FKMappingsTable.this.createColumn(name, rel, refCol);
                        } else if (!possibles.isEmpty()) {
                            localColID = (DBObjectID)possibles.iterator().next();
                        }
                    }
                    if (localColID != null) {
                        fkColsChanged = true;
                    }
                }
                this.m_localCols.add(localColID);
                this.m_refCols.add(refCols[i]);
            }
            if (fkColsChanged && this.m_localCols.size() > 0) {
                FKMappingsTable.this.m_fk.setColumnIDs(this.m_localCols.toArray(new DBObjectID[this.m_localCols.size()]));
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || FKMappingsTable.this.isRealRefCon();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_refCols.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object retval = null;
            switch (columnIndex) {
                case 0: {
                    retval = this.m_localCols.get(rowIndex);
                    break;
                }
                case 1: {
                    retval = this.m_refCols.get(rowIndex);
                }
            }
            return retval;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Object existing;
            List<Object> list;
            if (value instanceof String) {
                value = FKMappingsTable.this.m_pro.getInternalName((String)value);
            }
            List<Object> list2 = list = columnIndex == 0 ? this.m_localCols : this.m_refCols;
            if (list.size() > rowIndex && ModelUtil.areDifferent((Object)(existing = list.set(rowIndex, value)), (Object)value)) {
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class retval = null;
            switch (columnIndex) {
                case 0: {
                    retval = DBObjectID.class;
                    break;
                }
                case 1: {
                    retval = String.class;
                }
            }
            return retval;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String retval = null;
            switch (columnIndex) {
                case 0: {
                    retval = UIBundle.get("FK_HEADER_COL");
                    break;
                }
                case 1: {
                    retval = UIBundle.get("FK_HEADER_REF");
                }
            }
            return retval;
        }

        public void addNameBasedRow() {
            if (FKMappingsTable.this.isRealRefCon()) {
                int row = this.m_refCols.size();
                DBObjectID localColID = null;
                for (Column localCol : FKMappingsTable.this.m_fk.getRelation().getColumns()) {
                    DBObjectID id = localCol.getID();
                    if (id == null || this.m_localCols.contains(id)) continue;
                    localColID = id;
                    break;
                }
                this.m_localCols.add(localColID);
                this.m_refCols.add("REFCOL" + (row + 1));
                this.fireTableRowsInserted(row, row);
            }
        }

        public void removeSelectedRows() {
            int[] sel;
            if (FKMappingsTable.this.isRealRefCon() && (sel = FKMappingsTable.this.getSelectedRows()) != null && sel.length > 0) {
                Arrays.sort(sel);
                for (int i = sel.length - 1; i >= 0; --i) {
                    int row = sel[i];
                    this.m_refCols.remove(row);
                    this.m_localCols.remove(row);
                    this.fireTableRowsDeleted(row, row);
                }
            }
        }
    }

    private class ReferenceColumnCellEditor
    extends DefaultCellEditor {
        ReferenceColumnCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component retval = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            retval.setName("FKMappingsTable.TextEditor." + row + "." + column);
            if (value instanceof String) {
                String name = FKMappingsTable.this.m_pro.getExternalName((String)value);
                ((JTextField)retval).setText(name);
            }
            return retval;
        }
    }

    private class LocalColumnCellEditor
    extends DefaultCellEditor {
        private final DefaultComboBoxModel m_model;

        LocalColumnCellEditor() {
            super(new JComboBox(new DefaultComboBoxModel()));
            JComboBox box = (JComboBox)this.getComponent();
            this.m_model = (DefaultComboBoxModel)box.getModel();
            box.setRenderer(FKMappingsTable.this.m_renderer);
            box.setEditor(new BasicComboBoxEditor(){

                @Override
                public void setItem(Object anObject) {
                    if (anObject instanceof DBObjectID) {
                        anObject = FKMappingsTable.this.m_pro.getExternalName(DBUtil.getDBObjectName((DBObjectID)((DBObjectID)anObject)));
                    }
                    super.setItem(anObject);
                }

                @Override
                public Object getItem() {
                    Object retval = super.getItem();
                    if (retval instanceof String) {
                        Column refCol;
                        String name = FKMappingsTable.this.m_pro.getInternalName((String)retval);
                        Relation rel = FKMappingsTable.this.m_fk.getRelation();
                        Column found = (Column)DBUtil.findChildByName((DBObject)rel, (String)"columns", (String)name, (DBObjectProvider)FKMappingsTable.this.m_pro);
                        Object newValue = found == null ? ((refCol = FKMappingsTable.this.getReferencedColumn(FKMappingsTable.this.getSelectedRow())) == null ? null : FKMappingsTable.this.createColumn(name, rel, refCol)) : found.getID();
                        retval = newValue;
                    }
                    return retval;
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_model.removeAllElements();
            for (DBObjectID colID : FKMappingsTable.this.getCompatibleColumns(row)) {
                this.m_model.addElement(colID);
            }
            boolean editable = FKMappingsTable.this.m_standalone && !FKMappingsTable.this.isRealRefCon();
            ((JComboBox)this.getComponent()).setEditable(editable);
            Component retval = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            retval.setName("FKMappingsTable.ComboEditor." + row + "." + column);
            return retval;
        }
    }
}

