/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ValidationException;

public class IndexColumnExpressionsPanel
extends ChildTableEditorPanel<IndexObject, Index> {
    private SwingDBObjectListener m_listener = new SwingDBObjectListener(){

        @Override
        protected void updateUI(DBObjectChange change) {
            IndexColumnExpressionsPanel.this.enableButtons();
        }
    };

    public IndexColumnExpressionsPanel() {
        super("IndexColumnExpressionsPanel");
    }

    @Override
    protected String getChildProperty() {
        return "columnExpressions";
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"expressionSource", "orderType"};
    }

    @Override
    protected Class<IndexObject> getChildClass() {
        return IndexObject.class;
    }

    @Override
    protected IndexObject newChild() {
        IndexObject colExpr = (IndexObject)this.getProvider().getObjectFactory().newObject(IndexObject.class);
        TemporaryObjectID.setID((DBObject)colExpr, (boolean)true);
        Index index = (Index)this.getUpdatedObject();
        index.addColumnExpression(colExpr);
        Table tab = index.getTable();
        boolean ok = false;
        DBObjectProvider pro = this.getProvider();
        for (Column c : tab.getColumns()) {
            colExpr.setExpression((SQLFragment)new ColumnUsage(c.getID()));
            try {
                pro.validateObjectProperty((DBObject)index, "columnExpressions");
                ok = true;
                break;
            }
            catch (ValidationException e) {
            }
        }
        if (!ok) {
            colExpr.setExpressionSource(null);
        }
        return colExpr;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.enableButtons();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        ((Index)this.getUpdatedObject()).removeObjectListener((DBObjectListener)this.m_listener);
    }

    @Override
    public boolean canAddRow() {
        if (((Index)this.getUpdatedObject()).getParent() == null) {
            return false;
        }
        return super.canAddRow();
    }

    @Override
    protected boolean shouldValidateOnExit() {
        return false;
    }

    @Override
    protected boolean disableButtonsIfPropertyCannotChange() {
        return true;
    }
}

