/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.ui.TitledSeparator;

public class IndexEditorPanel
extends BaseEditorPanel<Index> {
    private DBObjectChooser m_tableSchema;
    private DBObjectChooser m_table;
    private TitledSeparator m_domainIndexSeparator;
    private final boolean m_isStandaloneIndexEditor;
    private final boolean m_isShowAdvancedButton;

    public IndexEditorPanel() {
        this(true, false);
    }

    public IndexEditorPanel(boolean isIndexEditor, boolean isShowAdvancedButton) {
        super("IndexEditorPanel");
        this.m_isStandaloneIndexEditor = isIndexEditor;
        this.m_isShowAdvancedButton = isShowAdvancedButton;
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwIndexType = this.getOrCreateWrapper("indexType");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        DBUILayoutHelper topLayout = layout.newChildHelper(2, 1, true, false);
        if (this.m_isStandaloneIndexEditor) {
            this.m_tableSchema = new DBObjectChooser("SCHEMA");
            this.m_table = new DBObjectChooser(this.m_tableSchema, "TABLE");
            String tableStr = PropertyDisplayRegistry.getDisplayName("table", this.getProvider(), this.getUpdatedObject());
            JLabel schemaLabel = new JLabel();
            this.getComponentFactory().getResourceHelper().resLabel(schemaLabel, this.m_tableSchema, UIBundle.format("LABEL_IDPROP_SCHEMA", tableStr), "m_tableSchema");
            topLayout.add(schemaLabel);
            topLayout.add(this.m_tableSchema);
            topLayout.nextRow();
            JLabel tableLabel = new JLabel();
            this.getComponentFactory().getResourceHelper().resLabel(tableLabel, this.m_table, tableStr + ":", "m_table");
            topLayout.add(tableLabel);
            topLayout.add(this.m_table);
            topLayout.nextRow();
            this.m_tableSchema.setProvider(this.getProvider());
            this.m_table.setProvider(this.getProvider());
            if (!this.getEditorConfig().isCommitToProvider() || this.getOriginalObject() != null && ((Index)this.getOriginalObject()).getTable() != null) {
                this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                this.m_tableSchema.setEnabled(false);
                this.m_table.setEnabled(false);
            } else {
                Index index = (Index)this.getUpdatedObject();
                if (index != null) {
                    Table t = index.getTable();
                    if (t != null) {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable().getSchema());
                        this.m_table.setDBObject((DBObject)((Index)this.getUpdatedObject()).getTable());
                    } else {
                        this.m_tableSchema.setDBObject((DBObject)((Index)this.getUpdatedObject()).getSchema());
                        this.m_table.setDBObject(null);
                    }
                }
            }
            this.m_table.addChangeListener(new DBObjectChooser.ChangeListener(){

                @Override
                public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setTable((Table)chooser.getDBObject());
                    ((Index)IndexEditorPanel.this.getUpdatedObject()).setColumnExpressions(new IndexObject[0]);
                    ComponentWrapper cwColExprs = IndexEditorPanel.this.getOrCreateWrapper("columnExpressions");
                    cwColExprs.setPropertyValue(((Index)IndexEditorPanel.this.getUpdatedObject()).getColumnExpressions());
                    IndexEditorPanel.this.initialisePanel();
                }
            });
        }
        topLayout.add(cwIndexType);
        layout.nextRow();
        ComponentWrapper cwColExprs = this.getOrCreateWrapper("columnExpressions");
        layout.add(cwColExprs.getComponent(), 2, 1, true, true);
        if (this.getProvider().getPropertyManager().supportsProperty("INDEX", "domainIndextype")) {
            layout.nextRow();
            String title = PropertyDisplayRegistry.getDisplayName("domainIndextype", this.getProvider(), this.getUpdatedObject());
            this.m_domainIndexSeparator = new TitledSeparator(title);
            layout.add((Component)this.m_domainIndexSeparator, 2, 1, true, false);
            ComponentWrapper cwDomainIndextype = this.getOrCreateWrapper("domainIndextype");
            ComponentWrapper cwDomainIndextypeParameters = this.getOrCreateWrapper("domainIndextypeParameters");
            layout.addChildren(cwDomainIndextype, new Integer[0]);
            layout.nextRow();
            layout.add(cwDomainIndextypeParameters);
        }
        if (this.m_isShowAdvancedButton) {
            JButton button = new JButton();
            this.getComponentFactory().getResourceHelper().resButton(button, UIBundle.get("INDEX_PANEL_LABEL_ADVANCED"), "indexAdvancedButton");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory(IndexEditorPanel.this.getProvider(), "INDEX");
                    DBEditorConfig indexConfig = IndexEditorPanel.this.getOriginalObject() == null ? DBEditorConfig.newCreateConfig(IndexEditorPanel.this.getProvider(), IndexEditorPanel.this.getUpdatedObject()) : DBEditorConfig.newEditConfig(IndexEditorPanel.this.getProvider(), IndexEditorPanel.this.getUpdatedObject());
                    indexConfig.setCommitToProvider(false);
                    factory.launchDialog(indexConfig);
                    if (indexConfig.getResult() == DBEditorConfig.Result.SUCCESS) {
                        IndexEditorPanel.this.initialisePanel();
                    }
                }
            });
            layout.nextRow();
            layout.nextColumn();
            layout.add(button);
            GridBagConstraints gbc = layout.getConstraints(button);
            gbc.anchor = 13;
            layout.setMarginBottom(0);
        }
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        this.handleIndexType();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"indexType"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent indexTypeChangeEvent) {
                String prop = indexTypeChangeEvent.getPropertyName();
                if (prop.equals("indexType") && (Index.IndexType.DOMAIN.equals(indexTypeChangeEvent.getOldValue()) || Index.IndexType.DOMAIN.equals(indexTypeChangeEvent.getNewValue()))) {
                    IndexEditorPanel.this.handleIndexType();
                }
            }
        };
    }

    private void handleIndexType() {
        if (this.m_domainIndexSeparator != null) {
            boolean isDomain = Index.IndexType.DOMAIN.equals((Object)((Index)this.getUpdatedObject()).getIndexType());
            ComponentWrapper cwDomainIndextype = this.getOrCreateWrapper("domainIndextype");
            ComponentWrapper cwDomainIndextypeParameters = this.getOrCreateWrapper("domainIndextypeParameters");
            cwDomainIndextype.setVisible(isDomain);
            cwDomainIndextypeParameters.setVisible(isDomain);
            this.m_domainIndexSeparator.setVisible(isDomain);
            if (!isDomain) {
                cwDomainIndextype.setPropertyValue(null);
                cwDomainIndextypeParameters.setPropertyValue(null);
            }
        }
    }
}

