/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.ora.IndexPanelLibrary;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.ideimpl.db.panels.GeneralPanel;
import oracle.ideimpl.db.panels.table.IndexEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class IndexInTableContextPanel
extends ChildObjectEditorPanel<Index, Table> {
    private Traversable m_childTraversable;
    private TraversableContext m_childTraversableContext;
    private final IndexPanelLibrary m_panelLib;
    private final Map<Index, DBEditorConfig> m_cachedConfigs = new IdentityHashMap<Index, DBEditorConfig>();

    public IndexInTableContextPanel() {
        super("IndexInTableContextPanel", "indexes");
        this.m_panelLib = new LocalIndexPanelLibrary();
    }

    @Override
    protected void initialiseChildComponents() {
        DBEditorConfig config = (DBEditorConfig)this.m_childTraversableContext.get(DBEditorConfig.class);
        List<Navigable> panelLibNavs = this.m_panelLib.getNavigables(config);
        if (this.isInFlatEditor()) {
            Navigable[] defaultNavs;
            ArrayList<Navigable> tabbedPanelNavs = new ArrayList<Navigable>();
            for (Navigable nav : panelLibNavs) {
                if (GeneralPanel.class == nav.getTraversableClass() || NameAndSchemaEditor.class == nav.getTraversableClass()) continue;
                tabbedPanelNavs.add(nav);
            }
            PanelLibrary lib = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
            if (lib != null && (defaultNavs = lib.getDefaultPanels(true)) != null) {
                for (Navigable nav : defaultNavs) {
                    tabbedPanelNavs.add(nav);
                }
            }
            this.m_childTraversable = new DBTabbedPanel(tabbedPanelNavs.toArray(new Navigable[tabbedPanelNavs.size()]));
        } else {
            boolean showAdvanced = false;
            for (Navigable nav : panelLibNavs) {
                if (DDLPanel.class == nav.getTraversableClass() || IndexEditorPanel.class == nav.getTraversableClass()) continue;
                showAdvanced = true;
                break;
            }
            this.m_childTraversable = new IndexEditorPanel(false, showAdvanced);
        }
        ((JComponent)this.m_childTraversable).setName("IndexInTableContextPanel.m_childTraversable");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add(this.getOrCreateWrapper("name"));
        layout.nextRow();
        layout.add((Component)this.m_childTraversable, 2, 1, true, true);
        layout.setMarginBottom(0);
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        Index upd;
        if (this.m_childTraversableContext == null) {
            this.m_childTraversableContext = new TraversableContext(new Namespace(), 0);
            BaseDBEditorFactory factory = (BaseDBEditorFactory)DBEditorFactoryRegistry.findFactory(this.getProvider().getClass());
            PanelLibrary lib = factory.getPanelLibrary("INDEX");
            this.m_childTraversableContext.put(PanelLibrary.class.getName(), (Object)lib);
            this.m_childTraversableContext.put(DBValidationManager.class.getName(), this.getDataContext().find(DBValidationManager.class));
            this.m_childTraversableContext.put(Context.class.getName(), this.getDataContext().find(Context.class));
        }
        if ((upd = (Index)this.getChildObject()) != null) {
            DBEditorConfig config = this.m_cachedConfigs.get(upd);
            if (config == null) {
                config = DBEditorConfig.newEmptyConfig(this.getProvider());
                config.setOriginalObject((SystemObject)this.getOriginalChildObject());
                config.setUpdatedObject((SystemObject)upd);
                BaseDBEditorFactory.setEditorType(config, this.getEditorConfig().getEditorType());
                this.m_cachedConfigs.put(upd, config);
            }
            if (this.getEditorConfig().isReplaceAllowed()) {
                config.setReplaceAllowed(true);
            }
            this.m_childTraversableContext.put(DBEditorConfig.class.getName(), (Object)config);
        }
        super.initialisePanel();
        if (this.getChildObject() != null) {
            this.m_childTraversable.onEntry(this.m_childTraversableContext);
            this.validate();
            this.repaint();
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        this.m_childTraversable.onExit(this.m_childTraversableContext);
    }

    private static class LocalIndexPanelLibrary
    extends IndexPanelLibrary {
        public LocalIndexPanelLibrary() {
            this.addPanel(UIBundle.get("DEFINITION"), IndexEditorPanel.class, "f1_odbindexdef_html", new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{false, false}, "columnExpressions");
        }

        @Override
        protected boolean includePanelHeaders(DBEditorConfig editorConfig) {
            return false;
        }

        @Override
        public Collection<String> getGeneralTitles() {
            return Collections.emptySet();
        }

        @Override
        protected boolean isIndexValidForEditting(Index obj, DBObjectProvider pro) {
            return true;
        }
    }
}

