/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.table.IndexInTableContextPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.Holder;

public class IndexesPanel
extends ChildListEditorPanel<Index, Table> {
    public IndexesPanel() {
        super("IndexesPanel");
    }

    @Override
    protected Class getChildClass() {
        return Index.class;
    }

    @Override
    protected String getListLabel() {
        return DisplayNames.getPropertyDisplayName((String)"indexes") + ":";
    }

    @Override
    protected ChildObjectEditorPanel createChildPanel() {
        return new IndexInTableContextPanel();
    }

    @Override
    protected String getChildProperty() {
        return "indexes";
    }

    @Override
    protected boolean preserveListOrder() {
        return false;
    }

    @Override
    protected ChildSelectableComponentEditorPanel.DefaultButtonsHelper createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeReorderButtons() {
                return false;
            }

            @Override
            public boolean canAdd() {
                if (super.canAdd()) {
                    return ((Table)IndexesPanel.this.getUpdatedObject()).getColumns().length > 0;
                }
                return false;
            }

            @Override
            public boolean canRemove(Object val) {
                boolean retval = super.canRemove(val);
                if (retval && val instanceof Index) {
                    retval = !ConstraintIndexHelper.isForAConstraint((Index)((Index)val));
                }
                return retval;
            }
        };
    }

    @Override
    protected Index newChild() {
        Index index = (Index)super.newChild();
        index.setIndexType(Index.IndexType.NORMAL);
        index.setColumnExpressions(IndexesPanel.getDefaultExpressions(index, this.getProvider(), (Component)((Object)this)));
        return index;
    }

    @Override
    protected String getNewChildBaseName() {
        return ((Table)this.getUpdatedObject()).getName() + "_" + super.getNewChildBaseName();
    }

    public static IndexObject[] getDefaultExpressions(final Index index, final DBObjectProvider pro, Component component) {
        final Holder retval = new Holder((Object)new IndexObject[0]);
        final ProgressBar progressBar = new ProgressBar(component, UIBundle.get("INDEX_COL_EXPRESSIONS_TITLE"), null, true);
        progressBar.setRunnable(new Runnable(){

            @Override
            public void run() {
                IndexObject[] empty = (IndexObject[])retval.get();
                String origName = index.getName();
                String newName = null;
                int i = 0;
                while (true) {
                    newName = "INDEX" + i++;
                    try {
                        pro.validateUniqueName("INDEX", (DBObject)index.getSchema(), newName);
                        index.setName(newName);
                    }
                    catch (NameInUseException e) {
                        continue;
                    }
                    break;
                }
                IndexObject[] deflt = IndexesPanel.getDefaultExpressions(index, empty, pro);
                index.setName(origName);
                if (deflt != null) {
                    retval.set((Object)deflt);
                }
                progressBar.setDoneStatus();
            }
        });
        progressBar.start(UIBundle.get("INDEX_COL_EXPRESSIONS_TEXT"), null, 1500);
        return (IndexObject[])retval.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexObject[] getDefaultExpressions(Index index, IndexObject[] parent, DBObjectProvider pro) {
        IndexObject io;
        if (index == null || index.getTable() == null) {
            return null;
        }
        IndexObject[] retval = new IndexObject[parent.length + 1];
        for (int i = 0; i < parent.length; ++i) {
            retval[i] = parent[i];
        }
        boolean valid = false;
        Table tab = index.getTable();
        DBObjectID lastID = null;
        if (parent.length > 0) {
            lastID = ((ColumnUsage)parent[parent.length - 1].getExpression()).getObjectID();
        }
        for (Column c : tab.getColumns()) {
            if (lastID == null) {
                ColumnUsage cu = (ColumnUsage)pro.getObjectFactory().newObject(ColumnUsage.class);
                cu.setObjectID(c.getID());
                io = (IndexObject)pro.getObjectFactory().newObject(IndexObject.class);
                io.setExpression((SQLFragment)cu);
                retval[retval.length - 1] = io;
                index.setColumnExpressions(retval);
                try {
                    pro.validateObjectProperty((DBObject)index, "columnExpressions");
                    valid = true;
                    break;
                }
                catch (DBException dbe) {
                    boolean blah = false;
                    continue;
                }
                finally {
                    index.setColumnExpressions(null);
                }
            }
            if (!lastID.equals(c.getID())) continue;
            lastID = null;
        }
        if (valid) {
            return retval;
        }
        IndexObject[] parent2 = new IndexObject[parent.length + 1];
        for (int i = 0; i < parent.length; ++i) {
            parent2[i] = parent[i];
        }
        lastID = null;
        if (parent.length > 0) {
            lastID = ((ColumnUsage)parent[parent.length - 1].getExpression()).getObjectID();
        }
        for (Column c : tab.getColumns()) {
            if (lastID == null) {
                parent2[parent2.length - 1] = io = new IndexObject((SQLFragment)new ColumnUsage(c.getID()));
                retval = IndexesPanel.getDefaultExpressions(index, parent2, pro);
                if (retval == null) continue;
                return retval;
            }
            if (!lastID.equals(c.getID())) continue;
            lastID = null;
        }
        return null;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.getListButtons().enableButtons();
    }
}

