/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.ModelUtil;

public class SimpleCreateTablePanel
extends ChildTableEditorPanel<Column, Table> {
    private List<DBObjectID> m_pkColsOnEntry = new ArrayList<DBObjectID>();

    public SimpleCreateTablePanel() {
        this("SimpleCreateTablePanel");
    }

    SimpleCreateTablePanel(String panelName) {
        super(panelName);
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.setColumnCellRenderer("dataTypeUsage", (TableCellRenderer)((Object)new DTUCellRenderer()));
        this.setColumnCellRenderer("default", (TableCellRenderer)((Object)new DefaultValueCellRenderer()));
    }

    @Override
    protected String getChildProperty() {
        return "columns";
    }

    @Override
    protected boolean isHorizontalSplit() {
        return false;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.getPKCols(this.m_pkColsOnEntry);
    }

    @Override
    protected ChildTableEditorPanel.NewChildInsertPolicy getNewChildInsertPolicy() {
        return !this.isInFlatEditor() && this.getOriginalObject() != null ? ChildTableEditorPanel.NewChildInsertPolicy.AT_END : ChildTableEditorPanel.NewChildInsertPolicy.AFTER_SELECTED_ROW;
    }

    @Override
    protected DBObjectListener createChildObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            protected void updateUI(DBObjectChange change) {
                if (SimpleCreateTablePanel.this.isEntered()) {
                    Collection changedProps = change.getAllChangedProperties();
                    if (changedProps.contains("dataTypeUsage")) {
                        SimpleCreateTablePanel.this.validate();
                        SimpleCreateTablePanel.this.repaint();
                    } else if (changedProps.contains("notNull")) {
                        PropertyChangeEvent event = change.getPropertyChange("notNull");
                        TableColumnModel colModel = SimpleCreateTablePanel.this.getWrapperTable().getColumnModel();
                        int rowIndx = SimpleCreateTablePanel.this.getWrapperTableModel().getCurrentRowIndx();
                        int colIndx = colModel.getColumnIndex("notNull");
                        SimpleCreateTablePanel.this.getWrapperTableModel().setValueAt(event.getNewValue(), rowIndx, colIndx);
                    }
                }
            }
        };
    }

    private void getPKCols(List<DBObjectID> list) {
        PKConstraint pk = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
        list.clear();
        if (pk != null) {
            for (DBObjectID id : pk.getColumnIDs()) {
                list.add(id);
            }
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (!this.isInFlatEditor()) {
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
            ArrayList<DBObjectID> pkColsOnExit = new ArrayList<DBObjectID>();
            this.getPKCols(pkColsOnExit);
            if (!pkColsOnExit.equals(this.m_pkColsOnEntry) && pk != null) {
                ConstraintIndexHelper helper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                try {
                    helper.ensureAndValidateIndexes((UniqueConstraint)pk);
                }
                catch (ValidationException ve) {
                    throw new TraversalException(ve.getMessage());
                }
            }
        }
    }

    @Override
    protected void initialiseTableComponents() {
        Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        int sizePosition = 3;
        if (tableType != Table.TableType.EXTERNAL && this.getProvider().getPropertyManager().canCreateProperty((SystemObject)this.getUpdatedObject(), "constraints")) {
            ChildTableEditorPanel.NonPropertyColumnLogic<Column> logic = new ChildTableEditorPanel.NonPropertyColumnLogic<Column>(){

                @Override
                public void setValueAt(Object value, int row, int column) {
                    SimpleCreateTablePanel.this.addColumnToPK(value, row, column);
                }

                @Override
                public Object getCellValue(Column rowObject) {
                    return PKConstraint.isConstrained((Column)rowObject, (String[])new String[]{"PKConstraint"});
                }

                @Override
                public boolean isCellEditable(Column rowObject) {
                    return true;
                }
            };
            this.addColumn(0, "PK", Boolean.class, logic, (TableCellRenderer)((Object)new PKColRenderer()));
        } else {
            sizePosition = 2;
        }
        ChildTableEditorPanel.NonPropertyColumnLogic<Column> sizeLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<Column>(){

            private DataType getDataType(DataTypeUsage dtu) {
                DataType retval = null;
                try {
                    retval = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                }
                catch (DBException dbe) {
                    SimpleCreateTablePanel.this.getLogger().fine(dbe.getMessage());
                }
                return retval;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(row);
                DataTypeUsage dtu = ((Column)rowInfo.getRowObject()).getDataTypeUsage();
                DataType dataType = this.getDataType(dtu);
                if (dataType != null) {
                    if (dataType.hasDataTypeAttribute("size")) {
                        this.putAttributeValue(dtu, "size", value);
                    } else if (dataType.hasDataTypeAttribute("precision")) {
                        this.putAttributeValue(dtu, "precision", value);
                    }
                    ((Column)rowInfo.getRowObject()).setDataTypeUsage(dtu);
                }
            }

            @Override
            public Object getCellValue(Column rowObject) {
                Object retval = null;
                DataTypeUsage dtu = rowObject.getDataTypeUsage();
                if (dtu != null) {
                    Object size = dtu.getAttributeValue("size");
                    Object precision = dtu.getAttributeValue("precision");
                    if (size != null) {
                        retval = size;
                    } else if (precision != null) {
                        retval = precision;
                    }
                }
                return retval;
            }

            @Override
            public String getPropertyPath(Column rowObject) {
                String attr = null;
                DataType dataType = this.getDataType(rowObject.getDataTypeUsage());
                if (dataType != null) {
                    if (dataType.hasDataTypeAttribute("size")) {
                        attr = "size";
                    } else if (dataType.hasDataTypeAttribute("precision")) {
                        attr = "precision";
                    }
                }
                return attr == null ? null : Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", attr});
            }

            @Override
            public boolean isCellEditable(Column rowObject) {
                boolean isEditable = false;
                DataTypeUsage dtu = rowObject.getDataTypeUsage();
                try {
                    DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                    if (dataType != null) {
                        DataTypeAttribute attrib = dataType.getDataTypeAttribute("size");
                        if (attrib == null) {
                            attrib = dataType.getDataTypeAttribute("precision");
                        }
                        if (attrib != null) {
                            isEditable = attrib.isDeclarable();
                        }
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning(dbe.getMessage());
                }
                return isEditable;
            }

            private void putAttributeValue(DataTypeUsage dtu, String attribName, Object attribValue) {
                DataType dataType = this.getDataType(dtu);
                if (dataType != null) {
                    dtu.putAttributeValue(attribName, DataTypeHelper.getAttributeValue((Object)attribValue, (DataType)dataType, (String)attribName));
                }
            }
        };
        this.addColumn(sizePosition, UIBundle.get("SIMPLETABLE_SIZE"), String.class, sizeLogic, (TableCellRenderer)((Object)new SizeRenderer()));
    }

    @Override
    protected String[] getPropertiesForRow() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("name");
        retval.add("dataTypeUsage");
        retval.add("notNull");
        retval.add("default");
        Collection<PropertyInfo> extras = DatabaseExtensionHook.getHook().getAutoIncludedProperties(this.getProvider(), Column.class);
        for (PropertyInfo info : extras) {
            retval.add(info.getPropertyName());
        }
        retval.add("Comment");
        return retval.toArray(new String[retval.size()]);
    }

    @Override
    protected Column newChild() {
        Column col = (Column)super.newChild();
        col.setDataTypeUsage(this.getProvider().getDescriptor().createDefaultTypeUsage());
        return col;
    }

    @Override
    protected Class getChildClass() {
        return Column.class;
    }

    protected void removeChild(Column child) {
        Table table = (Table)this.getUpdatedObject();
        table.removeColumn(child);
    }

    @Override
    public boolean isTableCellEditable(int row, int col) {
        Column column;
        boolean editable = true;
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(row);
        String columnTitle = this.getWrapperTableModel().getColumnName(col);
        if (columnTitle.equals(PropertyDisplayRegistry.getDisplayName("default")) && (column = (Column)rowInfo.getRowObject()).getDefault() == null && (this.isVirtualColumn(column) || this.isIdentityColumn(column))) {
            editable = false;
        }
        return editable;
    }

    @Override
    public boolean canMoveRowDown() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowToBottom() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowToTop() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowUp() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    private void addColumnToPK(Object value, int rowIndx, int colIndx) {
        ChildTableEditorPanel.RowInfo columnRow = this.getWrapperTableModel().getRow(rowIndx);
        Column column = (Column)columnRow.getRowObject();
        Table table = (Table)this.getUpdatedObject();
        Boolean adding = (Boolean)value;
        if (adding.booleanValue()) {
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)table);
            boolean pkFound = false;
            if (pk == null) {
                pk = (PKConstraint)ConstraintsPanel.newConstraint((Relation)table, "PKConstraint", this.getProvider());
            } else {
                pkFound = true;
            }
            pk.addColumn(column);
            this.getWrapperTableModel().setValueForProperty(column, "notNull", value, rowIndx);
            if (!pkFound) {
                table.addConstraint((Constraint)pk);
            }
        } else {
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)table);
            if (pk != null) {
                DBObjectID pkColID = column.getID();
                DBObjectID[] colIDs = pk.getColumnIDs();
                if (Arrays.asList(colIDs).contains(pkColID)) {
                    if (colIDs.length == 1) {
                        if (this.confirmCascadeDelete((ChildDBObject)pk, (DBObject)table)) {
                            table.removeConstraint((Constraint)pk);
                            if (!this.isInFlatEditor()) {
                                ConstraintIndexHelper helper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                                helper.clearNewUnusedIndexes(table);
                            }
                        }
                    } else {
                        pk.removeColumn(column);
                    }
                }
            }
        }
        this.enterChildPanel(column);
    }

    private boolean isIdentityColumn(Column col) {
        return col != null && col.getIdentityProperties() != null;
    }

    private boolean isVirtualColumn(Column col) {
        return col != null && col.getVirtualExpressionSource() != null;
    }

    private static class DtuMapKey {
        private String m_key;

        DtuMapKey(DataTypeUsage dtu) {
            this.m_key = this.createKey(dtu);
        }

        public boolean equals(Object obj) {
            return obj instanceof DtuMapKey ? ModelUtil.areEqual((Object)((DtuMapKey)obj).m_key, (Object)this.m_key) : false;
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }

        public String toString() {
            return this.m_key;
        }

        private String createKey(DataTypeUsage dtu) {
            StringBuilder builder = new StringBuilder();
            DBObjectID dt = dtu.getDataTypeID();
            builder.append(dt != null ? dt.toString() : "null");
            Map attributes = dtu.getAttributeValues();
            ArrayList sortedKeys = new ArrayList(attributes.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                builder.append(":").append(key).append("=").append(attributes.get(key));
            }
            return builder.toString();
        }
    }

    private class SizeRenderer
    extends GenericTableCellRenderer {
        private SizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel retval = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(row);
            DataTypeUsage dtu = ((Column)rowInfo.getRowObject()).getDataTypeUsage();
            if (dtu != null) {
                Object size = dtu.getAttributeValue("size");
                Object precision = dtu.getAttributeValue("precision");
                if (size != null) {
                    retval.setText(size.toString());
                } else if (precision != null) {
                    retval.setText(precision.toString());
                } else {
                    retval.setText(null);
                }
            }
            return retval;
        }
    }

    private class PKColRenderer
    extends GenericTableCellRenderer {
        private PKColRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel retval = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            retval.setToolTipText(UIBundle.get("TABLE_TIP_ADD_TO_PK"));
            if (value != null) {
                if (value == Boolean.TRUE) {
                    retval.setIcon(OracleIcons.getIcon((String)"primarykey.png"));
                    retval.setText(null);
                } else {
                    retval.setIcon(null);
                    retval.setText(null);
                }
            }
            return retval;
        }
    }

    private class DTUCellRenderer
    extends GenericTableCellRenderer {
        private final Map<DtuMapKey, String> m_ddlMap = new HashMap<DtuMapKey, String>();

        private DTUCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataTypeUsage dtu;
            JLabel retval = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SimpleCreateTablePanel.this.setEnabled(true);
            column = table.convertColumnIndexToModel(column);
            String columnTitle = SimpleCreateTablePanel.this.getWrapperTableModel().getColumnName(column);
            Column col = null;
            DBObjectID dataTypeID = null;
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(row);
            if (rowInfo != null && (dtu = (col = (Column)rowInfo.getRowObject()).getDataTypeUsage()) != null) {
                dataTypeID = dtu.getDataTypeID();
            }
            boolean isVirtual = SimpleCreateTablePanel.this.isVirtualColumn(col);
            String text = dataTypeID != null ? DBUtil.getDBObjectName(dataTypeID) : (isVirtual ? UIBundle.get("TABLE_DTU_DERIVED") : UIBundle.get("TABLE_DTU_INVALID"));
            Icon icon = null;
            if (isVirtual) {
                icon = OracleIcons.getIcon((String)"function.png");
            } else if (SimpleCreateTablePanel.this.isIdentityColumn(col)) {
                icon = OracleIcons.getIcon((String)"sequence.png");
            }
            retval.setText(text);
            retval.setIcon(icon);
            return retval;
        }
    }

    private class DefaultValueCellRenderer
    extends GenericTableCellRenderer {
        private DefaultValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel retval = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(row);
            if (rowInfo != null) {
                Column col = (Column)rowInfo.getRowObject();
                String virtualExp = col.getVirtualExpressionSource();
                if (virtualExp != null) {
                    retval.setText(virtualExp);
                } else if (SimpleCreateTablePanel.this.isIdentityColumn(col)) {
                    retval.setText("<" + UIBundle.get("IDENTITY_COLUMN_PANEL_TITLE") + ">");
                }
            }
            return retval;
        }
    }
}

