/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;

public class TableInfoPanel
extends NameAndSchemaAdvancedEditor<Table> {
    private Table.TableType m_currentType;

    public TableInfoPanel() {
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"TableType"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent propChange) {
                TableInfoPanel.this.tableTypeChanged((Table.TableType)propChange.getOldValue());
            }
        };
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper layout) {
        super.layoutComponents(layout);
        layout.nextRow();
        ComponentWrapper typeWrapper = this.getOrCreateWrapper("TableType");
        this.getComponentFactory().getResourceHelper().setName((Component)typeWrapper.getActiveComponent(), "TableType");
        layout.add(typeWrapper);
    }

    private void hideTypeControls() {
        this.getOrCreateWrapper("TableType").setVisible(false);
    }

    private void showTypeControls() {
        this.getOrCreateWrapper("TableType").processComponent(this.isEditable(), false);
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.tableTypeChanged(this.m_currentType);
        DBEditorFactory.EditorType editorType = this.getEditorConfig().getEditorType();
        if (!this.isAdvancedLayout() && editorType == DBEditorFactory.EditorType.CREATE_MODAL) {
            this.hideTypeControls();
        } else {
            this.showTypeControls();
        }
    }

    @Override
    protected void showSimplePanel() throws TraversalException {
        super.showSimplePanel();
        this.hideTypeControls();
    }

    @Override
    protected void showAdvancedPanel() throws TraversalException {
        this.showPanelsForTableType((Table)this.getUpdatedObject());
        this.showTypeControls();
    }

    private void showPanelsForTableType(Table table) throws TraversalException {
        List<Navigable> navs = this.getPanelLibrary().getNavigables(this.getEditorConfig());
        this.changePanels(navs.toArray(new Navigable[navs.size()]));
    }

    private void tableTypeChanged(Table.TableType lastType) {
        Table table = (Table)this.getUpdatedObject();
        this.m_currentType = (Table.TableType)table.getProperty("TableType");
        if (lastType != null && lastType != this.m_currentType) {
            try {
                this.showPanelsForTableType(table);
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)((Object)this));
                table.setProperty("TableType", (Object)lastType);
                this.m_currentType = lastType;
            }
        }
    }
}

