/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.util.ModelUtil;

public class OracleTablespacePropertiesPanel
extends ChildObjectEditorPanel<OracleTablespaceProperties, Tablespace> {
    private boolean m_restoreDictExtMgmnt = false;

    public OracleTablespacePropertiesPanel() {
        super("OracleTablespacePropertiesPanel", null, true);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"fileType", "TablespaceType", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"}), Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"})}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                String autoAlloc = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"});
                String extMgmnt = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"});
                if ("fileType".equals(propertyName)) {
                    OracleTablespacePropertiesPanel.this.handleFileTypeUpdate(pce.getNewValue());
                } else if ("TablespaceType".equals(propertyName)) {
                    OracleTablespacePropertiesPanel.this.getComponentFactory().forceProcessComponents();
                    OracleTablespacePropertiesPanel.this.repaint();
                } else if (extMgmnt.equals(propertyName)) {
                    OracleTablespaceProperties otp;
                    Object newValue = pce.getNewValue();
                    if (OracleTablespaceProperties.ExtentManagementType.LOCAL.equals(newValue) && (otp = (OracleTablespaceProperties)obj.getProperty("OracleTablespaceProperties")) != null) {
                        otp.setProperty("OracleStorageProperties", null);
                    }
                    OracleTablespacePropertiesPanel.this.handleExtentManagementUpdate(newValue);
                } else if (autoAlloc.equals(propertyName)) {
                    OracleTablespacePropertiesPanel.this.handleAutoAllocateUpdate(pce.getNewValue());
                }
            }
        };
    }

    @Override
    protected void initialiseChildComponents() {
        ComponentWrapper cwTbspGroup = this.getOrCreateWrapper("tablespaceGroup");
        ComponentWrapper cwRetention = this.getOrCreateWrapper("retention");
        ComponentWrapper cwBlocksize = this.getOrCreateWrapper("blockSize");
        ComponentWrapper cwLogging = this.getOrCreateWrapper("logging");
        ComponentWrapper cwForcelogging = this.getOrCreateWrapper("forceLogging");
        ComponentWrapper cwCompress = this.getOrCreateWrapper("defaultTableCompression");
        ComponentWrapper cwOnline = this.getOrCreateWrapper("onlineStatus");
        ComponentWrapper cwSegMgmnt = this.getOrCreateWrapper("segmentManagement");
        ComponentWrapper cwExtentMgmnt = this.getOrCreateWrapper("extentManagementType");
        ComponentWrapper cwAutoAllocate = this.getOrCreateWrapper("autoAllocate");
        ComponentWrapper cwUniformSize = this.getOrCreateWrapper("uniformSize");
        ComponentWrapper cwStorageProps = this.getOrCreateWrapper("OracleStorageProperties");
        DBUILayoutHelper topLayout = this.getDBUILayoutHelper();
        topLayout.setMargins(0);
        topLayout.add(cwTbspGroup);
        topLayout.nextRow();
        topLayout.add(cwRetention);
        topLayout.nextRow();
        topLayout.add(cwBlocksize);
        topLayout.add(cwOnline);
        topLayout.nextRow();
        topLayout.add(cwLogging);
        topLayout.add(cwForcelogging);
        topLayout.nextColumn();
        topLayout.nextRow();
        topLayout.add(cwSegMgmnt);
        topLayout.add(cwCompress);
        topLayout.nextRowWithGap();
        TitledSeparator extMgmntSep = new TitledSeparator(UIBundle.get("TABLESPACE_INFO_BORDER_EXTENT_MANAGEMENT"));
        topLayout.add((Component)extMgmntSep, 4, 1);
        topLayout.nextRow();
        DBUILayoutHelper extMgmtLayout = topLayout.newChildHelper("extMgmtLayout", 4, 1, true, false);
        extMgmtLayout.add(cwExtentMgmnt.getLabel());
        extMgmtLayout.add(cwExtentMgmnt.getComponent(), 2, 1);
        extMgmtLayout.nextRow();
        extMgmtLayout.add(cwAutoAllocate.getComponent());
        extMgmtLayout.add(cwUniformSize.getLabel());
        extMgmtLayout.add(cwUniformSize.getComponent());
        extMgmtLayout.nextRow();
        extMgmtLayout.add(cwStorageProps.getComponent(), 4, 1, true, false);
        topLayout.pushUp();
        topLayout.layout();
    }

    @Override
    public void initialisePanel() {
        super.initialisePanel();
        this.initialiseComponentValues();
    }

    private void handleExtentManagementUpdate(Object newValue) {
        ComponentWrapper cwAutoAllocate = this.getOrCreateWrapper("autoAllocate");
        ComponentWrapper cwUniformSize = this.getOrCreateWrapper("uniformSize");
        ComponentWrapper cwStorageProps = this.getOrCreateWrapper("OracleStorageProperties");
        if (newValue != null) {
            if (newValue.equals(OracleTablespaceProperties.ExtentManagementType.LOCAL)) {
                cwAutoAllocate.setEnabled(true);
                this.enableUniformSize((Boolean)cwAutoAllocate.getPropertyValue() == false);
                cwStorageProps.setPropertyValue(null);
                cwStorageProps.setEnabled(false);
            } else {
                cwAutoAllocate.setEnabled(false);
                this.enableUniformSize(false);
                cwStorageProps.setEnabled(true);
            }
        }
    }

    private void handleAutoAllocateUpdate(Object newValue) {
        if (newValue != null && newValue instanceof Boolean) {
            this.enableUniformSize((Boolean)newValue == false);
        }
    }

    private void enableUniformSize(boolean enable) {
        ComponentWrapper cwUniformSize = this.getOrCreateWrapper("uniformSize");
        if (!enable) {
            cwUniformSize.resetPropertyValue(null);
        }
        cwUniformSize.setEnabled(enable);
    }

    private void handleFileTypeUpdate(Object newValue) {
        ComponentWrapper cwExtentMgmnt = this.getOrCreateWrapper("extentManagementType");
        if (newValue != null) {
            if (newValue.equals(Tablespace.FileType.BIGFILE)) {
                cwExtentMgmnt.setEnabled(false);
                DBObject obj = this.getComponentFactoryUpdatedObject();
                if (ModelUtil.areEqual((Object)obj.getProperty("extentManagementType"), (Object)OracleTablespaceProperties.ExtentManagementType.DICTIONARY)) {
                    this.m_restoreDictExtMgmnt = true;
                }
                cwExtentMgmnt.setPropertyValue(OracleTablespaceProperties.ExtentManagementType.LOCAL);
            } else {
                cwExtentMgmnt.setEnabled(true);
                if (this.m_restoreDictExtMgmnt) {
                    cwExtentMgmnt.setPropertyValue(OracleTablespaceProperties.ExtentManagementType.DICTIONARY);
                }
            }
        }
    }

    public void initialiseComponentValues() {
        ComponentWrapper cwExtentMgmnt = this.getOrCreateWrapper("extentManagementType");
        OracleTablespaceProperties otp = (OracleTablespaceProperties)this.getChildObject();
        if (otp != null) {
            this.handleAutoAllocateUpdate(otp.isAutoAllocate());
            this.handleExtentManagementUpdate(otp.getExtentManagementType());
            this.handleFileTypeUpdate(((Tablespace)otp.getParent()).getFileType());
        } else {
            this.handleAutoAllocateUpdate(false);
            this.handleExtentManagementUpdate(null);
            this.handleFileTypeUpdate(null);
        }
        cwExtentMgmnt.setEnabled(this.isInFlatEditor() ? true : this.getOriginalObject() == null);
    }
}

