/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameEditor;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;

public class TablespaceInfoPanel
extends NameEditor<Tablespace> {
    private final Map<String, Object> m_cachedProps = new HashMap<String, Object>();
    private final Map<String, Object> m_permProps = new HashMap<String, Object>();

    public TablespaceInfoPanel() {
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"TablespaceType"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                TablespaceInfoPanel.this.doTypeChange((Tablespace.TablespaceType)pce.getOldValue());
            }
        };
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper layout) {
        super.layoutComponents(layout);
        layout.nextRow();
        ComponentWrapper wrapper = this.getOrCreateWrapper("TablespaceType");
        this.getComponentFactory().getResourceHelper().setName((Component)wrapper.getActiveComponent(), "TablespaceType");
        layout.add(wrapper);
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.initialisePermProps();
    }

    private void doTypeChange(Tablespace.TablespaceType oldType) {
        Tablespace tablespace = (Tablespace)this.getUpdatedObject();
        Tablespace.TablespaceType type = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType");
        if (type != oldType) {
            if (oldType == Tablespace.TablespaceType.PERMANENT) {
                this.resetPermanentProperties(tablespace);
            } else if (oldType == Tablespace.TablespaceType.TEMPORARY) {
                this.resetTemporaryProperties(tablespace);
            } else {
                this.resetUndoProperties(tablespace);
            }
            if (type == Tablespace.TablespaceType.PERMANENT) {
                this.restorePermanentProperties(tablespace);
            } else if (type == Tablespace.TablespaceType.TEMPORARY) {
                this.restoreTemporaryProperties(tablespace);
            } else {
                this.restoreUndoProperties(tablespace);
            }
        }
    }

    private void resetPermanentProperties(Tablespace tablespace) {
        for (String key : this.m_permProps.keySet()) {
            this.resetProperty(tablespace, key, this.m_permProps.get(key));
        }
    }

    private void restorePermanentProperties(Tablespace tablespace) {
        Iterator<String> propsIter = this.m_permProps.keySet().iterator();
        while (propsIter.hasNext()) {
            this.restoreProperty(tablespace, propsIter.next());
        }
    }

    private void resetTemporaryProperties(Tablespace tablespace) {
        String tablespceGroup = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tablespaceGroup"});
        this.resetProperty(tablespace, tablespceGroup, null);
    }

    private void restoreTemporaryProperties(Tablespace tablespace) {
        String tablespceGroup = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tablespaceGroup"});
        this.restoreProperty(tablespace, tablespceGroup);
    }

    private void resetUndoProperties(Tablespace tablespace) {
        String retention = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"});
        this.resetProperty(tablespace, retention, null);
    }

    private void restoreUndoProperties(Tablespace tablespace) {
        String retention = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"});
        this.restoreProperty(tablespace, retention);
    }

    private void restoreProperty(Tablespace tablespace, String propPath) {
        if (this.m_cachedProps.containsKey(propPath)) {
            this.getPropertyHelper().setPropertyValue((Object)tablespace, propPath, this.m_cachedProps.get(propPath));
        }
    }

    private void resetProperty(Tablespace tablespace, String propPath, Object value) {
        PropertyHelper helper = this.getPropertyHelper();
        this.m_cachedProps.put(propPath, helper.getPropertyValue((Object)tablespace, propPath));
        helper.setPropertyValue((Object)tablespace, propPath, value);
    }

    private void initialisePermProps() {
        if (this.m_permProps.size() == 0) {
            String online = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"});
            this.m_permProps.put(online, null);
            String minExtent = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "minExtent"});
            this.m_permProps.put(minExtent, null);
            String blockSize = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "blockSize"});
            this.m_permProps.put(blockSize, null);
            String logging = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"});
            this.m_permProps.put(logging, null);
            String forceLogging = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "forceLogging"});
            this.m_permProps.put(forceLogging, Boolean.FALSE);
            String autoAlloc = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"});
            this.m_permProps.put(autoAlloc, Boolean.FALSE);
            String compression = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"});
            this.m_permProps.put(compression, null);
            String segMgmnt = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "segmentManagement"});
            this.m_permProps.put(segMgmnt, null);
            String storageProps = Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"});
            this.m_permProps.put(storageProps, null);
        }
    }
}

