/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.IconValidationPainter;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.table.TableToolbar;

public abstract class DBValidationHandler {
    private final DBEditorConfig m_config;
    private final ComponentFactory m_componentFactory;
    private final Collection<Listener> m_listeners = new CopyOnWriteArraySet<Listener>();
    private DBObject m_originalObject;
    private DBObject m_updatedObject;
    private DBObjectValidationModel m_model;

    public DBValidationHandler(DBEditorConfig config, ComponentFactory factory) {
        this.m_config = config;
        this.m_componentFactory = factory;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public final void addListener(Listener l) {
        this.m_listeners.add(l);
    }

    public final void removeListener(Listener l) {
        this.m_listeners.remove(l);
    }

    protected final DBEditorConfig getEditorConfig() {
        return this.m_config;
    }

    protected final DBObject getOriginalObject() {
        return this.m_originalObject;
    }

    protected final DBObject getUpdatedObject() {
        return this.m_updatedObject;
    }

    protected final ComponentFactory getComponentFactory() {
        return this.m_componentFactory;
    }

    public final void startValidation(DBObject originalObject, DBObject updatedObject) {
        if (this.m_updatedObject != updatedObject) {
            if (this.m_updatedObject != null) {
                this.stopValidation();
            }
            this.m_originalObject = originalObject;
            this.m_updatedObject = updatedObject;
            this.startValidationImpl();
        }
    }

    public final void stopValidation() {
        if (this.m_updatedObject != null) {
            this.stopValidationImpl();
            this.clearValidation();
            this.m_originalObject = null;
            this.m_updatedObject = null;
        }
    }

    protected abstract void startValidationImpl();

    protected abstract void stopValidationImpl();

    public final DBObjectValidationModel getValidationModel() {
        return this.m_model;
    }

    public final void setValidationModel(final DBObjectValidationModel model) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setModelImpl(model);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBValidationHandler.this.setModelImpl(model);
                }
            });
        }
    }

    private void setModelImpl(DBObjectValidationModel model) {
        this.clearValidation();
        this.m_model = model;
        Map map = model.getValidationMap(this.m_updatedObject);
        if (map != null && this.m_componentFactory != null) {
            for (Map.Entry entry : map.entrySet()) {
                String propPath = Property.stripProperties((String)((String)entry.getKey()));
                ComponentWrapper cw = this.m_componentFactory.findComponentWrapper(propPath);
                if (cw == null) continue;
                cw.setValidationStatus((Collection)entry.getValue(), this);
            }
        }
        for (Listener listener : this.m_listeners) {
            try {
                listener.validationModelChanged(model, this);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, listener.getClass().getName() + " failed!", e);
            }
        }
    }

    public void processValidation(Component component, ComponentWrapper wrapper, Collection<ValidationException> ves) {
        if (component instanceof TableToolbar) {
            try {
                JPanel p = (JPanel)((BorderLayout)((JPanel)component).getLayout()).getLayoutComponent("North");
                JPanel p2 = (JPanel)((BorderLayout)p.getLayout()).getLayoutComponent("North");
                component = (JLabel)((BorderLayout)p2.getLayout()).getLayoutComponent("West");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (component != null) {
            DBValidationComponent dvc = this.findOrCreateValidationComponent((JComponent)component, wrapper);
            dvc.clearValidation();
            if (ves != null) {
                for (ValidationException ve : ves) {
                    dvc.addValidationException(ve);
                }
            }
        }
    }

    protected DBValidationComponent findOrCreateValidationComponent(Component component, ComponentWrapper wrapper) {
        DBValidationComponent retval = null;
        if (component instanceof JComponent && IconValidationPainter.supportsComponent((ValidationComponent)(retval = DBValidationComponent.findOrCreateValidationComponent((JComponent)component, wrapper)))) {
            retval.setValidationPainter(new IconValidationPainter());
        }
        return retval;
    }

    public final void clearValidation() {
        if (this.m_componentFactory != null) {
            for (ComponentWrapper cw : this.m_componentFactory.getComponentWrappers()) {
                cw.setValidationStatus(null, this);
            }
        }
    }

    public static abstract class Listener {
        public abstract void validationModelChanged(DBObjectValidationModel var1, DBValidationHandler var2);
    }
}

