/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JrfUtils;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class AppContextStartup {
    public static final String JRF_ENABLE_APP_CONTEXT_INIT = "oracle.jrf.EnableAppContextInit";
    private static final boolean ENABLED = AppContextStartup.init();
    private static final Logger LOGGER = Logger.getLogger(JrfUtils.JRF_LOGGER);

    private static boolean init() {
        try {
            return Boolean.getBoolean(JRF_ENABLE_APP_CONTEXT_INIT);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initAppContext() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            LOGGER.log(Level.FINE, JRFMessageBundleHelper.msg.getString("JRF-20031"));
            Class.forName("sun.awt.AppContext", true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.FINE, JRFMessageBundleHelper.msg.getString("JRF-20032"), classNotFoundException);
            boolean bl = false;
            return bl;
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!ENABLED) {
            return;
        }
        AppContextStartup.initAppContext();
    }
}

