/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.core.ojdl.logging.config.LoggingConfigUtil;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class InternalJrfUtils {
    static final String WL_JMX_SERVICE_URL_PATTERN = "service:jmx:t3://{0}:{1}/jndi/{2}";
    public static final String ORA_LOGGING_EXCLUSION_FILE = "loggers.exclude";
    public static final String ORA_TARGET_LOGFILE = "logging.xml";
    public static final String ORA_LOG_TEMPLATE = "logging-template.xml";
    public static final String ORA_LOGGER_SUFFIX = "logging.xml";
    public static final String ORA_LOGGER_DIR = "logging";
    public static final String ORA_SERVER_CONFIG_TEMPLATE_DIR = "server-config-template";
    static ArrayList<String> discovered_loggers;
    static ArrayList<String> excluded_loggers;
    static ArrayList<String> new_loggers;
    public static final String[][] WL_TYPE_TO_MBEAN_LOOKUPSERVICE;

    public static void copyDir(File file, File file2, boolean bl) throws IOException {
        for (File file3 : file.listFiles()) {
            if (file3.getName().equals("logging.xml")) continue;
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                file4.mkdir();
                InternalJrfUtils.copyDir(file3, file4, bl);
                continue;
            }
            if (file4.exists() && !bl) continue;
            InternalJrfUtils.copyStream(new FileInputStream(file3), new FileOutputStream(file4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[10240];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void initServerConfigTemplateDir(File file, File file2) throws PortabilityLayerException {
        File file3 = new File(file, ORA_SERVER_CONFIG_TEMPLATE_DIR);
        if (!file3.exists()) {
            file3.mkdirs();
        }
        File file4 = new File(file2, "modules");
        for (File file5 : file4.listFiles()) {
            if (!file5.isDirectory()) continue;
            for (File file6 : file5.listFiles()) {
                if (!file6.isDirectory() || !file6.getName().equals("server_config")) continue;
                try {
                    InternalJrfUtils.copyDir(file6, file3, false);
                }
                catch (IOException iOException) {
                    throw new PortabilityLayerException(iOException);
                }
            }
        }
    }

    public static void copyServerConfigTemplateToServerDir(File file, File file2, File file3) throws Exception {
        File file4 = new File(file, ORA_SERVER_CONFIG_TEMPLATE_DIR);
        if (!file4.exists()) {
            InternalJrfUtils.initServerConfigTemplateDir(file, file2);
        }
        if (!file3.exists()) {
            file3.mkdirs();
        }
        try {
            InternalJrfUtils.copyDir(file4, file3, false);
            InternalJrfUtils.copyLoggingTemplateToServerDir(file, file3);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{file3.getAbsolutePath(), exception.getMessage()}), exception);
        }
    }

    public static void copyConfigsToServerDir(File file, File file2) throws Exception {
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(file, "modules");
        for (File file4 : file3.listFiles()) {
            if (!file4.isDirectory()) continue;
            for (File file5 : file4.listFiles()) {
                if (!file5.isDirectory() || !file5.getName().equals("server_config")) continue;
                try {
                    InternalJrfUtils.copyDir(file5, file2, false);
                }
                catch (IOException iOException) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{file5.getAbsolutePath(), file2.getAbsolutePath(), iOException.getMessage()}), iOException);
                }
            }
        }
        try {
            InternalJrfUtils.copyLoggingTemplateToServerDir(file2);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{file2.getAbsolutePath(), exception.getMessage()}), exception);
        }
    }

    public static void copyLoggingTemplateToServerDir(File file) throws Exception {
        File file2 = new File(file.getParentFile().getParentFile(), ORA_LOG_TEMPLATE);
        File file3 = new File(file, "logging.xml");
        if (file2.exists() && !file3.exists()) {
            InternalJrfUtils.copyStream(new FileInputStream(file2), new FileOutputStream(file3));
        }
    }

    private static void copyLoggingTemplateToServerDir(File file, File file2) throws Exception {
        File file3 = new File(file, ORA_LOG_TEMPLATE);
        File file4 = new File(file2, "logging.xml");
        if (file3.exists() && !file4.exists()) {
            InternalJrfUtils.copyStream(new FileInputStream(file3), new FileOutputStream(file4));
        }
    }

    public static void mergeLoggersFromDir(File file, File file2, File file3) throws Exception {
        File file4 = new File(file2, ORA_LOGGING_EXCLUSION_FILE);
        File file5 = new File(file, ORA_LOGGER_DIR);
        if (!file5.exists()) {
            return;
        }
        if (!file3.exists()) {
            return;
        }
        ArrayList<String> arrayList = InternalJrfUtils.getNewLoggers(file5, file4);
        InternalJrfUtils.updateLoggerExclusionList(file5, file4);
        for (String string : arrayList) {
            File file6 = new File(file5, string);
            try {
                LoggingConfigUtil.mergeConfiguration((String)file6.getPath(), (String)file3.getPath());
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("ODL-52065")) continue;
                throw exception;
            }
        }
    }

    public static ArrayList<String> getDiscoveredLoggers(File file) throws IOException {
        if (discovered_loggers != null) {
            return discovered_loggers;
        }
        discovered_loggers = new ArrayList();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.getName().endsWith("logging.xml")) continue;
            discovered_loggers.add(file2.getName());
        }
        return discovered_loggers;
    }

    public static ArrayList<String> getExcludedLoggers(File file) throws IOException {
        if (excluded_loggers != null) {
            return excluded_loggers;
        }
        excluded_loggers = new ArrayList();
        if (!file.exists()) {
            file.createNewFile();
            return excluded_loggers;
        }
        Scanner scanner = new Scanner(file);
        scanner.reset();
        while (scanner.hasNext()) {
            String string = scanner.nextLine().trim();
            excluded_loggers.add(string);
        }
        scanner.close();
        return excluded_loggers;
    }

    public static ArrayList<String> getNewLoggers(File file, File file2) throws IOException {
        if (new_loggers != null) {
            return new_loggers;
        }
        new_loggers = new ArrayList();
        ArrayList<String> arrayList = InternalJrfUtils.getExcludedLoggers(file2);
        ArrayList<String> arrayList2 = InternalJrfUtils.getDiscoveredLoggers(file);
        for (String string : arrayList2) {
            if (arrayList.contains(string)) continue;
            new_loggers.add(string);
        }
        return new_loggers;
    }

    public static void updateLoggerExclusionList(File file, File file2) throws IOException {
        ArrayList<String> arrayList = InternalJrfUtils.getExcludedLoggers(file2);
        ArrayList<String> arrayList2 = InternalJrfUtils.getNewLoggers(file, file2);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2.getPath())));
        arrayList.addAll(arrayList2);
        for (String string : arrayList) {
            printWriter.println(string);
        }
        printWriter.flush();
        printWriter.close();
        InternalJrfUtils.resetLoggerVars();
    }

    public static void resetLoggerVars() {
        new_loggers = null;
        excluded_loggers = null;
        discovered_loggers = null;
    }

    public static void clearLoggerExclusionList(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.close();
        InternalJrfUtils.resetLoggerVars();
    }

    public static void delete(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            for (File file2 : file.listFiles()) {
                InternalJrfUtils.delete(file2);
            }
            file.delete();
        }
        if (file.exists()) {
            throw new Exception("Unable to delete" + file.getAbsolutePath());
        }
    }

    public static MBeanServerConnection getWlsEditConnection(String string, String string2, String string3, String string4) throws Exception {
        return InternalJrfUtils.getWlsConnection(string, string2, string3, string4, "weblogic.management.mbeanservers.edit");
    }

    public static MBeanServerConnection getWlsConnection(String string, String string2, String string3, String string4, String string5) throws IOException, MalformedURLException {
        String string6 = MessageFormat.format(WL_JMX_SERVICE_URL_PATTERN, string, string2, string5);
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string6);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(4);
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string4);
        hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        hashtable.put("jmx.remote.x.request.waiting.timeout", new Long(100000L));
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
        return jMXConnector.getMBeanServerConnection();
    }

    public static ObjectName activate(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws Exception {
        ObjectName objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, "activate", new Object[]{new Long(120000L)}, new String[]{"java.lang.Long"});
        return objectName2;
    }

    public static ObjectName lookupMBean(MBeanServerConnection mBeanServerConnection, ObjectName objectName, String string, String string2) throws Exception {
        return (ObjectName)mBeanServerConnection.invoke(objectName, string, new Object[]{string2}, new String[]{"java.lang.String"});
    }

    public static ObjectName startEditSession(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws Exception {
        ObjectName objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, "startEdit", new Object[]{new Integer(60000), new Integer(120000)}, new String[]{"java.lang.Integer", "java.lang.Integer"});
        if (objectName2 == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10019", new String[0]));
        }
        return objectName2;
    }

    public static void addTarget(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2) throws Exception {
        mBeanServerConnection.invoke(objectName, "addTarget", new Object[]{objectName2}, new String[]{"javax.management.ObjectName"});
    }

    public static void removeTarget(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2) throws Exception {
        mBeanServerConnection.invoke(objectName, "removeTarget", new Object[]{objectName2}, new String[]{"javax.management.ObjectName"});
    }

    static {
        WL_TYPE_TO_MBEAN_LOOKUPSERVICE = new String[][]{{"app-deployment", "lookupAppDeployment"}, {"library", "lookupLibrary"}, {"shutdown-class", "lookupShutdownClass"}, {"startup-class", "lookupStartupClass"}, {"jdbc-system-resource", "lookupJDBCSystemResource"}, {"wldf-system-resource", "lookupWLDFSystemResource"}};
    }
}

