/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JRFServiceFactory;
import oracle.jrf.JRFServiceMBean;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class JRFService
implements JRFServiceMBean {
    Logger logger = Logger.getLogger(JRFService.class.getName());

    @Override
    public void applyJRF(String string) throws Exception {
        JRFServiceFactory.getJRFService().applyJRF(string);
    }

    @Override
    public boolean checkIfJRFApplied(String string) throws Exception {
        return JRFServiceFactory.getJRFService().checkIfJRFApplied(string);
    }

    @Override
    public Map<String, Integer> checkIfJRFAppliedOnMutipleTargets(String[] stringArray) throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : stringArray) {
            try {
                boolean bl = this.checkIfJRFApplied(string);
                hashMap.put(string, bl ? 1 : 0);
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20036", new String[]{string, exception.getMessage()}));
                hashMap.put(string, -1);
            }
        }
        return hashMap;
    }

    private void checkJBossWebSphereAS() throws PortabilityLayerException {
        if (ServerPlatformSupportFactory.getInstance().isJBoss() || ServerPlatformSupportFactory.getInstance().isWebSphereAS()) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
        }
    }

    @Override
    public String getServerURL(String string, String string2) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig portConfig = ServerPlatformSupportFactory.getInstance().getPortConfig(string);
        Port port = portConfig.getServerPort(string2);
        return port == null ? null : port.getURLString();
    }

    @Override
    public String getServerJndiUrl(String string) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig portConfig = ServerPlatformSupportFactory.getInstance().getPortConfig(string);
        return portConfig == null ? null : portConfig.getJndiProviderURL();
    }

    @Override
    public String getServerJndiSslUrl(String string) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig portConfig = ServerPlatformSupportFactory.getInstance().getPortConfig(string);
        return portConfig == null ? null : portConfig.getJndiSslProviderURL();
    }
}

