/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JrfUtils {
    public static String JRF_LOGGER = "oracle.jrf";
    public static final String APP_DEPLOYMENT = "app-deployment";
    public static final String LIBRARY = "library";
    public static final String STARTUP_CLASS = "startup-class";
    public static final String SHUTDOWN_CLASS = "shutdown-class";
    public static final String JDBC_SYSTEM_RESOURCE = "jdbc-system-resource";
    public static final String WLDF_SYSTEM_RESOURCE = "wldf-system-resource";

    public static String getDomainHome() throws PortabilityLayerException {
        String string = System.getProperty("domain.home");
        if (string == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10007"));
        }
        return string;
    }

    public static String getServersConfigDir(String string) throws PortabilityLayerException {
        if (string == null || string.trim().equals("")) {
            string = JrfUtils.getDomainHome();
        }
        File file = new File(string, File.separator + "config" + File.separator + "fmwconfig" + File.separator + "servers");
        return file.getAbsolutePath();
    }

    public static Map<String, List<String>> getResourceMapFromDomainConfig(String string) throws PortabilityLayerException {
        File file = new File(JrfUtils.getDomainHome(), File.separator + "config" + File.separator + "config.xml");
        try {
            return JrfUtils.getJRFResourceMap(string, new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10010", new String[]{JrfUtils.getDomainHome()}), fileNotFoundException);
        }
    }

    private static Map<String, List<String>> getJRFResourceMap(String string, InputStream inputStream) throws PortabilityLayerException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10011"), exception);
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
                String string3 = "*";
                NodeList nodeList2 = element2.getElementsByTagName("target");
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    string3 = nodeList2.item(0).getChildNodes().item(0).getNodeValue();
                }
                hashMap.put(string2, JrfUtils.convertStringToList(string3));
            }
        }
        return hashMap;
    }

    private static List<String> convertStringToList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String getCommonComponentsHome() throws PortabilityLayerException {
        String string = System.getProperty("common.components.home");
        if (string == null) {
            string = System.getenv("COMMON_COMPONENTS_HOME");
        }
        if (string == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012"));
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012", new String[]{string}));
        }
        return string;
    }

    public static String getJrfTemplateJar() throws PortabilityLayerException {
        return JrfUtils.getCommonComponentsHome() + File.separator + "common" + File.separator + "templates" + File.separator + "wls" + File.separator + "oracle.jrf_template_12.1.3.jar";
    }
}

