/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.Serializable;
import java.net.UnknownHostException;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public final class Port
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String protocol;
    private String host;
    private Integer port;
    private String urlString;
    private String resolvedDNSHost;
    private String dnsUrlString;
    private PortConfig portConfig;

    public Port(String string, String string2, Integer n, PortConfig portConfig) throws UnknownHostException {
        this.protocol = string;
        this.host = string2;
        this.resolvedDNSHost = PortConfig.resolveHost(string2);
        this.port = n == null ? -1 : n;
        this.portConfig = portConfig;
    }

    public Port(String string, PortConfig portConfig) throws UnknownHostException, PortabilityLayerException {
        this.portConfig = portConfig;
        this.parse(string);
        this.resolvedDNSHost = PortConfig.resolveHost(this.host);
    }

    private void parse(String string) throws PortabilityLayerException {
        String[] stringArray = string.split("://");
        if (stringArray.length != 2) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20035"));
        }
        this.protocol = stringArray[0];
        if ((stringArray = stringArray[1].split(":")).length > 2) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20035"));
        }
        this.host = stringArray[0];
        this.port = stringArray.length == 2 ? new Integer(stringArray[1]) : -1;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getDnsResolvedHost() {
        return this.resolvedDNSHost;
    }

    public boolean isLocal() {
        return this.resolvedDNSHost.equals(this.portConfig.getLocalHost());
    }

    public int getPort() {
        return this.port;
    }

    public String getURLString() {
        if (this.urlString == null) {
            this.urlString = this.port > 0 ? this.protocol + "://" + this.host + ":" + this.port : this.protocol + "://" + this.host;
        }
        return this.urlString;
    }

    public String getDnsResolvedURLString() {
        if (this.dnsUrlString == null) {
            String string = this.protocol.equals("corbaloc:iiop") ? this.protocol + ":" : this.protocol + "://";
            this.dnsUrlString = this.port > 0 ? string + this.resolvedDNSHost + ":" + this.port : string + this.resolvedDNSHost;
        }
        return this.dnsUrlString;
    }
}

