/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotificationListener;
import oracle.jrf.Port;
import oracle.jrf.PortabilityLayerException;

public abstract class PortConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Port> serverPorts;
    private Port frontEndHttpPort;
    private Port frontEndHttpSslPort;
    private Port clusterFrontEndHttpPort;
    private Port clusterFrontEndHttpSslPort;
    private Map<String, List<Port>> clusterMemberPorts;
    private String localHost;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    protected final String PROPERTIES_FILE_NAME = "jrf-port-config.properties";
    public static final String WEBLOGIC_T3 = "t3";
    public static final String WEBLOGIC_T3S = "t3s";
    public static final String WEBLOGIC_IIOP = "iiop";
    public static final String WEBLOGIC_IIOPS = "iiops";
    public static final String WEBSPHERE_CORBALOC_IIOP = "corbaloc:iiop";
    public static final String WEBSPHERE_IIOP = "iiop";
    public static final String JBOSS_JNP = "jnp";

    protected PortConfig() throws Exception {
        this.initLocalHost();
    }

    public abstract String[] getSupportedPortProtocols();

    protected void setFrontEndHttpPort(Port port) {
        this.frontEndHttpPort = port;
    }

    protected void setFrontEndHttpSslPort(Port port) {
        this.frontEndHttpSslPort = port;
    }

    protected void setClusterFrontEndHttpPort(Port port) {
        this.clusterFrontEndHttpPort = port;
    }

    protected void setClusterFrontEndHttpSslPort(Port port) {
        this.clusterFrontEndHttpSslPort = port;
    }

    public Port getHttpPort() {
        return this.getServerPort(HTTP);
    }

    public List<Port> getClusterHttpPorts() {
        return this.getClusterMemberPorts(HTTP);
    }

    public Port getHttpSslPort() {
        return this.getServerPort(HTTPS);
    }

    public List<Port> getClusterHttpSslPorts() {
        return this.getClusterMemberPorts(HTTPS);
    }

    public Port getFrontEndHttpPort() {
        return this.frontEndHttpPort;
    }

    public Port getFrontEndHttpSslPort() {
        return this.frontEndHttpSslPort;
    }

    public Port getClusterFrontEndHttpPort() {
        return this.clusterFrontEndHttpPort;
    }

    public Port getClusterFrontEndHttpSslPort() {
        return this.clusterFrontEndHttpSslPort;
    }

    public List<Port> getClusterMemberPorts(String string) {
        if (this.clusterMemberPorts != null) {
            return this.clusterMemberPorts.get(string);
        }
        return null;
    }

    protected void addClusterMemberPort(Port port) {
        if (port != null) {
            List<Port> list;
            if (this.clusterMemberPorts == null) {
                this.clusterMemberPorts = new HashMap<String, List<Port>>();
            }
            if ((list = this.clusterMemberPorts.get(port.getProtocol())) == null) {
                list = new ArrayList<Port>();
            }
            list.add(port);
            this.clusterMemberPorts.put(port.getProtocol(), list);
        }
    }

    public Port getServerPort(String string) {
        if (this.serverPorts != null) {
            return this.serverPorts.get(string);
        }
        return null;
    }

    protected void addServerPort(Port port) {
        if (port != null) {
            if (this.serverPorts == null) {
                this.serverPorts = new HashMap<String, Port>();
            }
            this.serverPorts.put(port.getProtocol(), port);
        }
    }

    public String getJndiProviderURL() {
        for (String string : this.getDefaultJndiProtocols()) {
            String string2 = this.getJndiProviderURL(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getJndiSslProviderURL() {
        for (String string : this.getDefaultJndiSslProtocols()) {
            String string2 = this.getJndiProviderURL(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private String getJndiProviderURL(String string) {
        if (this.isClustered()) {
            return this.getClusterJndiProviderURL(string);
        }
        Port port = this.getServerPort(string);
        if (port != null) {
            return port.getDnsResolvedURLString();
        }
        return null;
    }

    protected String getClusterJndiProviderURL(String string) {
        List<Port> list = this.getClusterMemberPorts(string);
        if (list != null) {
            String string2 = null;
            for (Port port : list) {
                if (string2 == null) {
                    string2 = this.getClusterProtocolURLPrefix(port.getProtocol()) + port.getDnsResolvedHost() + ":" + port.getPort();
                    continue;
                }
                string2 = string2 + this.getClusterJNDISeparator() + port.getDnsResolvedHost() + ":" + port.getPort();
            }
            return string2;
        }
        return null;
    }

    private String getClusterProtocolURLPrefix(String string) {
        if (WEBSPHERE_CORBALOC_IIOP.equals(string) || "iiop".equals(string)) {
            return "corbaloc::";
        }
        return string + "://";
    }

    protected String getClusterJNDISeparator() {
        return ",";
    }

    public abstract boolean isClustered();

    protected abstract String[] getDefaultJndiProtocols();

    protected abstract String[] getDefaultJndiSslProtocols();

    protected String getLocalHost() {
        return this.localHost;
    }

    protected void initLocalHost() throws UnknownHostException {
        this.localHost = InetAddress.getLocalHost().getCanonicalHostName();
    }

    protected static String resolveHost(String string) throws UnknownHostException {
        if (string.indexOf("localhost") > -1 || string.indexOf("127.0.0.1") > -1) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = inetAddress.getCanonicalHostName();
        if (string2.indexOf(".") < 0 && string.indexOf(".") > 0) {
            return string;
        }
        return string2;
    }

    protected abstract void registerPortConfigChangeListener(NotificationListener var1) throws PortabilityLayerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePortConfigPropertiesFile(File file) throws Exception {
        Object object;
        if (!file.exists()) {
            return;
        }
        Properties properties = new Properties();
        try {
            object = new FileInputStream(file);
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((FileInputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = properties.getProperty("frontend.http.host");
        String string = properties.getProperty("frontend.http.port");
        if (object != null && string != null) {
            this.setFrontEndHttpPort(new Port(HTTP, (String)object, Integer.valueOf(string), this));
        }
        object = properties.getProperty("frontend.https.host");
        string = properties.getProperty("frontend.https.port");
        if (object != null && string != null) {
            this.setFrontEndHttpSslPort(new Port(HTTPS, (String)object, Integer.valueOf(string), this));
        }
        object = properties.getProperty("http.host");
        string = properties.getProperty("http.port");
        if (object != null && string != null) {
            this.addServerPort(new Port(HTTP, (String)object, Integer.valueOf(string), this));
        }
        object = properties.getProperty("https.host");
        string = properties.getProperty("https.port");
        if (object != null && string != null) {
            this.addServerPort(new Port(HTTPS, (String)object, Integer.valueOf(string), this));
        }
    }
}

