/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.lang.reflect.Method;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.UnknownPlatformException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class ServerPlatformSupportFactory {
    protected static ServerPlatformSupport instance = null;

    public static ServerPlatformSupport getInstance() throws PortabilityLayerException {
        if (instance != null) {
            return instance;
        }
        if (System.getProperty("weblogic.Name") != null) {
            try {
                instance = (ServerPlatformSupport)Class.forName("oracle.jrf.wls.WlsJrfInternalPlatform").newInstance();
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10020", new String[]{exception.getMessage()}), exception);
            }
        } else if (System.getProperty("was.install.root") != null || System.getProperty("server.root") != null) {
            try {
                if (ServerPlatformSupportFactory.isND()) {
                    instance = (ServerPlatformSupport)Class.forName("oracle.jrf.was.WasNDJrfInternalPlatform").newInstance();
                }
                instance = (ServerPlatformSupport)Class.forName("oracle.jrf.was.WasASJrfInternalPlatform").newInstance();
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10021", new String[]{exception.getMessage()}), exception);
            }
        } else if (System.getProperty("jboss.home.dir") != null) {
            try {
                instance = (ServerPlatformSupport)Class.forName("oracle.jrf.jboss.JBossJrfInternalPlatform").newInstance();
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10025", new String[]{exception.getMessage()}), exception);
            }
        } else {
            throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10024"));
        }
        return instance;
    }

    private static boolean isND() throws Exception {
        Class<?> clazz = Class.forName("oracle.jrf.was.WasServerPlatformSupport");
        Method method = clazz.getMethod("isND", new Class[0]);
        Boolean bl = (Boolean)method.invoke(null, new Object[0]);
        return bl;
    }
}

