/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JRFInternalPlatform;
import oracle.jrf.JRFInternalPlatformFactory;
import oracle.jrf.JrfUtils;
import oracle.jrf.ServerStartupShutdownProvider;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class ServerStartupShutdownManager {
    protected List<ServerStartupShutdownProvider> startupList;
    protected List<ServerStartupShutdownProvider> shutdownList;
    private static List<String> failedStartupProviders;
    private static int startupCount;
    private static final Logger LOGGER;

    public ServerStartupShutdownManager() {
        this.initialize();
    }

    private void initialize() {
        ServiceLoader<ServerStartupShutdownProvider> serviceLoader = ServiceLoader.load(ServerStartupShutdownProvider.class);
        this.startupList = new ArrayList<ServerStartupShutdownProvider>();
        for (ServerStartupShutdownProvider serverStartupShutdownProvider : serviceLoader) {
            this.startupList.add(serverStartupShutdownProvider);
        }
        Collections.sort(this.startupList, new Comparator<ServerStartupShutdownProvider>(){

            @Override
            public int compare(ServerStartupShutdownProvider serverStartupShutdownProvider, ServerStartupShutdownProvider serverStartupShutdownProvider2) {
                return serverStartupShutdownProvider.getStartupOrder() - serverStartupShutdownProvider2.getStartupOrder();
            }
        });
        this.shutdownList = new ArrayList<ServerStartupShutdownProvider>(this.startupList);
        Collections.sort(this.shutdownList, new Comparator<ServerStartupShutdownProvider>(){

            @Override
            public int compare(ServerStartupShutdownProvider serverStartupShutdownProvider, ServerStartupShutdownProvider serverStartupShutdownProvider2) {
                return serverStartupShutdownProvider.getShutdownOrder() - serverStartupShutdownProvider2.getShutdownOrder();
            }
        });
    }

    public void startup() throws Exception {
        Throwable throwable = null;
        JRFInternalPlatform jRFInternalPlatform = JRFInternalPlatformFactory.getInstance();
        for (ServerStartupShutdownProvider serverStartupShutdownProvider : this.startupList) {
            try {
                if (!jRFInternalPlatform.isTargeted(serverStartupShutdownProvider.getTargets())) continue;
                LOGGER.log(Level.INFO, JRFMessageBundleHelper.msg.getString("JRF-10028", new String[]{serverStartupShutdownProvider.getClass().getName()}));
                serverStartupShutdownProvider.startup();
                ++startupCount;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace(System.err);
                ServerStartupShutdownManager.getFailedStartupProviders().add(serverStartupShutdownProvider.getClass().getName());
                throwable = throwable == null ? throwable2 : throwable;
            }
        }
        if (throwable != null) {
            String string = JRFMessageBundleHelper.msg.getString("JRF-20033", new String[]{ServerStartupShutdownManager.getFailedStartupProviders().toString()});
            throw (Exception)new Exception(string).initCause(throwable);
        }
    }

    public void shutdown() throws Exception {
        Throwable throwable = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        JRFInternalPlatform jRFInternalPlatform = JRFInternalPlatformFactory.getInstance();
        for (ServerStartupShutdownProvider serverStartupShutdownProvider : this.shutdownList) {
            try {
                if (!jRFInternalPlatform.isTargeted(serverStartupShutdownProvider.getTargets())) continue;
                LOGGER.log(Level.INFO, JRFMessageBundleHelper.msg.getString("JRF-10028", new String[]{serverStartupShutdownProvider.getClass().getName()}));
                serverStartupShutdownProvider.shutdown();
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace(System.err);
                arrayList.add(serverStartupShutdownProvider.getClass().getName());
                throwable = throwable == null ? throwable2 : throwable;
            }
        }
        if (throwable != null) {
            String string = JRFMessageBundleHelper.msg.getString("JRF-20034", new String[]{arrayList.toString()});
            throw (Exception)new Exception(string).initCause(throwable);
        }
    }

    public static boolean areAllProvidersStarted() {
        return startupCount > 0 && ServerStartupShutdownManager.getFailedStartupProviders().isEmpty();
    }

    protected static void resetStartedProvidersStatus() {
        startupCount = 0;
        failedStartupProviders = null;
    }

    private static List<String> getFailedStartupProviders() {
        if (failedStartupProviders == null) {
            failedStartupProviders = new ArrayList<String>();
        }
        return failedStartupProviders;
    }

    static {
        startupCount = 0;
        LOGGER = Logger.getLogger(JrfUtils.JRF_LOGGER);
    }
}

