/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.jboss;

import java.net.InetAddress;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import org.jboss.mx.util.MBeanServerLocator;

public final class JBossPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private transient ObjectName webServer;
    private transient ObjectName webServerSevice;
    private transient ObjectName webServerConnector;
    private transient ObjectName namingService;

    JBossPortConfig() throws Exception {
        this.initialize();
    }

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "jnp"};
    }

    protected void initialize() throws Exception {
        ObjectName[] objectNameArray;
        MBeanServer mBeanServer = MBeanServerLocator.locateJBoss();
        this.webServer = new ObjectName("jboss.web:type=Server");
        String string = (String)mBeanServer.getAttribute(this.webServer, "address");
        if (string == null || string.trim().isEmpty()) {
            string = this.getLocalHost();
        }
        ObjectName[] objectNameArray2 = (ObjectName[])mBeanServer.getAttribute(this.webServer, "serviceNames");
        this.webServerSevice = objectNameArray2[0];
        for (ObjectName objectName : objectNameArray = (ObjectName[])mBeanServer.getAttribute(this.webServerSevice, "connectorNames")) {
            int n = (Integer)mBeanServer.getAttribute(objectName, "port");
            String string2 = (String)mBeanServer.getAttribute(objectName, "protocol");
            boolean bl = (Boolean)mBeanServer.getAttribute(objectName, "secure");
            if (string2.indexOf("HTTP") <= -1) continue;
            this.webServerConnector = objectName;
            Object object = mBeanServer.getAttribute(objectName, "address");
            if (object != null) {
                String string3 = object instanceof InetAddress ? ((InetAddress)object).getCanonicalHostName() : ((String)object).trim();
                String string4 = string = string3.indexOf("0.0.0.0") > -1 ? PortConfig.resolveHost(string) : string3;
            }
            if (bl) {
                this.addServerPort(new Port("https", string, n, this));
                this.setFrontEndHttpSslPort(this.getHttpSslPort());
                break;
            }
            this.addServerPort(new Port("http", string, n, this));
            this.setFrontEndHttpPort(this.getHttpPort());
            break;
        }
        this.namingService = new ObjectName("jboss:service=Naming");
        Integer n = (Integer)mBeanServer.getAttribute(this.namingService, "Port");
        this.addServerPort(new Port("jnp", this.getLocalHost(), n, this));
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"jnp"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return this.getDefaultJndiProtocols();
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener notificationListener) throws PortabilityLayerException {
        try {
            MBeanServer mBeanServer = MBeanServerLocator.locateJBoss();
            AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("address");
            attributeChangeNotificationFilter.enableAttribute("serviceNames");
            mBeanServer.addNotificationListener(this.webServer, notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
            attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("connectorNames");
            mBeanServer.addNotificationListener(this.webServerSevice, notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
            attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("address");
            attributeChangeNotificationFilter.enableAttribute("port");
            attributeChangeNotificationFilter.enableAttribute("protocol");
            attributeChangeNotificationFilter.enableAttribute("secure");
            mBeanServer.addNotificationListener(this.webServerConnector, notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
            attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("Port");
            mBeanServer.addNotificationListener(this.namingService, notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }
}

