/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.jboss;

import java.io.File;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.jboss.JBossPortConfig;

public class JBossServerPlatformSupport
extends AbstractServerPlatformSupport {
    @Override
    public String getDomainName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getPlatformName() {
        return "jboss";
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getServerConfigDirectory(String string, String string2) throws PortabilityLayerException {
        return this.getServerConfigDirectory();
    }

    @Override
    public boolean isJBoss() {
        return true;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            this.serverLogPath = System.getProperty("jboss.server.log.dir");
        }
        return this.serverLogPath;
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier applicationIdentifier = null;
        try {
            String string = this.getApplicationName();
            applicationIdentifier = new ApplicationIdentifier(string, string, null);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{exception.getMessage()}), exception);
        }
        return applicationIdentifier;
    }

    private String getApplicationName() {
        String string = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; string == null && i < 20; ++i) {
            string = this.getApplicationNameFromClassLoader(classLoader);
            ClassLoader classLoader2 = classLoader.getParent();
            if (classLoader2 == null || classLoader2 == classLoader) break;
            classLoader = classLoader2;
        }
        return string;
    }

    private String getApplicationNameFromClassLoader(ClassLoader classLoader) {
        String string = classLoader.toString();
        String string2 = null;
        String string3 = null;
        if (string.indexOf("vfszip:") != -1) {
            string2 = string.substring(string.indexOf("vfszip:") + 7, string.length() - 2);
            string3 = string2.indexOf(".war") != -1 && string2.indexOf(".ear") != -1 ? new File(string2.substring(0, string2.indexOf(".ear") + ".ear".length())).getName() : new File(string2).getName();
        } else if (string.indexOf("vfsfile:") != -1) {
            string2 = string.substring(string.indexOf("vfsfile:") + 8, string.length() - 2);
            string3 = new File(string2).getName();
        }
        return string3;
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        return "cluster_unknown";
    }

    @Override
    public PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new JBossPortConfig();
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    @Override
    public PortConfig getPortConfig(String string) throws PortabilityLayerException {
        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }
}

