/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.AbstractTemplate;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.TemplateHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTemplateBuilder {
    protected AbstractTemplate template;
    private File templateDir;
    protected static final String TEMPLATE_INFO_XML = "template-info.xml";
    protected static final String NAME = "name";
    protected static final String VERSION = "version";
    protected static final String CONFIG_GROUPS_XML = "config-groups.xml";
    protected static final String GROUP = "group";
    protected static final String GROUP_REF = "group-ref";
    protected static final String LIBRARY = "library";

    public Template getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTemplate(File file) throws PortabilityLayerException {
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10008", new String[]{file.getName()}), iOException);
            }
            this.template.oracleHome = file.getParentFile().getParentFile().getParentFile().getParent();
            this.templateDir = file.getParentFile();
            this.readTemplateInfo(jarFile);
            this.readConfigXml(jarFile);
            this.readConfigGroups(jarFile);
            this.readJvmConfig(jarFile);
            this.safeClose(jarFile);
        }
        catch (Throwable throwable) {
            this.safeClose(jarFile);
            throw throwable;
        }
    }

    private void readTemplateInfo(JarFile jarFile) throws PortabilityLayerException {
        Element element = this.getDocumentElement(jarFile, TEMPLATE_INFO_XML);
        this.template.name = element.getAttribute(NAME);
        this.template.version = element.getAttribute(VERSION);
        NodeList nodeList = element.getElementsByTagName("requires");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            String string2 = node.getAttributes().getNamedItem(NAME).getNodeValue();
            Template template = this.findDependentTemplate(string2, string = "12.1.3.0");
            if (template == null && (string2.equals("WebLogic Coherence Cluster Extension") || string2.equals("WebLogic Template for JRF Domain"))) continue;
            if (template == null) {
                template = this.findDependentTemplate(string2, "12.1.2.0");
            }
            this.template.subTemplates.add(template);
        }
    }

    private Template findDependentTemplate(String string, String string2) throws PortabilityLayerException {
        File file;
        if (this.template.isWebLogic()) {
            file = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/wls/"), string, string2);
            if (file == null) {
                file = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/applications/"), string, string2);
            }
        } else {
            file = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/was/"), string, string2);
        }
        if (file != null) {
            return TemplateHelper.getInstance().getTemplate(this.template.isWebLogic(), this.template.getOracleHome(), file.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findTemplateFile(File file, String string, String string2) throws PortabilityLayerException {
        for (File file2 : file.listFiles()) {
            if (file2.getName().indexOf(".jar") <= 0) continue;
            JarFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(file2);
                }
                catch (IOException iOException) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10008", new String[]{file2.getName()}), iOException);
                }
                Element element = this.getDocumentElement(jarFile, TEMPLATE_INFO_XML);
                if (string.equals(element.getAttribute(NAME)) && string2.equals(element.getAttribute(VERSION))) {
                    File file3 = file2;
                    this.safeClose(jarFile);
                    return file3;
                }
                this.safeClose(jarFile);
            }
            catch (Throwable throwable) {
                this.safeClose(jarFile);
                throw throwable;
            }
        }
        return null;
    }

    protected abstract void readConfigXml(JarFile var1) throws PortabilityLayerException;

    protected void readApplications(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Application application = new Application();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                this.processApplicationChildNode(application, nodeList2.item(j).getNodeName(), nodeList2.item(j).getTextContent());
            }
            this.template.allApplications.put(application.getName(), application);
        }
    }

    protected abstract void processApplicationChildNode(Application var1, String var2, String var3);

    protected void readLibraries(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Library library = new Library();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                this.processLibraryChildNode(library, nodeList2.item(j).getNodeName(), nodeList2.item(j).getTextContent());
            }
            this.template.allLibraries.put(library.getName(), library);
        }
    }

    protected abstract void processLibraryChildNode(Library var1, String var2, String var3);

    protected void readConfigGroups(JarFile jarFile) throws PortabilityLayerException {
        Element element = this.getDocumentElement(jarFile, CONFIG_GROUPS_XML);
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName(GROUP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getAttributes().getNamedItem(NAME).getNodeValue();
            this.template.applications.put(string, new ArrayList());
            this.template.libraries.put(string, new ArrayList());
            this.template.startupClasses.put(string, new ArrayList());
            this.template.shutdownClasses.put(string, new ArrayList());
            this.template.urlProviders.put(string, new ArrayList());
            this.template.wldfSystemResources.put(string, new ArrayList());
            this.template.jdbcSystemResources.put(string, new ArrayList());
            this.template.configGroupReferences.put(string, new ArrayList());
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string2 = nodeList2.item(j).getNodeName();
                if (string2.equals("#text") || string2.equals("#comment")) continue;
                this.processConfigGroupResource(string2, nodeList2.item(j).getAttributes().getNamedItem(NAME).getNodeValue(), string);
            }
        }
    }

    protected void processConfigGroupResource(String string, String string2, String string3) {
        if (string.equals(LIBRARY)) {
            this.template.libraries.get(string3).add(this.template.allLibraries.get(string2));
        } else if (string.equals(GROUP_REF)) {
            this.template.configGroupReferences.get(string3).add(string2);
        }
    }

    protected void readJvmConfig(JarFile jarFile) throws PortabilityLayerException {
    }

    protected Element getDocumentElement(JarFile jarFile, String string) throws PortabilityLayerException {
        Object object;
        InputStream inputStream = null;
        try {
            object = jarFile.getEntry(string);
            if (object == null) {
                return null;
            }
            inputStream = jarFile.getInputStream((ZipEntry)object);
        }
        catch (IOException iOException) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10009", new String[]{jarFile.getName() + ":" + string}), iOException);
        }
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setValidating(false);
        ((DocumentBuilderFactory)object).setNamespaceAware(true);
        try {
            return ((DocumentBuilderFactory)object).newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20019", new String[]{exception.getMessage()}), exception);
        }
    }

    private void safeClose(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

