/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.ArrayList;
import java.util.List;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.NamedResource;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.TemplateHelper;

public class JRFTemplateHelper {
    public static final String JRF_ALL_APPS_TAG = "JRF-ALL-APPS";
    public static final String JRF_ADMIN_APPS_TAG = "JRF-ADMIN-APPS";
    public static final String JRF_DMGR_APPS_TAG = "JRF-DMGR-APPS";
    public static final String APP_DEPLOYMENT = "app-deployment";
    public static final String LIBRARY = "library";
    public static final String STARTUP_CLASS = "startup-class";
    public static final String SHUTDOWN_CLASS = "shutdown-class";
    public static final String JDBC_SYSTEM_RESOURCE = "jdbc-system-resource";
    public static final String WLDF_SYSTEM_RESOURCE = "wldf-system-resource";
    public static final String CUSTOM_SERVICE = "custom-service";
    public static final String URL_PROVIDER = "url-provider";

    public static List<? extends NamedResource> getJRFManagedResourcesFromTemplate(String string, Template template) throws PortabilityLayerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(JRF_ALL_APPS_TAG);
        arrayList.addAll(template.getConfigGroupReferences(JRF_ALL_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(arrayList.toArray(new String[0]), string, template);
    }

    public static List<? extends NamedResource> getJRFAdminResourcesFromTemplate(String string, Template template) throws PortabilityLayerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(JRF_ALL_APPS_TAG);
        arrayList.add(JRF_ADMIN_APPS_TAG);
        arrayList.addAll(template.getConfigGroupReferences(JRF_ALL_APPS_TAG));
        arrayList.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(arrayList.toArray(new String[0]), string, template);
    }

    public static List<? extends NamedResource> getJRFAdminOnlyResourcesFromTemplate(String string, Template template) throws PortabilityLayerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(JRF_ADMIN_APPS_TAG);
        arrayList.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(arrayList.toArray(new String[0]), string, template);
    }

    public static List<? extends NamedResource> getJRFDmgrResourcesFromTemplate(String string, Template template) throws PortabilityLayerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(JRF_DMGR_APPS_TAG);
        arrayList.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(arrayList.toArray(new String[0]), string, template);
    }

    private static List<? extends NamedResource> getJRFResourcesFromTemplate(String[] stringArray, String string, Template template) throws PortabilityLayerException {
        ArrayList<NamedResource> arrayList = new ArrayList<NamedResource>();
        for (String string2 : stringArray) {
            arrayList.addAll(JRFTemplateHelper.getResourceListFromTemplate(string2, string, template));
            for (Template template2 : template.getSubTemplates()) {
                arrayList.addAll(JRFTemplateHelper.getResourceListFromTemplate(string2, string, template2));
            }
        }
        return arrayList;
    }

    private static List<? extends NamedResource> getResourceListFromTemplate(String string, String string2, Template template) {
        if (string2.equals(APP_DEPLOYMENT)) {
            return template.getApplications(string);
        }
        if (string2.equals(LIBRARY)) {
            return template.getLibraries(string);
        }
        if (string2.equals(SHUTDOWN_CLASS)) {
            return template.getShutdownClasses(string);
        }
        if (string2.equals(STARTUP_CLASS)) {
            return template.getStartupClasses(string);
        }
        if (string2.equals(JDBC_SYSTEM_RESOURCE)) {
            return template.getJDBCSystemResources(string);
        }
        if (string2.equals(WLDF_SYSTEM_RESOURCE)) {
            return template.getWLDFSystemResources(string);
        }
        if (string2.equals(CUSTOM_SERVICE)) {
            return template.getStartupClasses(string);
        }
        if (string2.equals(URL_PROVIDER)) {
            return template.getURLProviders(string);
        }
        return null;
    }

    public static Template getJRFTemplateForWLS() throws PortabilityLayerException {
        return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_template_12.1.3.jar");
    }

    public static Template getJRFTemplateForWAS() throws PortabilityLayerException {
        return TemplateHelper.getInstance().getTemplate(false, JrfUtils.getCommonComponentsHome(), "oracle.jrf_template_12.1.3.jar");
    }
}

