/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.WasTemplateBuilder;
import oracle.jrf.templates.WlsTemplateBuilder;

public class TemplateHelper {
    private static TemplateHelper instance;
    protected static final String WLS_TEMPLATE_FOLDER = "common/templates/wls/";
    protected static final String OLD_WLS_TEMPLATE_FOLDER = "common/templates/applications/";
    protected static final String WAS_TEMPLATE_FOLDER = "common/templates/was/";
    private Map<String, Template> wlsTemplates = new HashMap<String, Template>();
    private Map<String, Template> wasTemplates = new HashMap<String, Template>();

    public static TemplateHelper getInstance() {
        if (instance == null) {
            instance = new TemplateHelper();
        }
        return instance;
    }

    public Template getTemplate(boolean bl, String string, String string2) throws PortabilityLayerException {
        Template template;
        String string3 = string + "_" + string2;
        Map<String, Template> map = this.wlsTemplates;
        if (!bl) {
            map = this.wasTemplates;
        }
        if ((template = map.get(string3)) == null) {
            if (bl) {
                WlsTemplateBuilder wlsTemplateBuilder = new WlsTemplateBuilder();
                template = wlsTemplateBuilder.getTemplate();
                map.put(string3, template);
                File file = new File(string, WLS_TEMPLATE_FOLDER + File.separator + string2);
                if (file.exists()) {
                    wlsTemplateBuilder.initTemplate(file);
                } else {
                    wlsTemplateBuilder.initTemplate(new File(string, OLD_WLS_TEMPLATE_FOLDER + File.separator + string2));
                }
            } else {
                WasTemplateBuilder wasTemplateBuilder = new WasTemplateBuilder();
                template = wasTemplateBuilder.getTemplate();
                map.put(string3, template);
                wasTemplateBuilder.initTemplate(new File(string, WAS_TEMPLATE_FOLDER + File.separator + string2));
            }
        }
        return template;
    }
}

