/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.jar.JarFile;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.AbstractTemplateBuilder;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.templates.WasTemplate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WasTemplateBuilder
extends AbstractTemplateBuilder {
    private static final String JVM_CONFIG_XML = "jvm-config.xml";
    private static final String SERVER_TOPOLOGY = "server-topology";
    private static final String ENV_CONFIG = "env-config";
    private static final String SYSTEM_PROPERTY = "java-system-property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String POST_CLASSPATH = "post-classpath";
    private static final String PATH = "path";
    private static final String INITIAL_HEAP_SIZE = "initial-heap-size";
    private static final String MAX_HEAP_SIZE = "max-heap-size";
    private static final String PERM_HEAP_SIZE = "perm-size";
    private static final String MAX_PERM_HEAP_SIZE = "max-perm-size";
    private static final String HEAP_SIZE_32 = "heap-size-32";
    private static final String HEAP_SIZE_64 = "heap-size-64";
    private static final String WAS_CONFIG_XML = "config-was/config.xml";
    private static final String WAS_APPLICATION = "application";
    private static final String WAS_CUSTOM_SERVICE = "customService";
    private static final String WAS_CLASS_PATH = "classPath";
    private static final String WAS_SOURCE_PATH = "sourcePath";
    private static final String WAS_ISOLATED_CLASSLOADER = "isolatedClassLoader";
    private static final String WAS_ENABLE_DISTRIBUTION = "enableDistribution";
    private static final String WAS_STARTING_WEIGHT = "startingWeight";
    private static final String WAS_CLASS_NAME = "classname";
    private static final String WAS_ENABLE = "enable";
    private static final String WAS_URL_PROVIDER = "URLProvider";
    private static final String WAS_STREAM_HANDLER_CLASS_NAME = "streamHandlerClassName";
    private static final String WAS_PROTOCOL = "protocol";

    public WasTemplateBuilder() {
        this.template = new WasTemplate();
    }

    @Override
    protected void readConfigXml(JarFile jarFile) throws PortabilityLayerException {
        Element element = this.getDocumentElement(jarFile, WAS_CONFIG_XML);
        this.readApplications(element.getElementsByTagName(WAS_APPLICATION));
        this.readLibraries(element.getElementsByTagName("library"));
        this.readCustomServices(element.getElementsByTagName(WAS_CUSTOM_SERVICE));
        this.readUrlProviders(element.getElementsByTagName(WAS_URL_PROVIDER));
    }

    protected void readCustomServices(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            StartupClass startupClass = new StartupClass();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeName().equals("name")) {
                    startupClass.name = nodeList2.item(j).getTextContent();
                    continue;
                }
                if (nodeList2.item(j).getNodeName().equals(WAS_CLASS_PATH)) {
                    startupClass.classPath = nodeList2.item(j).getTextContent();
                    continue;
                }
                if (nodeList2.item(j).getNodeName().equals(WAS_CLASS_NAME)) {
                    startupClass.className = nodeList2.item(j).getTextContent();
                    continue;
                }
                if (!nodeList2.item(j).getNodeName().equals(WAS_ENABLE)) continue;
                startupClass.enable = nodeList2.item(j).getTextContent();
            }
            this.template.allStartupClasses.put(startupClass.getName(), startupClass);
        }
    }

    protected void readUrlProviders(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            URLProvider uRLProvider = new URLProvider();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node = nodeList2.item(j);
                if (node.getNodeName().equals("name")) {
                    uRLProvider.name = node.getTextContent();
                    continue;
                }
                if (node.getNodeName().equals(WAS_STREAM_HANDLER_CLASS_NAME)) {
                    uRLProvider.streamHandlerClassName = node.getTextContent();
                    continue;
                }
                if (!node.getNodeName().equals(WAS_PROTOCOL)) continue;
                uRLProvider.protocol = node.getTextContent();
            }
            this.template.allUrlProviders.put(uRLProvider.getName(), uRLProvider);
        }
    }

    @Override
    protected void processApplicationChildNode(Application application, String string, String string2) {
        if (string.equals("name")) {
            application.name = string2;
        } else if (string.equals(WAS_SOURCE_PATH)) {
            application.sourcePath = string2;
        } else if (string.equals(WAS_ENABLE_DISTRIBUTION)) {
            application.enableDistribution = string2;
        } else if (string.equals(WAS_STARTING_WEIGHT)) {
            application.startingWeight = string2;
        }
    }

    @Override
    protected void processLibraryChildNode(Library library, String string, String string2) {
        if (string.equals("name")) {
            library.name = string2;
        } else if (string.equals(WAS_CLASS_PATH)) {
            library.sourcePath = string2;
        } else if (string.equals(WAS_ISOLATED_CLASSLOADER)) {
            library.isolatedClassLoader = string2;
        }
    }

    @Override
    protected void processConfigGroupResource(String string, String string2, String string3) {
        if (string.equals(WAS_APPLICATION)) {
            this.template.applications.get(string3).add(this.template.allApplications.get(string2));
        } else if (string.equals(WAS_CUSTOM_SERVICE)) {
            this.template.startupClasses.get(string3).add(this.template.allStartupClasses.get(string2));
        } else if (string.equals(WAS_URL_PROVIDER)) {
            this.template.urlProviders.get(string3).add(this.template.allUrlProviders.get(string2));
        } else {
            super.processConfigGroupResource(string, string2, string3);
        }
    }

    @Override
    protected void readJvmConfig(JarFile jarFile) throws PortabilityLayerException {
        Element element = this.getDocumentElement(jarFile, JVM_CONFIG_XML);
        NodeList nodeList = element.getElementsByTagName(SERVER_TOPOLOGY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            EnvConfig envConfig = new EnvConfig();
            envConfig.name = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagName(ENV_CONFIG).item(0).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string = nodeList2.item(j).getNodeName();
                if (string.equals(SYSTEM_PROPERTY)) {
                    envConfig.properties.put(((Element)nodeList2.item(j)).getElementsByTagName(KEY).item(0).getTextContent(), ((Element)nodeList2.item(j)).getElementsByTagName(VALUE).item(0).getTextContent());
                    continue;
                }
                if (string.equals(POST_CLASSPATH)) {
                    envConfig.postClassPath = ((Element)nodeList2.item(j)).getElementsByTagName(PATH).item(0).getTextContent();
                    continue;
                }
                if (string.equals(INITIAL_HEAP_SIZE)) {
                    envConfig.initialHeapSize32 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    envConfig.initialHeapSize64 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (string.equals(MAX_HEAP_SIZE)) {
                    envConfig.maxHeapSize32 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    envConfig.maxHeapSize64 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (string.equals(PERM_HEAP_SIZE)) {
                    envConfig.permSize32 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    envConfig.permSize64 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (!string.equals(MAX_PERM_HEAP_SIZE)) continue;
                envConfig.maxPermSize32 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                envConfig.maxPermSize64 = ((Element)nodeList2.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
            }
            this.template.allEnvConfigs.put(envConfig.getName(), envConfig);
        }
    }
}

