/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.jar.JarFile;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.AbstractTemplateBuilder;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.JDBCSystemResource;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.ShutdownClass;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.WLDFSystemResource;
import oracle.jrf.templates.WlsTemplate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WlsTemplateBuilder
extends AbstractTemplateBuilder {
    private static final String WLS_CONFIG_XML = "config/config.xml";
    private static final String WLS_APPLICATION = "app-deployment";
    private static final String WLS_STARTUP = "startup-class";
    private static final String WLS_SHUTDOWN = "shutdown-class";
    private static final String WLS_SOURCE_PATH = "source-path";
    private static final String WLS_JDBC_SYS_RESOURCES = "jdbc-system-resource";
    private static final String WLS_WLDF_SYS_RESOURCES = "wldf-system-resource";

    public WlsTemplateBuilder() {
        this.template = new WlsTemplate();
    }

    @Override
    protected void readConfigXml(JarFile jarFile) throws PortabilityLayerException {
        Element element = this.getDocumentElement(jarFile, WLS_CONFIG_XML);
        this.readApplications(element.getElementsByTagName(WLS_APPLICATION));
        this.readLibraries(element.getElementsByTagName("library"));
        this.readStartupClasses(element.getElementsByTagName(WLS_STARTUP));
        this.readShutdownClasss(element.getElementsByTagName(WLS_SHUTDOWN));
        this.readJdbcSystemResources(element.getElementsByTagName(WLS_JDBC_SYS_RESOURCES));
        this.readWldfSystemResources(element.getElementsByTagName(WLS_WLDF_SYS_RESOURCES));
    }

    protected void readStartupClasses(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            StartupClass startupClass = new StartupClass();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!nodeList2.item(j).getNodeName().equals("name")) continue;
                startupClass.name = nodeList2.item(j).getTextContent();
                break;
            }
            this.template.allStartupClasses.put(startupClass.getName(), startupClass);
        }
    }

    protected void readShutdownClasss(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ShutdownClass shutdownClass = new ShutdownClass();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!nodeList2.item(j).getNodeName().equals("name")) continue;
                shutdownClass.name = nodeList2.item(j).getTextContent();
                break;
            }
            this.template.allShutdownClasses.put(shutdownClass.getName(), shutdownClass);
        }
    }

    protected void readJdbcSystemResources(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            JDBCSystemResource jDBCSystemResource = new JDBCSystemResource();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!nodeList2.item(j).getNodeName().equals("name")) continue;
                jDBCSystemResource.name = nodeList2.item(j).getTextContent();
                break;
            }
            this.template.allJdbcSystemResources.put(jDBCSystemResource.getName(), jDBCSystemResource);
        }
    }

    protected void readWldfSystemResources(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            WLDFSystemResource wLDFSystemResource = new WLDFSystemResource();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!nodeList2.item(j).getNodeName().equals("name")) continue;
                wLDFSystemResource.name = nodeList2.item(j).getTextContent();
                break;
            }
            this.template.allWldfSystemResources.put(wLDFSystemResource.getName(), wLDFSystemResource);
        }
    }

    @Override
    protected void processApplicationChildNode(Application application, String string, String string2) {
        if (string.equals("name")) {
            application.name = string2;
        } else if (string.equals(WLS_SOURCE_PATH)) {
            application.sourcePath = string2;
        }
    }

    @Override
    protected void processLibraryChildNode(Library library, String string, String string2) {
        if (string.equals("name")) {
            library.name = string2;
        } else if (string.equals(WLS_SOURCE_PATH)) {
            library.sourcePath = string2;
        }
    }

    @Override
    protected void processConfigGroupResource(String string, String string2, String string3) {
        if (string.equals(WLS_APPLICATION)) {
            this.template.applications.get(string3).add(this.template.allApplications.get(string2));
        } else if (string.equals(WLS_STARTUP)) {
            this.template.startupClasses.get(string3).add(this.template.allStartupClasses.get(string2));
        } else if (string.equals(WLS_SHUTDOWN)) {
            this.template.shutdownClasses.get(string3).add(this.template.allShutdownClasses.get(string2));
        } else if (string.equals(WLS_WLDF_SYS_RESOURCES)) {
            this.template.wldfSystemResources.get(string3).add(this.template.allWldfSystemResources.get(string2));
        } else if (string.equals(WLS_JDBC_SYS_RESOURCES)) {
            this.template.jdbcSystemResources.get(string3).add(this.template.allJdbcSystemResources.get(string2));
        } else {
            super.processConfigGroupResource(string, string2, string3);
        }
    }
}

