/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JRFService;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.was.WasJRFUtils;

public class WasJRFService
extends JRFService {
    protected static String CONFIG_GROUP_XML = "config-groups.xml";
    private static String ORACLE_JDBC_DRIVER_PATH = "ORACLE_JDBC_DRIVER_PATH";
    private static String OJDBC_JAR_NAME = "${COMMON_COMPONENTS_HOME}/modules/oracle.jdbc_11.1.1/ojdbc6.jar";
    protected static String NAME_TAG = "name";
    private static String CLASSPATH_TAG = "classPath";
    public static String DMGR_SERVER = "dmgr";
    public static String ORACLE_ADMIN_SERVER = "OracleAdminServer";
    private Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyJRF(String string) throws Exception {
        Session session = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        try {
            if (string.equals("*")) {
                this.applyToAllStandAloneServers(configService, session);
                this.applyToAllClusters(configService, session);
            } else {
                ObjectName objectName = this.getIdFromPath(configService, session, string);
                if (objectName.toString().indexOf("/clusters") != -1) {
                    this.applyJRFToCluster(configService, session, objectName);
                } else {
                    this.applyJRFToServer(configService, session, objectName);
                }
            }
            configService.save(session, false);
        }
        finally {
            configService.discard(session);
        }
    }

    @Override
    public boolean checkIfJRFApplied(String string) throws Exception {
        Session session = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = this.getIdFromPath(configService, session, string);
        if (WasJRFUtils.isDmgrServer(objectName)) {
            return this.verifyJrfDmgr(configService, session, objectName);
        }
        if (objectName.toString().indexOf("/clusters") != -1) {
            return this.verifyJrfCluster(configService, session, objectName);
        }
        if (this.verifyJrfServer(configService, session, objectName)) {
            return true;
        }
        String string2 = (String)configService.getAttribute(session, objectName, "clusterName");
        if (string2 != null && !string2.equals("")) {
            String string3 = WasJRFUtils.getCellNameFromId(objectName);
            ObjectName objectName2 = this.getIdFromPath(configService, session, "Cell=" + string3 + ":ServerCluster=" + string2);
            return this.verifyJrfCluster(configService, session, objectName2);
        }
        return false;
    }

    private boolean verifyJrfCluster(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        return this.verifyLibraries(configService, session, objectName);
    }

    private boolean verifyJrfServer(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (!this.verifyCustomServices(configService, session, objectName)) {
            return false;
        }
        return this.verifyLibraries(configService, session, objectName);
    }

    private boolean verifyJrfDmgr(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (!this.verifyCustomServices(configService, session, objectName)) {
            return false;
        }
        return this.verifyApplications(configService, session, objectName);
    }

    private boolean verifyCustomServices(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"CustomService", null);
        HashSet<String> hashSet = new HashSet<String>();
        for (ObjectName objectName3 : configService.queryConfigObjects(session, objectName, objectName2, null)) {
            hashSet.add((String)configService.getAttribute(session, objectName3, "displayName"));
        }
        for (StartupClass startupClass : WasJRFUtils.getJRFCustomServicesFromTemplate(objectName)) {
            if (hashSet.contains(startupClass.getName())) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"customService", startupClass.getName(), objectName.toString()}));
            return false;
        }
        return true;
    }

    private boolean verifyLibraries(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"Library", null);
        HashSet<String> hashSet = new HashSet<String>();
        for (ObjectName objectName3 : configService.queryConfigObjects(session, objectName, objectName2, null)) {
            hashSet.add(ConfigServiceHelper.getDisplayName((ObjectName)objectName3));
        }
        for (Library library : WasJRFUtils.getJRFLibrariesFromTemplate(objectName)) {
            if (hashSet.contains(library.getName())) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"library", library.getName(), objectName.toString()}));
            return false;
        }
        return true;
    }

    private boolean verifyApplications(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        String string = ConfigServiceHelper.getDisplayName((ObjectName)objectName);
        for (Application application : WasJRFUtils.getJRFApplicationsFromTemplate(objectName)) {
            boolean bl = false;
            ObjectName objectName2 = configService.resolve(session, "Deployment=" + application.getName())[0];
            for (ObjectName objectName3 : (List)configService.getAttribute(session, objectName2, "deploymentTargets", false)) {
                if (!string.equals(ConfigServiceHelper.getDisplayName((ObjectName)objectName3))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"application", application.getName(), objectName.toString()}));
            return false;
        }
        return true;
    }

    private void applyToAllStandAloneServers(ConfigService configService, Session session) throws Exception {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"Cell");
        for (ObjectName objectName2 : configService.queryConfigObjects(session, null, objectName, null)) {
            if (!this.isCellJrfEnabled(configService, session, objectName2)) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20025", new String[0]));
            }
            for (ObjectName objectName3 : this.getApplicationServerIds(configService, session, objectName2)) {
                String string = (String)configService.getAttribute(session, objectName3, "clusterName");
                if (string != null && !string.equals("")) continue;
                this.applyJRFToServer(configService, session, objectName3);
            }
        }
    }

    private void applyToAllClusters(ConfigService configService, Session session) throws Exception {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"ServerCluster");
        for (ObjectName objectName2 : configService.queryConfigObjects(session, null, objectName, null)) {
            this.applyJRFToCluster(configService, session, objectName2);
        }
    }

    private void applyJRFToServer(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        Object object;
        String string = WasJRFUtils.getCellNameFromId(objectName);
        ObjectName objectName2 = this.getIdFromPath(configService, session, "Cell=" + string);
        String string2 = WasJRFUtils.getNodeNameFromId(objectName);
        String string3 = ConfigServiceHelper.getDisplayName((ObjectName)objectName);
        String string4 = (String)configService.getAttribute(session, objectName, "clusterName");
        if (string4 != null && !string4.equals("")) {
            object = this.getIdFromPath(configService, session, "Cell=" + string + ":ServerCluster=" + string4);
            this.applyJRFToCluster(configService, session, (ObjectName)object);
        }
        if (this.isServerJrfEnabled(configService, session, objectName, (List<StartupClass>)(object = WasJRFUtils.getJRFCustomServicesFromTemplate(objectName)))) {
            return;
        }
        List<Library> list = WasJRFUtils.getJRFLibrariesFromTemplate(objectName);
        this.createLibraries(configService, session, objectName2, objectName, list);
        this.createCustomService(configService, session, objectName, (List<StartupClass>)object);
        this.setJvmMemArgs(configService, session, string3);
        this.setJvmSystemProperty(configService, session, string3);
        this.createUrlProvider(configService, session, objectName);
        this.createJDBCDriver(configService, session, string2);
        this.enableStartupBeansService(configService, session, string3);
        this.deployApplication(configService, session, objectName, string, objectName2, "", string2, string3);
        this.copyServerConfigFiles(configService, session, string, string2, string3);
    }

    private void applyJRFToCluster(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        Object[] objectArray;
        String string = ConfigServiceHelper.getDisplayName((ObjectName)objectName);
        String string2 = WasJRFUtils.getCellNameFromClusterId(objectName);
        ObjectName objectName2 = this.getIdFromPath(configService, session, "Cell=" + string2);
        List<Library> list = WasJRFUtils.getJRFLibrariesFromTemplate(objectName);
        boolean bl = this.isClusterJrfEnabled(configService, session, string2, objectName, list);
        if (!bl) {
            this.createLibraries(configService, session, objectName2, objectName, list);
            this.deployApplication(configService, session, objectName, string2, objectName2, string, "", "");
        }
        ArrayList arrayList = this.getAllServersOfACluster(configService, session, string, string2);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            List<StartupClass> object;
            ObjectName objectName3 = (ObjectName)arrayList.get(i);
            if (this.isServerJrfEnabled(configService, session, objectName3, object = WasJRFUtils.getJRFCustomServicesFromTemplate(objectName3))) continue;
            this.createCustomService(configService, session, objectName3, object);
            String string3 = ConfigServiceHelper.getDisplayName((ObjectName)objectName3);
            this.setJvmMemArgs(configService, session, string3);
            this.setJvmSystemProperty(configService, session, string3);
            this.createUrlProvider(configService, session, objectName3);
            this.enableStartupBeansService(configService, session, string3);
            String string4 = WasJRFUtils.getNodeNameFromId(objectName3);
            this.copyServerConfigFiles(configService, session, string2, string4, string3);
            hashSet.add(string4);
        }
        for (Object object : objectArray = hashSet.toArray()) {
            this.createJDBCDriver(configService, session, (String)object);
        }
    }

    private boolean isCellJrfEnabled(ConfigService configService, Session session, ObjectName objectName) throws PortabilityLayerException {
        String string = this.getVariable(configService, session, objectName, "COMMON_COMPONENTS_HOME");
        return string != null && !string.equals("");
    }

    private boolean isNodeJrfEnabled(ConfigService configService, Session session, ObjectName objectName) throws PortabilityLayerException {
        String string = this.getVariable(configService, session, objectName, ORACLE_JDBC_DRIVER_PATH);
        return string != null && string.indexOf("modules/oracle.jdbc_11.1.1/ojdbc6.jar") != -1;
    }

    private ArrayList<ObjectName> getApplicationServerIds(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"Server");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        for (ObjectName objectName3 : objectNameArray) {
            String string = (String)configService.getAttribute(session, objectName3, "serverType");
            if (string == null || !string.equals("APPLICATION_SERVER")) continue;
            arrayList.add(objectName3);
        }
        return arrayList;
    }

    private String getJvmArg() throws PortabilityLayerException {
        boolean bl = System.getProperty("sun.arch.data.model").equals("64");
        for (EnvConfig envConfig : WasJRFUtils.getJRFEnvConfigsFromTemplate()) {
            if (envConfig.getInitialHeapSize32() == null) continue;
            return envConfig.getMemoryArgsAsString(bl);
        }
        return "";
    }

    private void createLibraries(ConfigService configService, Session session, ObjectName objectName, ObjectName objectName2, List<Library> list) throws PortabilityLayerException {
        AttributeList attributeList = new AttributeList();
        for (Library library : list) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)NAME_TAG, (Object)library.getName());
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.convertSrcPath(configService, session, objectName, library.getSourcePath()));
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)CLASSPATH_TAG, arrayList);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"isolatedClassLoader", (Object)new Boolean(library.getIsolatedClassLoader()));
            try {
                configService.createConfigData(session, objectName2, "Library", "Library", attributeList);
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20014", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)objectName2)}), exception);
            }
        }
    }

    private void deployApplication(ConfigService configService, Session session, ObjectName objectName, String string, ObjectName objectName2, String string2, String string3, String string4) throws Exception {
        List<Application> list = WasJRFUtils.getJRFApplicationsFromTemplate(objectName);
        AppManagement appManagement = AppManagementProxy.getJMXProxyForServer();
        if (string2 != null && !string2.equals("")) {
            String string5 = "WebSphere:cell=" + string + ",cluster=" + string2;
            for (Application application : list) {
                this.editApplication(appManagement, application, string5);
            }
        } else {
            String string6 = "WebSphere:cell=" + string + ",node=" + string3 + ",server=" + string4;
            for (Application application : list) {
                if (!this.isApplicationDeployed(appManagement, application.getName())) {
                    this.installApplication(configService, session, appManagement, application, string6, objectName2);
                    continue;
                }
                this.editApplication(appManagement, application, string6);
            }
        }
    }

    private boolean isApplicationDeployed(AppManagement appManagement, String string) throws Exception {
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", Locale.getDefault());
        Vector vector = appManagement.listApplications(hashtable, null);
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void createCustomService(ConfigService configService, Session session, ObjectName objectName, List<StartupClass> list) throws PortabilityLayerException {
        for (StartupClass startupClass : list) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"classname", (Object)startupClass.getClassName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"enable", (Object)new Boolean(startupClass.getEnable()));
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"classpath", (Object)startupClass.getClassPath());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"displayName", (Object)startupClass.getName());
            try {
                configService.createConfigData(session, objectName, "customServices", "CustomService", attributeList);
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20015", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)objectName)}), exception);
            }
        }
    }

    private void createUrlProvider(ConfigService configService, Session session, ObjectName objectName) throws PortabilityLayerException {
        for (URLProvider uRLProvider : WasJRFUtils.getJRFUrlProvidersFromTemplate(objectName)) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"streamHandlerClassName", (Object)uRLProvider.getStreamHandlerClassName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)uRLProvider.getName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)"");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"protocol", (Object)uRLProvider.getProtocol());
            try {
                configService.createConfigData(session, objectName, "URLProvider", "URLProvider", attributeList);
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20016", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)objectName)}), exception);
            }
        }
    }

    private void enableStartupBeansService(ConfigService configService, Session session, String string) throws PortabilityLayerException {
        ObjectName objectName = this.getIdFromPath(configService, session, "Server=" + string + ":PMEServerExtension=:StartupBeansService=:");
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("enable", new Boolean("true")));
        try {
            configService.setAttributes(session, objectName, attributeList);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20030", new String[]{string}), exception);
        }
    }

    private void setJvmMemArgs(ConfigService configService, Session session, String string) throws PortabilityLayerException {
        ObjectName objectName = this.getIdFromPath(configService, session, "Server=" + string + ":JavaProcessDef=:JavaVirtualMachine=");
        String string2 = this.getJvmArg();
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("genericJvmArguments", string2));
        try {
            configService.setAttributes(session, objectName, attributeList);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20017", new String[]{string}), exception);
        }
    }

    private void setJvmSystemProperty(ConfigService configService, Session session, String string) throws PortabilityLayerException {
        ObjectName objectName = this.getIdFromPath(configService, session, "Server=" + string + ":JavaProcessDef=:JavaVirtualMachine=");
        for (EnvConfig envConfig : WasJRFUtils.getJRFEnvConfigsFromTemplate()) {
            for (Map.Entry<Object, Object> entry : envConfig.getProperties().entrySet()) {
                AttributeList attributeList = new AttributeList();
                attributeList.add(new Attribute("name", entry.getKey()));
                attributeList.add(new Attribute("value", entry.getValue()));
                try {
                    configService.addElement(session, objectName, "systemProperties", (Object)attributeList, -1);
                }
                catch (Exception exception) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20018", new String[]{string}), exception);
                }
            }
        }
    }

    private boolean isClusterJrfEnabled(ConfigService configService, Session session, String string, ObjectName objectName, List<Library> list) throws Exception {
        if (!list.isEmpty()) {
            String string2 = list.get(0).getName();
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"Library");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            if (objectNameArray != null && objectNameArray.length != 0) {
                for (ObjectName objectName3 : objectNameArray) {
                    String string3 = (String)configService.getAttribute(session, objectName3, "name");
                    if (!string3.equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void createJDBCDriver(ConfigService configService, Session session, String string) throws PortabilityLayerException {
        ObjectName objectName = this.getIdFromPath(configService, session, "Node=" + string);
        if (this.isNodeJrfEnabled(configService, session, objectName)) {
            return;
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"VariableSubstitutionEntry");
        try {
            ObjectName[] objectNameArray;
            for (ObjectName objectName3 : objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null)) {
                String string2 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                if (!string2.equals(ORACLE_JDBC_DRIVER_PATH)) continue;
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"symbolicName", (Object)ORACLE_JDBC_DRIVER_PATH);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)OJDBC_JAR_NAME);
                configService.setAttributes(session, objectName3, attributeList);
                break;
            }
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20022", new String[]{ORACLE_JDBC_DRIVER_PATH}), exception);
        }
    }

    private boolean isServerJrfEnabled(ConfigService configService, Session session, ObjectName objectName, List<StartupClass> list) throws Exception {
        boolean bl = false;
        if (!list.isEmpty()) {
            String string = list.get(0).getName();
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"CustomService");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            if (objectNameArray != null && objectNameArray.length != 0) {
                for (ObjectName objectName3 : objectNameArray) {
                    String string2 = (String)configService.getAttribute(session, objectName3, "displayName");
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private ArrayList getAllServersOfACluster(ConfigService configService, Session session, String string, String string2) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName objectName = this.getIdFromPath(configService, session, "Cell=" + string2);
        ArrayList<ObjectName> arrayList2 = this.getApplicationServerIds(configService, session, objectName);
        String string3 = "";
        for (int i = 0; i < arrayList2.size(); ++i) {
            ObjectName objectName2 = arrayList2.get(i);
            try {
                string3 = (String)configService.getAttribute(session, objectName2, "clusterName");
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(exception);
            }
            if (string3 == null || !string3.equals(string)) continue;
            arrayList.add(objectName2);
        }
        return arrayList;
    }

    private void installApplication(ConfigService configService, Session session, AppManagement appManagement, Application application, String string, ObjectName objectName) throws PortabilityLayerException {
        Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
        hashtable.put("app.client.locale", Locale.getDefault());
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("*", string);
        hashtable.put("moduleToServer", hashtable2);
        try {
            appManagement.installApplication(this.convertSrcPath(configService, session, objectName, application.getSourcePath()), application.getName(), hashtable, null);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20023", new String[]{application.getName()}), exception);
        }
    }

    private void editApplication(AppManagement appManagement, Application application, String string) throws PortabilityLayerException {
        if (JRFTemplateHelper.getJRFTemplateForWAS().getApplications("JRF-DMGR-APPS").contains(application)) {
            return;
        }
        if (JRFTemplateHelper.getJRFTemplateForWAS().getApplications("JRF-DMGR-APPS").contains(application) && !string.equals(ORACLE_ADMIN_SERVER)) {
            return;
        }
        try {
            Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
            hashtable.put("app.client.locale", Locale.getDefault());
            Vector vector = appManagement.getApplicationInfo(application.getName(), hashtable, null);
            for (int i = 0; i < vector.size(); ++i) {
                int n;
                String[] stringArray;
                AppDeploymentTask appDeploymentTask = (AppDeploymentTask)vector.get(i);
                if (!appDeploymentTask.getName().equals("MapModulesToServers")) continue;
                if (appDeploymentTask.isTaskDisabled()) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20029", new String[]{application.getName()}));
                }
                int n2 = -1;
                String[] stringArray2 = stringArray = appDeploymentTask.getColumnNames();
                int n3 = stringArray2.length;
                for (n = 0; n < n3; ++n) {
                    String string2 = stringArray2[n];
                    if (!string2.trim().equals("server")) continue;
                    n2 = i;
                    break;
                }
                String[] stringArray3 = stringArray2 = appDeploymentTask.getTaskData();
                n = stringArray3.length;
                for (int j = 0; j < n; ++j) {
                    String string3 = stringArray3[j];
                    if (string3[n2].trim().equals("server")) continue;
                    String string4 = string3;
                    int n4 = n2;
                    string4[n4] = string4[n4] + "+" + string;
                }
                appDeploymentTask.setTaskData((String[][])stringArray2);
            }
            hashtable = new Hashtable();
            hashtable.put("app.client.locale", Locale.getDefault());
            appManagement.setApplicationInfo(application.getName(), hashtable, null, vector);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20021", new String[]{application.getName()}), exception);
        }
    }

    private File getServerConfigDir(ConfigService configService, Session session, String string, String string2, String string3) throws PortabilityLayerException {
        String string4 = "Cell=" + string + ":Node=" + string2;
        ObjectName objectName = this.getIdFromPath(configService, session, string4);
        String string5 = this.getVariable(configService, session, objectName, "USER_INSTALL_ROOT");
        return new File(string5 + "/config/cells/" + string + "/nodes/" + string2 + "/servers/" + string3 + "/fmwconfig");
    }

    private String getVariable(ConfigService configService, Session session, ObjectName objectName, String string) throws PortabilityLayerException {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"VariableMap");
        String string2 = "";
        try {
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectNameArray[0], "entries");
            String string3 = "";
            AttributeList attributeList = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                attributeList = (AttributeList)arrayList.get(i);
                string3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"symbolicName");
                if (!string3.equals(string)) continue;
                string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"value");
                break;
            }
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20020", new String[]{string, ConfigServiceHelper.getDisplayName((ObjectName)objectName)}));
        }
        return string2;
    }

    private ObjectName getIdFromPath(ConfigService configService, Session session, String string) throws PortabilityLayerException {
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = configService.resolve(session, string);
        }
        catch (Exception exception) {
            new PortabilityLayerException(exception);
        }
        if (objectNameArray == null || objectNameArray.length == 0) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{string}));
        }
        return objectNameArray[0];
    }

    private void copyServerConfigFiles(ConfigService configService, Session session, String string, String string2, String string3) throws PortabilityLayerException {
        File file = this.getServerConfigDir(configService, session, string, string2, string3);
        File file2 = new File(JrfUtils.getCommonComponentsHome());
        File file3 = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        try {
            InternalJrfUtils.copyServerConfigTemplateToServerDir(file3, file2, file);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    private String convertSrcPath(ConfigService configService, Session session, ObjectName objectName, String string) throws PortabilityLayerException {
        String string2 = string.replaceAll("\\$ORACLE_HOME\\$", this.getVariable(configService, session, objectName, "ORACLE_HOME"));
        string2 = string2.replaceAll("\\$COMMON_COMPONENTS_HOME\\$", this.getVariable(configService, session, objectName, "COMMON_COMPONENTS_HOME"));
        return string2;
    }
}

