/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.NamedResource;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.was.WasJRFService;

public class WasJRFUtils {
    public static boolean isDmgrServer(ObjectName objectName) {
        if (objectName.toString().indexOf("/clusters") != -1) {
            return false;
        }
        return ConfigServiceHelper.getDisplayName((ObjectName)objectName).equals(WasJRFService.DMGR_SERVER);
    }

    public static boolean isOracleAdminServer(ObjectName objectName) {
        if (objectName.toString().indexOf("/clusters") != -1) {
            return false;
        }
        return ConfigServiceHelper.getDisplayName((ObjectName)objectName).equals(WasJRFService.ORACLE_ADMIN_SERVER);
    }

    public static String getCellNameFromId(ObjectName objectName) {
        String string = objectName.toString();
        int n = string.indexOf("cells/");
        int n2 = string.indexOf("/nodes");
        return string.substring(n + "cells/".length(), n2);
    }

    public static String getNodeNameFromId(ObjectName objectName) {
        String string = objectName.toString();
        int n = string.indexOf("nodes/");
        int n2 = string.indexOf("/servers");
        return string.substring(n + "nodes/".length(), n2);
    }

    public static String getCellNameFromClusterId(ObjectName objectName) {
        String string = objectName.toString();
        int n = string.indexOf("cells/");
        int n2 = string.indexOf("/clusters");
        return string.substring(n + "cells/".length(), n2);
    }

    public static List<Library> getJRFLibrariesFromTemplate(ObjectName objectName) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(objectName, "library");
    }

    public static List<Application> getJRFApplicationsFromTemplate(ObjectName objectName) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(objectName, "app-deployment");
    }

    public static List<StartupClass> getJRFCustomServicesFromTemplate(ObjectName objectName) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(objectName, "custom-service");
    }

    public static List<URLProvider> getJRFUrlProvidersFromTemplate(ObjectName objectName) throws PortabilityLayerException {
        return WasJRFUtils.getJRFResourcesFromTemplate(objectName, "url-provider");
    }

    public static List<EnvConfig> getJRFEnvConfigsFromTemplate() throws PortabilityLayerException {
        Template template = JRFTemplateHelper.getJRFTemplateForWAS();
        ArrayList<EnvConfig> arrayList = new ArrayList<EnvConfig>();
        arrayList.addAll(template.getEnvConfigs().values());
        for (Template template2 : template.getSubTemplates()) {
            arrayList.addAll(template2.getEnvConfigs().values());
        }
        return arrayList;
    }

    private static List<? extends NamedResource> getJRFResourcesFromTemplate(ObjectName objectName, String string) throws PortabilityLayerException {
        if (WasJRFUtils.isDmgrServer(objectName)) {
            return JRFTemplateHelper.getJRFDmgrResourcesFromTemplate(string, JRFTemplateHelper.getJRFTemplateForWAS());
        }
        if (WasJRFUtils.isOracleAdminServer(objectName)) {
            return JRFTemplateHelper.getJRFAdminResourcesFromTemplate(string, JRFTemplateHelper.getJRFTemplateForWAS());
        }
        return JRFTemplateHelper.getJRFManagedResourcesFromTemplate(string, JRFTemplateHelper.getJRFTemplateForWAS());
    }
}

