/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import oracle.jrf.JRFInternalPlatform;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.was.WasPortConfig;
import oracle.jrf.was.WasServerPlatformSupport;

public class WasNDJrfInternalPlatform
extends WasServerPlatformSupport
implements JRFInternalPlatform {
    private String clusterName;

    @Override
    public boolean isWebSphereND() {
        return true;
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        if (this.adminServerName == null) {
            this.adminServerName = System.getProperty(ORACLE_ADMIN_SERVER_NAME);
            if (this.adminServerName == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10002"));
            }
        }
        return this.adminServerName;
    }

    @Override
    public boolean isTargeted(String[] stringArray) throws PortabilityLayerException {
        boolean bl = this.isDeploymentManagerServer();
        boolean bl2 = !bl && !this.isAdminServer();
        for (String string : stringArray) {
            if (!("%ALLManagedServers%".equals(string) && bl2 || "%AdminServer%".equals(string) && this.isAdminServer()) && (!"%DmgrServer%".equals(string) || !bl)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeploymentManagerServer() throws PortabilityLayerException {
        return "dmgr".equals(this.getServerName());
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        if (this.clusterName == null) {
            this.clusterName = WasPortConfig.internalGetClusterName();
        }
        return this.clusterName;
    }

    @Override
    protected PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new WasPortConfig(true);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    @Override
    public PortConfig getPortConfig(String string) throws PortabilityLayerException {
        String[] stringArray = string.split("\\/");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (String string5 : stringArray) {
            if (string5.startsWith("Cell:")) {
                string2 = string5.substring(5);
            }
            if (string5.startsWith("Node:")) {
                string3 = string5.substring(5);
            }
            if (!string5.startsWith("Server:")) continue;
            string4 = string5.substring(7);
        }
        if (string2 == null || string3 == null || string4 == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{string}));
        }
        WasPortConfig wasPortConfig = (WasPortConfig)this.getPortConfig();
        if (string2.equals(wasPortConfig.getCellName()) && string3.equals(wasPortConfig.getlNodeName()) && string4.equals(wasPortConfig.getSeverName())) {
            return wasPortConfig;
        }
        try {
            return new WasPortConfig(string2, string3, string4, true);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }
}

