/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class WasPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private String localCellName;
    private String localNodeName;
    private String localSeverName;
    private String localClusterName;
    private boolean isNDEdition;
    private transient ServerConfig runningServer;
    private static final String ENDPOINT_JNDI = "BOOTSTRAP_ADDRESS";

    protected WasPortConfig(boolean bl) throws Exception {
        this.isNDEdition = bl;
        this.initRunningServerConfig();
        this.localCellName = this.runningServer.cellName;
        this.localNodeName = this.runningServer.nodeName;
        this.localSeverName = this.runningServer.name;
        this.localClusterName = this.runningServer.clusterName;
        this.parseXmls(this.runningServer);
        this.parsePortConfigPropertiesFile(this.getUserPropertiesFile());
    }

    protected WasPortConfig(String string, String string2, String string3, boolean bl) throws Exception {
        this.isNDEdition = bl;
        this.localCellName = string;
        this.localNodeName = string2;
        this.localSeverName = string3;
        this.initRunningServerConfig();
        ServerConfig serverConfig = new ServerConfig(this.localSeverName, this.localNodeName, this.localCellName);
        this.localClusterName = serverConfig.clusterName;
        this.parseXmls(serverConfig);
        this.parsePortConfigPropertiesFile(this.getUserPropertiesFile());
    }

    private void initRunningServerConfig() throws Exception {
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = adminService.getLocalServer();
        String string = ObjectNameHelper.getCellName((ObjectName)objectName);
        String string2 = ObjectNameHelper.getNodeName((ObjectName)objectName);
        String string3 = ServerPlatformSupportFactory.getInstance().getServerName();
        this.runningServer = new ServerConfig(string3, string2, string);
    }

    protected static String internalGetClusterName() throws PortabilityLayerException {
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = adminService.getLocalServer();
        String string = ObjectNameHelper.getCellName((ObjectName)objectName);
        String string2 = ObjectNameHelper.getNodeName((ObjectName)objectName);
        String string3 = ServerPlatformSupportFactory.getInstance().getServerName();
        try {
            return new ServerConfig((String)string3, (String)string2, (String)string).clusterName;
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "corbaloc:iiop", "iiop"};
    }

    @Override
    public boolean isClustered() {
        return this.isNDEdition && this.localClusterName != null;
    }

    private static Element getXmlDom(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        return documentBuilderFactory.newDocumentBuilder().parse(file).getDocumentElement();
    }

    private void parseXmls(ServerConfig serverConfig) throws Exception {
        if (serverConfig.clusterName != null) {
            ClusterConfig clusterConfig = new ClusterConfig(serverConfig.clusterName, serverConfig.cellName, serverConfig);
            HashMap<String, ServerEntryNodeConfig> hashMap = new HashMap<String, ServerEntryNodeConfig>();
            for (ServerConfig serverConfig2 : clusterConfig.members) {
                ServerEntryNodeConfig serverEntryNodeConfig = (ServerEntryNodeConfig)hashMap.get(serverConfig2.nodeName);
                if (serverEntryNodeConfig == null) {
                    serverEntryNodeConfig = new ServerEntryNodeConfig(serverConfig2.nodeName);
                    hashMap.put(serverConfig2.nodeName, serverEntryNodeConfig);
                }
                this.initWebPortsFromXml(serverConfig2, serverEntryNodeConfig);
                this.initJndiPortsFromXml(serverConfig2, serverEntryNodeConfig);
            }
        } else {
            ServerEntryNodeConfig serverEntryNodeConfig = new ServerEntryNodeConfig(this.localNodeName);
            this.initWebPortsFromXml(serverConfig, serverEntryNodeConfig);
            this.initJndiPortsFromXml(serverConfig, serverEntryNodeConfig);
        }
    }

    private void initJndiPortsFromXml(ServerConfig serverConfig, ServerEntryNodeConfig serverEntryNodeConfig) throws UnknownHostException {
        Map<String, EndpointConfig> map = serverEntryNodeConfig.endpoints.get(serverConfig.name);
        EndpointConfig endpointConfig = map.get(ENDPOINT_JNDI);
        boolean bl = this.localSeverName.equals(serverConfig.name) && this.localNodeName.equals(serverConfig.nodeName);
        this.addPort(bl, "corbaloc:iiop", endpointConfig);
        if (bl) {
            this.addServerPort(new Port("iiop", endpointConfig.host, endpointConfig.port, this));
        }
    }

    private void initWebPortsFromXml(ServerConfig serverConfig, ServerEntryNodeConfig serverEntryNodeConfig) throws Exception {
        boolean bl = this.localSeverName.equals(serverConfig.name) && this.localNodeName.equals(serverConfig.nodeName);
        boolean bl2 = this.runningServer.name.equals(serverConfig.name) && this.runningServer.nodeName.equals(serverConfig.nodeName);
        Map<String, EndpointConfig> map = serverEntryNodeConfig.endpoints.get(serverConfig.name);
        boolean bl3 = "dmgr".equals(serverConfig.name);
        String string = bl3 ? serverConfig.adminHttpEndPointName : serverConfig.defaultHttpEndPointName;
        EndpointConfig endpointConfig = null;
        if (string != null) {
            endpointConfig = map.get(string);
        }
        this.addPort(bl, "http", endpointConfig);
        String string2 = bl3 ? serverConfig.adminHttpSslEndPointName : serverConfig.defaultHttpSslEndPointName;
        endpointConfig = null;
        if (string2 != null) {
            endpointConfig = map.get(string2);
        }
        this.addPort(bl, "https", endpointConfig);
    }

    private Port getPortFromDmgr(String string, String string2, String string3, String string4) throws Exception {
        AdminClient adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
        Set set = adminClient.queryNames(new ObjectName("oracle.jrf:name=JRFService,*"), null);
        ObjectName objectName = (ObjectName)set.iterator().next();
        String string5 = "/Cell:" + string + "/Node:" + string2 + "/Server:" + string3;
        Object object = adminClient.invoke(objectName, "getServerURL", new Object[]{string5, string4}, new String[]{"java.lang.String", "java.lang.String"});
        return object == null ? null : new Port((String)object, this);
    }

    private void addPort(boolean bl, String string, EndpointConfig endpointConfig) throws UnknownHostException {
        if (endpointConfig != null) {
            Port port = new Port(string, endpointConfig.host, endpointConfig.port, this);
            if (bl) {
                this.addServerPort(port);
            }
            if (this.isClustered()) {
                this.addClusterMemberPort(port);
            }
        }
    }

    private static File getCellConfigDir() throws Exception {
        String string = ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory();
        return new File(string, "../");
    }

    private static File getServerIndex(String string) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + string + "/serverindex.xml");
    }

    private static File getServerXml(String string, String string2) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + string + "/servers/" + string2 + "/server.xml");
    }

    private static File getClusterXml(String string) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "clusters/" + string + "/cluster.xml");
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"corbaloc:iiop", "iiop"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return this.getDefaultJndiProtocols();
    }

    @Override
    public String getJndiSslProviderURL() {
        return this.getJndiProviderURL();
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener notificationListener) throws PortabilityLayerException {
        try {
            MBeanServer mBeanServer = new PortableMBeanFactory().getPrivilegedMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("WebSphere:type=ConfigRepository,name=repository,cell=" + this.localCellName + ",node=" + this.localNodeName + ",process=" + this.localSeverName + ",*"), null);
            ObjectName objectName = set.iterator().next();
            mBeanServer.addNotificationListener(objectName, notificationListener, (NotificationFilter)new RepositoryChangeListenerFilter(), null);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    protected String getClusterName() {
        return this.localClusterName;
    }

    protected String getCellName() {
        return this.localCellName;
    }

    protected String getlNodeName() {
        return this.localNodeName;
    }

    protected String getSeverName() {
        return this.localSeverName;
    }

    @Override
    protected String getClusterJNDISeparator() {
        return ",:";
    }

    protected File getUserPropertiesFile() throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + this.localNodeName + "/servers/" + this.localSeverName + "/fmwconfig/" + "jrf-port-config.properties");
    }

    private static class TransPortChannel {
        private String id;
        private String endPointName;
        List<TransPortChain> chains;
        boolean isEnable;
        boolean isSSL;
        boolean isDefaultHttp;
        boolean isAdminHttp;

        TransPortChannel(String string, String string2, List<TransPortChain> list) {
            this.id = string;
            this.endPointName = string2;
            this.chains = list;
            this.init();
        }

        private void init() {
            this.isDefaultHttp = false;
            for (TransPortChain transPortChain : this.chains) {
                if (!transPortChain.channels.contains("HTTP") || !transPortChain.name.contains("WCInboundDefault")) continue;
                this.isDefaultHttp = true;
                break;
            }
            this.isAdminHttp = false;
            for (TransPortChain transPortChain : this.chains) {
                if (!transPortChain.channels.contains("HTTP") || !transPortChain.name.contains("WCInboundAdmin")) continue;
                this.isAdminHttp = true;
                break;
            }
            this.isEnable = this.chains.size() > 0;
            for (TransPortChain transPortChain : this.chains) {
                if (transPortChain.isEnable()) continue;
                this.isEnable = false;
                break;
            }
            this.isSSL = this.chains.size() > 0;
            for (TransPortChain transPortChain : this.chains) {
                if (transPortChain.isSSL()) continue;
                this.isSSL = false;
                break;
            }
        }
    }

    private static class TransPortChain {
        String name;
        String enable;
        String channels;

        TransPortChain(String string, String string2, String string3) {
            this.channels = string3;
            this.enable = string2;
            this.name = string;
        }

        public boolean isSSL() {
            return this.channels.contains("SSL");
        }

        public boolean isEnable() {
            return "true".equals(this.enable);
        }
    }

    private static class RepositoryChangeListenerFilter
    implements NotificationFilter {
        private static final long serialVersionUID = 1L;

        private RepositoryChangeListenerFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return "websphere.repository.change".equals(notification.getType());
        }
    }

    private static class ServerConfig {
        protected String name;
        protected String nodeName;
        protected String cellName;
        protected String clusterName;
        protected String adminHttpEndPointName;
        protected String adminHttpSslEndPointName;
        protected String defaultHttpEndPointName;
        protected String defaultHttpSslEndPointName;

        ServerConfig(String string, String string2, String string3) throws Exception {
            this.name = string;
            this.nodeName = string2;
            this.cellName = string3;
            this.parseConfig(WasPortConfig.getServerXml(string2, string));
        }

        ServerConfig(String string, String string2, String string3, String string4) throws Exception {
            this.name = string;
            this.nodeName = string2;
            this.cellName = string3;
            this.clusterName = string4;
            this.parseConfig(WasPortConfig.getServerXml(string2, string));
        }

        private void parseConfig(File file) throws Exception {
            if (!file.exists()) {
                return;
            }
            Element element = WasPortConfig.getXmlDom(file);
            String string = element.getAttribute("clusterName").trim();
            if (string != null && !string.isEmpty()) {
                this.clusterName = string;
            }
            this.parseTransPortChannels(element);
        }

        private void parseTransPortChannels(Element element) throws Exception {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Server/services[@type='channelservice:TransportChannelService' and @enable='true']/transportChannels[@endPointName]";
            XPathExpression xPathExpression = xPath.compile(string);
            Object object = xPathExpression.evaluate(element, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("endPointName");
                String string3 = element2.getAttribute("xmi:id");
                List<TransPortChain> list = this.getTransPortChains(element2.getParentNode(), string3);
                TransPortChannel transPortChannel = new TransPortChannel(string3, string2, list);
                if (!transPortChannel.isEnable) continue;
                if (transPortChannel.isSSL) {
                    if (transPortChannel.isAdminHttp) {
                        this.adminHttpSslEndPointName = transPortChannel.endPointName;
                        continue;
                    }
                    if (!transPortChannel.isDefaultHttp) continue;
                    this.defaultHttpSslEndPointName = transPortChannel.endPointName;
                    continue;
                }
                if (transPortChannel.isAdminHttp) {
                    this.adminHttpEndPointName = transPortChannel.endPointName;
                    continue;
                }
                if (!transPortChannel.isDefaultHttp) continue;
                this.defaultHttpEndPointName = transPortChannel.endPointName;
            }
        }

        private List<TransPortChain> getTransPortChains(Node node, String string) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
            ArrayList<TransPortChain> arrayList = new ArrayList<TransPortChain>();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "chains[contains(@transportChannels, '" + string + "')]";
            XPathExpression xPathExpression = xPath.compile(string2);
            Object object = xPathExpression.evaluate(node, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getAttribute("transportChannels");
                String string4 = element.getAttribute("enable");
                String string5 = element.getAttribute("name");
                TransPortChain transPortChain = new TransPortChain(string5, string4, string3);
                arrayList.add(transPortChain);
            }
            return arrayList;
        }

        public String toString() {
            return "ServerConfig [name=" + this.name + ", cellName=" + this.cellName + ", nodeName=" + this.nodeName + ", clusterName=" + this.clusterName + "]";
        }
    }

    private static class ClusterConfig {
        protected String name;
        protected String cellName;
        List<ServerConfig> members;
        ServerConfig localServerMember;

        ClusterConfig(String string, String string2, ServerConfig serverConfig) throws Exception {
            this.name = string;
            this.cellName = string2;
            this.members = new ArrayList<ServerConfig>();
            this.localServerMember = serverConfig;
            this.members.add(serverConfig);
            this.parseConfig(WasPortConfig.getClusterXml(string));
        }

        private void parseConfig(File file) throws Exception {
            Element element = WasPortConfig.getXmlDom(file);
            NodeList nodeList = element.getElementsByTagName("members");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string = element2.getAttribute("memberName").trim();
                    String string2 = element2.getAttribute("nodeName").trim();
                    if (string.equals(this.localServerMember.name) && string2.equals(this.localServerMember.nodeName)) continue;
                    this.members.add(new ServerConfig(string, string2, this.cellName, this.name));
                }
            }
        }

        public String toString() {
            return "ClusterConfig [name=" + this.name + ", cellName=" + this.cellName + ", members=" + this.members + "]";
        }
    }

    private static class ServerEntryNodeConfig {
        protected String host;
        protected String nodeName;
        protected Map<String, Map<String, EndpointConfig>> endpoints;

        ServerEntryNodeConfig(String string) throws Exception {
            this.nodeName = string;
            this.endpoints = new HashMap<String, Map<String, EndpointConfig>>();
            this.parseConfig(WasPortConfig.getServerIndex(string));
        }

        private void parseConfig(File file) throws Exception {
            Element element = WasPortConfig.getXmlDom(file);
            this.host = element.getAttribute("hostName").trim();
            NodeList nodeList = element.getElementsByTagName("serverEntries");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string = element2.getAttribute("serverName").trim();
                    HashMap<String, EndpointConfig> hashMap = new HashMap<String, EndpointConfig>();
                    NodeList nodeList2 = element2.getElementsByTagName("specialEndpoints");
                    if (nodeList2 != null) {
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Element element3 = (Element)nodeList2.item(j);
                            String string2 = element3.getAttribute("endPointName").trim();
                            NodeList nodeList3 = element3.getElementsByTagName("endPoint");
                            if (nodeList3 == null) continue;
                            Element element4 = (Element)nodeList3.item(0);
                            String string3 = element4.getAttribute("host").trim();
                            if (string3.indexOf("*") >= 0) {
                                string3 = this.host;
                            }
                            String string4 = element4.getAttribute("port").trim();
                            hashMap.put(string2, new EndpointConfig(string2, string3, string4, this.nodeName, string));
                        }
                    }
                    this.endpoints.put(string, hashMap);
                }
            }
        }

        public String toString() {
            return "NodeServerEntryConfig [nodeName=" + this.nodeName + ", host=" + this.host + ", endpoints=" + this.endpoints + "]";
        }
    }

    private static class EndpointConfig {
        protected String name;
        protected String host;
        protected String serverName;
        protected String nodeName;
        protected int port;

        private EndpointConfig(String string, String string2, String string3, String string4, String string5) throws UnknownHostException {
            this.name = string;
            this.host = string2;
            if (string2.indexOf("${LOCALHOST") >= 0) {
                this.host = "localhost";
            }
            this.port = string3 == null ? -1 : Integer.valueOf(string3);
            this.nodeName = string4;
            this.serverName = string5;
        }

        public String toString() {
            return "EndpointConfig [name=" + this.name + ", host=" + this.host + ", port=" + this.port + ", serverName=" + this.serverName + ", nodeName=" + this.nodeName + "]";
        }
    }
}

