/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import java.io.File;
import java.util.Set;
import javax.management.ObjectName;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public abstract class WasServerPlatformSupport
extends AbstractServerPlatformSupport {
    public static String ORACLE_ADMIN_SERVER_NAME = "oracle.admin.server.name";
    public static String WAS_CELL_NAME_PROPERTY = "was.cell.name";

    @Override
    public String getPlatformName() {
        return "websphere";
    }

    @Override
    public String getServerConfigDirectory(String string, String string2) throws PortabilityLayerException {
        return this.getServerConfigDirectory();
    }

    @Override
    public boolean isWebSphere() {
        return true;
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        if (this.serverName == null) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = adminService.getLocalServer();
            try {
                this.serverName = (String)adminService.getAttribute(objectName, "name");
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10003", new String[]{exception.getMessage()}), exception);
            }
        }
        return this.serverName;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName("WebSphere:*,type=AdminOperations");
                Set set = adminService.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    ObjectName objectName2 = (ObjectName)set.iterator().next();
                    this.serverLogPath = (String)adminService.invoke(objectName2, "expandVariable", (Object[])new String[]{"${LOG_ROOT}"}, new String[]{"java.lang.String"});
                    this.serverLogPath = this.serverLogPath + File.separator + this.getServerName();
                }
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10005", new String[]{exception.getMessage()}), exception);
            }
        }
        return this.serverLogPath;
    }

    @Override
    public String getDomainName() throws PortabilityLayerException {
        if (this.domainName == null) {
            this.domainName = System.getProperty(WAS_CELL_NAME_PROPERTY);
            if (this.domainName == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20012", new String[]{WAS_CELL_NAME_PROPERTY}));
            }
        }
        return this.domainName;
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier applicationIdentifier = null;
        try {
            String string = this.getApplicationName();
            applicationIdentifier = new ApplicationIdentifier(string, string, null);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{exception.getMessage()}), exception);
        }
        return applicationIdentifier;
    }

    public static boolean isND() throws PortabilityLayerException {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getNodeName();
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            String string2 = managedObjectMetadataHelper.getNodeBaseProductShortName(string);
            return string2.equalsIgnoreCase("ND");
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10026"), exception);
        }
    }

    private String getApplicationName() throws PortabilityLayerException {
        String string = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (int i = 0; string == null && i < 20; ++i) {
                string = this.getApplicationNameFromClassLoader(classLoader);
                ClassLoader classLoader2 = classLoader.getParent();
                if (classLoader2 != null && classLoader2 != classLoader) {
                    classLoader = classLoader2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return string;
    }

    private String getApplicationNameFromClassLoader(ClassLoader classLoader) {
        String string;
        int n;
        String string2 = null;
        String string3 = classLoader.toString().trim();
        while (string3.startsWith("\n") && string3.length() > 0) {
            string3 = string3.substring(1).trim();
        }
        String[] stringArray = string3.split("\n", 2);
        if (stringArray.length > 0 && (n = (string = stringArray[0].trim()).indexOf("[app:")) >= 0 && n + 5 < string.length()) {
            String string4 = string.substring(n + 5);
            int n2 = string4.indexOf(93);
            string2 = n2 > 0 ? string4.substring(0, n2) : string4;
        }
        return string2;
    }
}

