/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.as.jmx.framework.wls.spi.ComponentMBeans;
import oracle.as.jmx.framework.wls.spi.ServerLifeCycleListener;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.JRFServerLifeCycleListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JRFStartup {
    private static String DOMAIN_CONFIG_XML = "config/config.xml";
    private static String DOMAIN_CONFIG_SERVERS_DIR = "config/fmwconfig/servers";

    public static void main(String[] stringArray) throws PortabilityLayerException {
        try {
            JRFStartup.registerMBeanServerListener();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        File file = new File(JrfUtils.getCommonComponentsHome());
        File file2 = new File(JrfUtils.getDomainHome());
        File file3 = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        if (ServerPlatformSupportFactory.getInstance().isAdminServer()) {
            try {
                JRFStartup.initNewServersConfigDirs(file, file2, file3);
            }
            catch (PortabilityLayerException portabilityLayerException) {
                throw portabilityLayerException;
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10016", new String[]{file.getAbsolutePath(), file2.getAbsolutePath(), exception.getMessage()}), exception);
            }
            ComponentMBeans.addServerLifeCycleListener((ServerLifeCycleListener)new JRFServerLifeCycleListener(file3, file), (int)0);
        } else {
            String string = ServerPlatformSupportFactory.getInstance().getServerName();
            File file4 = new File(file2, DOMAIN_CONFIG_SERVERS_DIR + "/" + string);
            try {
                InternalJrfUtils.copyServerConfigTemplateToServerDir(file3, file, file4);
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(exception);
            }
        }
    }

    private static void initNewServersConfigDirs(File file, File file2, File file3) throws Exception {
        File file4 = new File(file2, DOMAIN_CONFIG_XML);
        File file5 = new File(file2, DOMAIN_CONFIG_SERVERS_DIR);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file4);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("server");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = null;
                NodeList nodeList2 = element2.getElementsByTagName("name");
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                Element element3 = (Element)nodeList2.item(0);
                string = element3.getFirstChild().getNodeValue().trim();
                File file6 = new File(file5, string);
                InternalJrfUtils.copyServerConfigTemplateToServerDir(file3, file, file6);
                InternalJrfUtils.mergeLoggersFromDir(file3, file6, new File(file6, "logging.xml"));
            }
        }
    }

    private static void registerMBeanServerListener() throws Exception {
        MBeanServer mBeanServer = JRFStartup.getRuntimeMBeanServer();
        MBeanServerNotificationListener mBeanServerNotificationListener = new MBeanServerNotificationListener();
        ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        mBeanServer.addNotificationListener(objectName, mBeanServerNotificationListener, null, null);
    }

    private static MBeanServer getRuntimeMBeanServer() throws NamingException {
        InitialContext initialContext = new InitialContext();
        MBeanServer mBeanServer = null;
        try {
            mBeanServer = (MBeanServer)initialContext.lookup("java:comp/env/jmx/runtime");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (mBeanServer == null) {
            mBeanServer = (MBeanServer)initialContext.lookup("java:comp/jmx/runtime");
        }
        return mBeanServer;
    }

    private static class MBeanServerNotificationListener
    implements NotificationListener {
        Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

        private MBeanServerNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof MBeanServerNotification) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                String string = mBeanServerNotification.getType();
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                String string2 = objectName.getKeyProperty("Type");
                if (string.equals("JMX.mbean.unregistered") && this.isSupportMbeanType(string2)) {
                    this.releaseApacheLog(Thread.currentThread().getContextClassLoader());
                }
            }
        }

        private boolean isSupportMbeanType(String string) {
            return "ApplicationRuntime".equals(string) || "EJBComponentRuntime".equals(string) || "WebAppComponentRuntime".equals(string) || "ServletRuntime".equals(string);
        }

        private void releaseApacheLog(ClassLoader classLoader) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass("org.apache.commons.logging.LogFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
            try {
                Method method = clazz.getMethod("release", ClassLoader.class);
                method.invoke(null, classLoader);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Apache LogFactory released " + classLoader);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }
}

