/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JRFService;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.NamedResource;

public class WlsJRFService
extends JRFService {
    private static final String EDIT_SERVICE_MBEAN = "com.bea:Name=EditService,Type=weblogic.management.mbeanservers.edit.EditServiceMBean";
    private static final String PROTOCOL = "wlx";
    private static final String JNDI = "/jndi/";
    private static final String EDITURI = "weblogic.management.mbeanservers.edit";
    private static final String DOMAINURI = "weblogic.management.mbeanservers.domainruntime";
    private Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

    private JMXConnector getJMXConnector(String string) throws Exception {
        JMXServiceURL jMXServiceURL = new JMXServiceURL(PROTOCOL, null, 0, JNDI + string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        return JMXConnectorFactory.newJMXConnector(jMXServiceURL, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyJRF(String string) throws Exception {
        String string2 = JrfUtils.getDomainHome();
        JMXConnector jMXConnector = this.getJMXConnector(EDITURI);
        jMXConnector.connect();
        try {
            MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            ObjectName objectName = new ObjectName(EDIT_SERVICE_MBEAN);
            ObjectName objectName2 = (ObjectName)mBeanServerConnection.getAttribute(objectName, "ConfigurationManager");
            ObjectName objectName3 = InternalJrfUtils.startEditSession(mBeanServerConnection, objectName2);
            ObjectName objectName4 = null;
            if ("*".equals(string)) {
                this.applyJRFToAllTargets(mBeanServerConnection, objectName2, objectName3, string2);
            } else {
                objectName4 = InternalJrfUtils.lookupMBean(mBeanServerConnection, objectName3, "lookupServer", string);
                if (objectName4 == null) {
                    objectName4 = InternalJrfUtils.lookupMBean(mBeanServerConnection, objectName3, "lookupCluster", string);
                    if (objectName4 != null) {
                        this.applyJRFToCluster(mBeanServerConnection, objectName2, objectName3, objectName4, string2);
                    }
                } else {
                    ObjectName objectName5 = (ObjectName)mBeanServerConnection.getAttribute(objectName4, "Cluster");
                    if (objectName5 == null) {
                        this.applyJRFToStandaloneServer(mBeanServerConnection, objectName2, objectName3, objectName4, string2);
                    } else {
                        objectName4 = objectName5;
                        this.applyJRFToCluster(mBeanServerConnection, objectName2, objectName3, objectName5, string2);
                    }
                }
                if (objectName4 == null) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10018", new String[]{string}));
                }
            }
            mBeanServerConnection.invoke(objectName2, "save", null, null);
            InternalJrfUtils.activate(mBeanServerConnection, objectName2);
        }
        finally {
            jMXConnector.close();
        }
    }

    private void applyJRFToAllTargets(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2, String string) throws Exception {
        for (ObjectName objectName3 : (ObjectName[])mBeanServerConnection.getAttribute(objectName2, "Servers")) {
            ObjectName objectName4 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Cluster");
            if (objectName4 != null) continue;
            this.applyJRFToStandaloneServer(mBeanServerConnection, objectName, objectName2, objectName3, string);
        }
        for (ObjectName objectName3 : (ObjectName[])mBeanServerConnection.getAttribute(objectName2, "Clusters")) {
            this.applyJRFToCluster(mBeanServerConnection, objectName, objectName2, objectName3, string);
        }
    }

    private void applyJRFToCluster(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2, ObjectName objectName3, String string) throws Exception {
        File file = new File(JrfUtils.getCommonComponentsHome());
        this.copyConfigsForCluster(mBeanServerConnection, objectName2, objectName3, string, file);
        this.configureTarget(mBeanServerConnection, objectName2, objectName3, true);
    }

    private void applyJRFToStandaloneServer(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2, ObjectName objectName3, String string) throws Exception {
        File file = new File(JrfUtils.getCommonComponentsHome());
        String string2 = (String)mBeanServerConnection.getAttribute(objectName3, "Name");
        File file2 = new File(new File(JrfUtils.getServersConfigDir(string)), string2);
        File file3 = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        InternalJrfUtils.copyServerConfigTemplateToServerDir(file3, file, file2);
        this.configureDiagnostics(mBeanServerConnection, objectName2, string2);
        this.configureTarget(mBeanServerConnection, objectName2, objectName3, false);
    }

    private void configureDiagnostics(MBeanServerConnection mBeanServerConnection, ObjectName objectName, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{String.class.getName()};
        ObjectName objectName2 = (ObjectName)mBeanServerConnection.invoke(objectName, "lookupServer", objectArray, stringArray);
        ObjectName objectName3 = (ObjectName)mBeanServerConnection.getAttribute(objectName2, "ServerDiagnosticConfig");
        Attribute attribute = new Attribute("DiagnosticContextEnabled", new Boolean(true));
        mBeanServerConnection.setAttribute(objectName3, attribute);
        ObjectName objectName4 = (ObjectName)mBeanServerConnection.getAttribute(objectName2, "WebServer");
        ObjectName objectName5 = (ObjectName)mBeanServerConnection.getAttribute(objectName4, "WebServerLog");
        Attribute attribute2 = new Attribute("LogFileFormat", new String("extended"));
        mBeanServerConnection.setAttribute(objectName5, attribute2);
        Attribute attribute3 = new Attribute("ELFFields", new String("date time cs-method ctx-ecid ctx-rid cs-uri sc-status bytes"));
        mBeanServerConnection.setAttribute(objectName5, attribute3);
    }

    private void configureTarget(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2, boolean bl) throws Exception {
        for (String[] stringArray : InternalJrfUtils.WL_TYPE_TO_MBEAN_LOOKUPSERVICE) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            List<? extends NamedResource> list = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(string, JRFTemplateHelper.getJRFTemplateForWLS());
            for (NamedResource namedResource : list) {
                String string3 = namedResource.getName();
                ObjectName objectName3 = InternalJrfUtils.lookupMBean(mBeanServerConnection, objectName, string2, string3);
                if (objectName3 == null) {
                    this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{string, string3, JrfUtils.getDomainHome()}));
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10017", new String[]{"applyJRF", JrfUtils.getDomainHome()}));
                }
                if (bl) {
                    String string4 = (String)mBeanServerConnection.getAttribute(objectName2, "Name");
                    for (ObjectName objectName4 : (ObjectName[])mBeanServerConnection.getAttribute(objectName, "Servers")) {
                        String string5;
                        ObjectName objectName5 = (ObjectName)mBeanServerConnection.getAttribute(objectName4, "Cluster");
                        if (objectName5 == null || !(string5 = (String)mBeanServerConnection.getAttribute(objectName5, "Name")).equals(string4)) continue;
                        InternalJrfUtils.removeTarget(mBeanServerConnection, objectName3, objectName4);
                    }
                }
                InternalJrfUtils.addTarget(mBeanServerConnection, objectName3, objectName2);
            }
        }
    }

    private void copyConfigsForCluster(MBeanServerConnection mBeanServerConnection, ObjectName objectName, ObjectName objectName2, String string, File file) throws Exception {
        String string2 = (String)mBeanServerConnection.getAttribute(objectName2, "Name");
        for (ObjectName objectName3 : (ObjectName[])mBeanServerConnection.getAttribute(objectName, "Servers")) {
            String string3;
            ObjectName objectName4 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Cluster");
            if (objectName4 == null || !(string3 = (String)mBeanServerConnection.getAttribute(objectName4, "Name")).equals(string2)) continue;
            String string4 = (String)mBeanServerConnection.getAttribute(objectName3, "Name");
            File file2 = new File(new File(JrfUtils.getServersConfigDir(string)), string4);
            File file3 = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
            InternalJrfUtils.copyServerConfigTemplateToServerDir(file3, file, file2);
        }
    }

    @Override
    public boolean checkIfJRFApplied(String string) throws Exception {
        return this.checkIfJRFAppliedOnMutipleTargets(new String[]{string}).get(string) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> checkIfJRFAppliedOnMutipleTargets(String[] stringArray) throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        JMXConnector jMXConnector = this.getJMXConnector(DOMAINURI);
        jMXConnector.connect();
        try {
            MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            ObjectName objectName = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            ObjectName objectName2 = (ObjectName)mBeanServerConnection.getAttribute(objectName, "DomainConfiguration");
            ResourceChecker resourceChecker = new ResourceChecker("startup-class", "lookupStartupClass", mBeanServerConnection, objectName2);
            ResourceChecker resourceChecker2 = new ResourceChecker("library", "lookupLibrary", mBeanServerConnection, objectName2);
            for (String string : stringArray) {
                try {
                    String string2 = string;
                    ObjectName objectName3 = (ObjectName)mBeanServerConnection.invoke(objectName2, "lookupServer", new Object[]{string}, new String[]{"java.lang.String"});
                    if (objectName3 != null) {
                        ObjectName objectName4 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Cluster");
                        if (objectName4 != null) {
                            string2 = (String)mBeanServerConnection.getAttribute(objectName4, "Name");
                        }
                    } else if (mBeanServerConnection.invoke(objectName2, "lookupCluster", new Object[]{string}, new String[]{"java.lang.String"}) == null) {
                        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{string}));
                    }
                    if (!resourceChecker.checkResourcesOnTarget(string2)) {
                        hashMap.put(string, 0);
                        continue;
                    }
                    if (!resourceChecker.checkResourcesOnTarget(string2)) {
                        hashMap.put(string, 0);
                        continue;
                    }
                    hashMap.put(string, 1);
                }
                catch (Exception exception) {
                    this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20036", new String[]{string, exception.getMessage()}));
                    hashMap.put(string, -1);
                }
            }
        }
        finally {
            jMXConnector.close();
        }
        return hashMap;
    }

    private class ResourceChecker {
        String resourceType;
        String lookupService;
        MBeanServerConnection conn;
        ObjectName domainConfig;
        String missingComponentName;
        Map<String, List<String>> resourceTargets;

        public ResourceChecker(String string, String string2, MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
            this.resourceType = string;
            this.lookupService = string2;
            this.conn = mBeanServerConnection;
            this.domainConfig = objectName;
        }

        public boolean checkResourcesOnTarget(String string) throws Exception {
            if (this.resourceTargets == null) {
                String string2 = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(this.resourceType, JRFTemplateHelper.getJRFTemplateForWLS()).get(0).getName();
                if (!this.checkResourceOnTarget(string, string2, this.getResourceTargetsFor(string2))) {
                    WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, string2, string}));
                    return false;
                }
                this.loadResourceTargets();
            }
            for (Map.Entry entry : this.resourceTargets.entrySet()) {
                String string3 = (String)entry.getKey();
                if (this.checkResourceOnTarget(string, string3, (List)entry.getValue())) continue;
                WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, string3, string}));
                return false;
            }
            return true;
        }

        private boolean checkResourceOnTarget(String string, String string2, List<String> list) throws Exception {
            if (this.missingComponentName != null) {
                WlsJRFService.this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{this.resourceType, this.missingComponentName, "*"}));
                return false;
            }
            return list.contains(string);
        }

        private List<String> getResourceTargetsFor(String string) throws Exception {
            ObjectName objectName = (ObjectName)this.conn.invoke(this.domainConfig, this.lookupService, new Object[]{string}, new String[]{"java.lang.String"});
            if (objectName == null) {
                this.missingComponentName = string;
                return null;
            }
            ObjectName[] objectNameArray = (ObjectName[])this.conn.getAttribute(objectName, "Targets");
            ArrayList<String> arrayList = new ArrayList<String>(objectNameArray.length);
            for (ObjectName objectName2 : objectNameArray) {
                arrayList.add((String)this.conn.getAttribute(objectName2, "Name"));
            }
            return arrayList;
        }

        private void loadResourceTargets() throws Exception {
            List<? extends NamedResource> list = JRFTemplateHelper.getJRFManagedResourcesFromTemplate(this.resourceType, JRFTemplateHelper.getJRFTemplateForWLS());
            this.resourceTargets = new HashMap<String, List<String>>(list.size());
            for (NamedResource namedResource : list) {
                String string = namedResource.getName();
                this.resourceTargets.put(string, this.getResourceTargetsFor(string));
                if (this.missingComponentName == null) continue;
                return;
            }
            this.conn = null;
            this.lookupService = null;
            this.domainConfig = null;
        }
    }
}

