/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.net.UnknownHostException;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.WlsServerPlatformSupport;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebServerMBean;

public final class WlsPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private String serverName;
    private String serverHost;
    private String clusterName;
    private String clusterJndiAddress;

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "t3", "t3s", "iiop", "iiops"};
    }

    WlsPortConfig() throws Exception {
        ServerMBean serverMBean = WlsServerPlatformSupport.getLocalServerMBean();
        this.initialize(serverMBean);
    }

    WlsPortConfig(String string) throws Exception {
        ServerMBean serverMBean = WlsServerPlatformSupport.getServerMBean(string);
        if (serverMBean == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{string}));
        }
        this.initialize(serverMBean);
    }

    private void initialize(ServerMBean serverMBean) throws Exception {
        Object object;
        ClusterMBean clusterMBean;
        this.serverName = serverMBean.getName();
        this.serverHost = serverMBean.getListenAddress();
        if (this.serverHost == null || this.serverHost.trim().isEmpty()) {
            this.serverHost = this.getLocalHost();
        }
        if ((clusterMBean = serverMBean.getCluster()) != null) {
            this.clusterName = serverMBean.getName();
            object = clusterMBean.getClusterAddress();
            if (object != null && !((String)object).trim().isEmpty()) {
                this.clusterJndiAddress = object;
            }
            this.initClusterFrontendWebPorts(clusterMBean);
            for (ServerMBean serverMBean2 : clusterMBean.getServers()) {
                this.initPorts(serverMBean2);
            }
        } else {
            this.initPorts(serverMBean);
        }
        object = new File(ServerPlatformSupportFactory.getInstance().getServerConfigDirectory());
        this.parsePortConfigPropertiesFile(new File(((File)object).getParentFile(), this.serverName));
    }

    private void initClusterFrontendWebPorts(ClusterMBean clusterMBean) throws UnknownHostException {
        String string = clusterMBean.getFrontendHost();
        if (string != null && !string.isEmpty()) {
            Integer n = clusterMBean.getFrontendHTTPPort();
            if (n != null && n > 0) {
                this.setClusterFrontEndHttpPort(new Port("http", string, n, this));
            }
            if ((n = Integer.valueOf(clusterMBean.getFrontendHTTPSPort())) != null && n > 0) {
                this.setClusterFrontEndHttpSslPort(new Port("https", string, n, this));
            }
        }
    }

    private void initPorts(ServerMBean serverMBean) throws UnknownHostException {
        this.initJndiPorts(serverMBean);
        this.initServerWebPorts(serverMBean);
    }

    private void initJndiPorts(ServerMBean serverMBean) throws UnknownHostException {
        SSLMBean sSLMBean;
        String string = serverMBean.getListenAddress();
        if (string == null || string.trim().isEmpty()) {
            string = this.getLocalHost();
        }
        if ((sSLMBean = serverMBean.getSSL()).isEnabled() && sSLMBean.isListenPortEnabled()) {
            this.addJndiPortHelper(serverMBean, string, "t3s", sSLMBean.getListenPort());
            if (serverMBean.isIIOPEnabled()) {
                this.addJndiPortHelper(serverMBean, string, "iiops", sSLMBean.getListenPort());
            }
        }
        if (serverMBean.isListenPortEnabled()) {
            this.addJndiPortHelper(serverMBean, string, "t3", serverMBean.getListenPort());
            if (serverMBean.isIIOPEnabled()) {
                this.addJndiPortHelper(serverMBean, string, "iiop", serverMBean.getListenPort());
            }
        }
    }

    private void addJndiPortHelper(ServerMBean serverMBean, String string, String string2, int n) throws UnknownHostException {
        Port port = new Port(string2, string, n, this);
        if (this.serverName.equals(serverMBean.getName())) {
            this.addServerPort(port);
        }
        if (this.isClustered()) {
            this.addClusterMemberPort(port);
        }
    }

    private void initServerWebPorts(ServerMBean serverMBean) throws UnknownHostException {
        Integer n;
        Port port = null;
        Port port2 = null;
        Port port3 = null;
        Port port4 = null;
        WebServerMBean webServerMBean = serverMBean.getWebServer();
        String string = webServerMBean.getFrontendHost();
        if (string != null && !string.isEmpty()) {
            n = webServerMBean.getFrontendHTTPPort();
            if (n != null && n > 0) {
                port = new Port("http", string, n, this);
            }
            if ((n = Integer.valueOf(webServerMBean.getFrontendHTTPSPort())) != null && n > 0) {
                port2 = new Port("https", string, n, this);
            }
        }
        if ((string = serverMBean.getListenAddress()) == null || string.trim().isEmpty()) {
            string = this.getLocalHost();
        }
        if (serverMBean.isListenPortEnabled()) {
            port3 = new Port("http", string, serverMBean.getListenPort(), this);
        }
        if ((n = serverMBean.getSSL()).isEnabled()) {
            port4 = new Port("https", string, n.getListenPort(), this);
        }
        if (this.serverName.equals(serverMBean.getName())) {
            this.addServerPort(port3);
            this.addServerPort(port4);
            this.setFrontEndHttpPort(port);
            this.setFrontEndHttpSslPort(port2);
        }
        if (this.isClustered()) {
            if (port3 != null) {
                this.addClusterMemberPort(port3);
            }
            if (port4 != null) {
                this.addClusterMemberPort(port4);
            }
        }
    }

    @Override
    public boolean isClustered() {
        return this.clusterName != null;
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"t3", "iiop"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return new String[]{"t3s", "iiops"};
    }

    @Override
    public String getJndiProviderURL() {
        String string = this.getClusterAddrJndiProviderURL(this.getDefaultJndiProtocols());
        return string == null ? super.getJndiProviderURL() : string;
    }

    @Override
    public String getJndiSslProviderURL() {
        String string = this.getClusterAddrJndiProviderURL(this.getDefaultJndiSslProtocols());
        return string == null ? super.getJndiSslProviderURL() : string;
    }

    private String getClusterAddrJndiProviderURL(String[] stringArray) {
        if (this.clusterJndiAddress != null) {
            for (String string : stringArray) {
                Port port = this.getServerPort(string);
                if (port == null) continue;
                if (this.clusterJndiAddress.indexOf(44) > 0) {
                    return null;
                }
                int n = this.clusterJndiAddress.indexOf(58);
                if (n > 0) {
                    String string2 = this.clusterJndiAddress.substring(0, n);
                    return port.getProtocol() + "://" + string2 + ":" + port.getPort();
                }
                return port.getProtocol() + "://" + this.clusterJndiAddress + ":" + port.getPort();
            }
        }
        return null;
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener notificationListener) {
        ServerMBean serverMBean = WlsServerPlatformSupport.getLocalServerMBean();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null) {
            AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("FrontendHost");
            attributeChangeNotificationFilter.enableAttribute("FrontendHTTPPort");
            attributeChangeNotificationFilter.enableAttribute("FrontendHTTPSPort");
            attributeChangeNotificationFilter.enableAttribute("Servers");
            clusterMBean.addNotificationListener(notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
            for (ServerMBean serverMBean2 : clusterMBean.getServers()) {
                this.registerPortConfigChangeListener(serverMBean2, notificationListener);
            }
        } else {
            this.registerPortConfigChangeListener(serverMBean, notificationListener);
        }
    }

    private void registerPortConfigChangeListener(ServerMBean serverMBean, NotificationListener notificationListener) {
        AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
        attributeChangeNotificationFilter.enableAttribute("ListenPort");
        attributeChangeNotificationFilter.enableAttribute("ListenPortEnabled");
        attributeChangeNotificationFilter.enableAttribute("ListenAddress");
        attributeChangeNotificationFilter.enableAttribute("IIOPEnabled");
        attributeChangeNotificationFilter.enableAttribute("Cluster");
        serverMBean.addNotificationListener(notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
        SSLMBean sSLMBean = serverMBean.getSSL();
        attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
        attributeChangeNotificationFilter.enableAttribute("ListenPort");
        attributeChangeNotificationFilter.enableAttribute("Enabled");
        sSLMBean.addNotificationListener(notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
        WebServerMBean webServerMBean = serverMBean.getWebServer();
        if (webServerMBean != null) {
            attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute("FrontendHost");
            attributeChangeNotificationFilter.enableAttribute("FrontendHTTPPort");
            attributeChangeNotificationFilter.enableAttribute("FrontendHTTPSPort");
            webServerMBean.addNotificationListener(notificationListener, (NotificationFilter)attributeChangeNotificationFilter, null);
        }
    }
}

