/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.WlsPortConfig;
import weblogic.application.ApplicationAccess;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;

public class WlsServerPlatformSupport
extends AbstractServerPlatformSupport {
    @Override
    public String getPlatformName() {
        return "weblogic";
    }

    @Override
    public boolean isWebLogic() {
        return true;
    }

    @Override
    public String getServerConfigDirectory(String string, String string2) throws PortabilityLayerException {
        return JrfUtils.getServersConfigDir(string) + File.separator + string2;
    }

    @Override
    public String getDomainName() throws PortabilityLayerException {
        if (this.domainName == null) {
            this.domainName = ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomainName();
        }
        return this.domainName;
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        if (this.serverName == null) {
            this.serverName = System.getProperty("weblogic.Name");
        }
        return this.serverName;
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        if (this.adminServerName == null) {
            return ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getAdminServerName();
        }
        return this.adminServerName;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            try {
                final MBeanServer mBeanServer = this.getRuntimeMBeanServer();
                String string = "com.bea:Type=Log,Name=" + this.getServerName() + ",Server=" + this.getServerName();
                ObjectName objectName = new ObjectName(string);
                Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    final ObjectName objectName2 = set.iterator().next();
                    AuthenticatedSubject authenticatedSubject = WlsServerPlatformSupport.getKernelIdentity();
                    PrivilegedExceptionAction<Object> privilegedExceptionAction = new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return mBeanServer.invoke(objectName2, "computeLogFilePath", null, null);
                        }
                    };
                    this.serverLogPath = (String)authenticatedSubject.doAs((AbstractSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new PortabilityLayerException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new PortabilityLayerException(exception);
            }
        }
        return new File(this.serverLogPath).getParent();
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier applicationIdentifier = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ApplicationAccess applicationAccess = ApplicationAccess.getApplicationAccess();
            String string = applicationAccess.getApplicationName(classLoader);
            String string2 = applicationAccess.getApplicationVersion(classLoader);
            String string3 = string;
            if (string2 != null) {
                string3 = string3 + "#" + string2;
            }
            applicationIdentifier = new ApplicationIdentifier(string, string3, string2);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{exception.getMessage()}), exception);
        }
        return applicationIdentifier;
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        ClusterMBean clusterMBean = WlsServerPlatformSupport.getLocalServerMBean().getCluster();
        if (clusterMBean != null) {
            return clusterMBean.getName();
        }
        return null;
    }

    @Override
    public PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new WlsPortConfig();
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    protected static ServerMBean getLocalServerMBean() {
        return ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getServer();
    }

    protected static ServerMBean getServerMBean(String string) throws PortabilityLayerException {
        ServerMBean serverMBean = null;
        for (ServerMBean serverMBean2 : ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomain().getServers()) {
            if (!serverMBean2.getName().equals(string)) continue;
            serverMBean = serverMBean2;
        }
        if (serverMBean == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{string}));
        }
        return serverMBean;
    }

    private MBeanServer getRuntimeMBeanServer() {
        return ManagementService.getRuntimeMBeanServer((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity());
    }

    private static AuthenticatedSubject getKernelIdentity() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    @Override
    public PortConfig getPortConfig(String string) throws PortabilityLayerException {
        if (this.getServerName().equals(string)) {
            return this.getPortConfig();
        }
        try {
            return new WlsPortConfig(string);
        }
        catch (Exception exception) {
            throw new PortabilityLayerException(exception);
        }
    }

    @Override
    public boolean isExalogicOptimizationsEnabled() {
        if (this.isExalogicOptimizationsEnabled == null) {
            this.isExalogicOptimizationsEnabled = ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomain().isExalogicOptimizationsEnabled();
        }
        return this.isExalogicOptimizationsEnabled;
    }
}

