/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startup;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.raptor.startup.HomeUtils;
import oracle.ide.osgi.boot.api.OJStartupHook;

public class HomeSupport
implements OJStartupHook {
    private static final String VER_FULL = "VER_FULL";
    private static final String VERSION_PROPERTIES_FILENAME = "version.properties";
    private static final String IDE_USER_DIR = "ide.user.dir";
    private static final String IDE_CONF = "ide.conf";
    public static String OCI_AVAILABLE = "sqldeveloper.oci.available";
    public static String HOME_LOCATION = "sqldeveloper.oracle.home";
    public static String INSTANT_CLIENT_LOCATION = "sqldeveloper.instantclient.home";
    private static final String PRODUCT_HOME = "oracle.product.home";
    private static final String CONFIG_FILE_FORMAT = "home_{0}.properties";
    private static Logger LOG = Logger.getLogger(HomeSupport.class.getName());
    private File m_productHome;

    public void onStartup(String[] stringArray) {
        this.m_productHome = new File(System.getProperty(PRODUCT_HOME));
        this.initializeMacros();
    }

    private void initializeMacros() {
        HomeState homeState = null;
        Properties properties = this.getHomeConfig();
        if (properties != null) {
            File file;
            File file2;
            File file3;
            Object object;
            String string = properties.getProperty(HOME_LOCATION);
            if (string != null) {
                object = new File(string);
                file3 = new File((File)object, "jdbc/lib");
                file2 = new File((File)object, "rdbms/jlib");
                file = new File((File)object, "jlib");
                File file4 = new File((File)object, HomeUtils.getPlatformLibraryDirectory());
                homeState = new HomeState(file, file3, file2, file4);
            }
            if (homeState == null && (object = properties.getProperty(INSTANT_CLIENT_LOCATION)) != null) {
                file3 = new File((String)object);
                file2 = HomeUtils.getPath(file3, "xdb6.jar");
                file = file2.exists() ? file3 : HomeUtils.getPath(this.m_productHome, "rdbms/jlib");
                homeState = new HomeState(HomeUtils.getPath(this.m_productHome, "jlib"), file3, file, file3);
            }
        }
        if (homeState == null) {
            // empty if block
        }
        if (homeState == null || !homeState.isValid()) {
            homeState = this.getDefaultHomeState();
        }
        homeState.configureEnvironment();
        if (homeState.isBinConfigured()) {
            LOG.info("Valid OCI bin directory located at: " + homeState.m_bin);
        } else {
            LOG.warning("Invalid OCI bin directory located at: " + homeState.m_bin);
        }
    }

    private Properties getHomeConfig() {
        Properties properties = null;
        String string = System.getProperty(IDE_CONF);
        if (string == null) {
            LOG.severe("ide.conf not defined");
            return null;
        }
        String string2 = System.getProperty(IDE_USER_DIR);
        if (string2 == null) {
            LOG.severe("ide.user.dir not defined");
            return null;
        }
        File file = new File(string);
        File file2 = file.getParentFile();
        File file3 = new File(file2, VERSION_PROPERTIES_FILENAME);
        if (file3.exists()) {
            Properties properties2 = new Properties();
            try {
                File file4;
                File file5;
                properties2.load(new FileReader(file3));
                String string3 = properties2.getProperty(VER_FULL);
                if (string3 != null && (file5 = new File(string2)).exists() && file5.isDirectory() && (file4 = new File(file5, HomeSupport.getConfigFileName(string3))).exists()) {
                    properties = new Properties();
                    properties.load(new FileReader(file4));
                }
            }
            catch (IOException iOException) {
                LOG.severe(iOException.getLocalizedMessage());
                properties = null;
            }
        }
        return properties;
    }

    public static String getConfigFileName(String string) {
        return MessageFormat.format(CONFIG_FILE_FORMAT, string);
    }

    private HomeState getDefaultHomeState() {
        return new HomeState(HomeUtils.getPath(this.m_productHome, "jlib"), HomeUtils.getPath(this.m_productHome, "jdbc/lib"), HomeUtils.getPath(this.m_productHome, "rdbms/jlib"), null);
    }

    private static final class HomeState {
        protected static final String NLS_MACRO = "orai18n.library.dir";
        protected static final String JDBC_MACRO = "jdbc.library";
        protected static final String XDB_MACRO = "xdb.library";
        private File m_nls;
        private File m_jdbc;
        private File m_xdb;
        private File m_bin;

        HomeState(File file, File file2, File file3, File file4) {
            this.m_nls = file;
            this.m_jdbc = HomeUtils.getPath(file2, "ojdbc6.jar");
            this.m_xdb = HomeUtils.getPath(file3, "xdb6.jar");
            this.m_bin = file4;
        }

        public final void configureEnvironment() {
            System.setProperty(NLS_MACRO, this.m_nls.getAbsolutePath());
            System.setProperty(JDBC_MACRO, this.m_jdbc.getAbsolutePath());
            System.setProperty(XDB_MACRO, this.m_xdb.getAbsolutePath());
            System.setProperty(OCI_AVAILABLE, Boolean.toString(this.isBinConfigured()));
        }

        public boolean isBinConfigured() {
            if (this.m_bin != null) {
                File file = this.m_bin;
                try {
                    file = this.m_bin.getCanonicalFile();
                }
                catch (IOException iOException) {
                    LOG.severe(iOException.getLocalizedMessage());
                }
                String string = System.getProperty("java.library.path");
                if (string != null) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(File.pathSeparator)) {
                        File file2 = new File(string2);
                        try {
                            if (file2.getCanonicalFile().equals(file)) {
                                return true;
                            }
                        }
                        catch (IOException iOException) {
                            LOG.severe(iOException.getLocalizedMessage());
                        }
                    }
                }
            }
            return false;
        }

        public boolean isValid() {
            return this.m_nls.exists() && this.m_jdbc.exists() && this.m_xdb.exists();
        }
    }
}

